/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IProcessAreaScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.ITeamAreaPrivateScope;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;

public class ReadScopeWrapper
extends PlatformObject {
    private final IReadScope fScope;
    private IAuditable fContext = null;

    private ReadScopeWrapper(IReadScope readScope) {
        this.fScope = readScope;
    }

    public static ReadScopeWrapper newWrapper(IReadScope scope) {
        return new ReadScopeWrapper(scope);
    }

    public static ReadScopeWrapper newWrapper(IReadScope scope, IAuditable context) {
        ReadScopeWrapper wrapper = ReadScopeWrapper.newWrapper(scope);
        wrapper.setContext(context);
        return wrapper;
    }

    public IAuditableHandle getContextHandle() {
        if (this.fContext != null) {
            return this.fContext;
        }
        if (this.fScope instanceof IContributorDeferringScope) {
            return ((IContributorDeferringScope)this.fScope).getScope();
        }
        if (this.fScope instanceof IProcessAreaScope) {
            return ((IProcessAreaScope)this.fScope).getProcessArea();
        }
        if (this.fScope instanceof AccessGroupScope) {
            return ((AccessGroupScope)this.fScope).getAccessGroup();
        }
        if (this.fScope instanceof ITeamAreaPrivateScope) {
            return ((ITeamAreaPrivateScope)this.fScope).getTeamArea();
        }
        return null;
    }

    private void setContext(IAuditable context) {
        this.fContext = context;
    }

    public String shortDescription() {
        return IReadScopeDescriber.FACTORY.shortDescription(this.fScope);
    }

    public static IViewerLabelProvider getLabelProvider() {
        return new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof ReadScopeWrapper) {
                    ReadScopeWrapper wrapper = (ReadScopeWrapper)((Object)element);
                    IAuditableHandle contextHandle = wrapper.getContextHandle();
                    String shortDescription = wrapper.shortDescription();
                    if (contextHandle == null || !contextHandle.hasFullState()) {
                        label.setText(shortDescription);
                    } else {
                        String name = null;
                        if (contextHandle instanceof IProcessArea) {
                            name = ((IProcessArea)contextHandle).getName();
                        } else if (contextHandle instanceof IContributor) {
                            name = ((IContributor)contextHandle).getName();
                        } else if (contextHandle instanceof IAccessGroup) {
                            name = ((IAccessGroup)contextHandle).getName();
                        }
                        if (name != null) {
                            label.setText(NLS.bind((String)Messages.WorkspaceComponentLabelProvider_0, (Object)shortDescription, (Object[])new Object[]{name}));
                        } else {
                            label.setText(shortDescription);
                        }
                    }
                }
            }
        };
    }
}

