/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.ui.domain.BaselineQueryItemQuery;
import com.ibm.team.filesystem.ui.domain.SnapshotQueryItemQuery;
import com.ibm.team.filesystem.ui.domain.WorkspaceQueryItemQuery;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.LockQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotQueryWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceQueryWrapper;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IQueryItem;
import org.eclipse.core.runtime.Assert;

public class QueryItemWrapper
extends AbstractWrapper {
    private ITeamRepository fRepo;
    private IQueryItem fQuery;

    public QueryItemWrapper(ITeamRepository repo, IQueryItem query) {
        super((IItem)query);
        this.fRepo = repo;
        this.fQuery = query;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.fRepo;
    }

    public final IQueryItem getQueryItem() {
        return (IQueryItem)this.getItem();
    }

    public static QueryItemWrapper newWrapper(ITeamRepository repo, IQueryItem query) {
        Assert.isLegal((repo != null ? 1 : 0) != 0);
        Assert.isLegal((query != null ? 1 : 0) != 0);
        QueryItemWrapper wrapper = 3 == query.getType() ? new ChangeSetQueryWrapper(repo, query) : (1 == query.getType() ? new BaselineQueryWrapper(repo, query) : (4 == query.getType() ? new ComponentQueryWrapper(repo, query) : (2 == query.getType() ? new SnapshotQueryWrapper(repo, query) : (5 == query.getType() ? new WorkspaceQueryWrapper(repo, query) : new QueryItemWrapper(repo, query)))));
        return wrapper;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IQueryItem.class) {
            return this.getQueryItem();
        }
        if (adapter == IItemHandle.class) {
            return this.getQueryItem();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fRepo == null ? 0 : this.fRepo.getRepositoryURI().hashCode());
        result = 31 * result + (this.fQuery == null ? 0 : this.fQuery.getItemId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        QueryItemWrapper other = (QueryItemWrapper)((Object)obj);
        if (this.fRepo == null ? other.fRepo != null : !this.fRepo.getRepositoryURI().equals(other.fRepo.getRepositoryURI())) {
            return false;
        }
        return !(this.fQuery == null ? other.fQuery != null : !this.fQuery.sameItemId((IItemHandle)other.fQuery));
    }

    public ISetWithListeners getQuery(ConnectedProjectAreaRegistry registry, IOperationRunner opRunner) {
        if (this instanceof BaselineQueryWrapper) {
            BaselineQueryWrapper wrapper = (BaselineQueryWrapper)this;
            return new BaselineQueryItemQuery(wrapper, opRunner);
        }
        boolean cfr_ignored_0 = this instanceof ChangeSetQueryWrapper;
        boolean cfr_ignored_1 = this instanceof ComponentQueryWrapper;
        boolean cfr_ignored_2 = this instanceof LockQueryWrapper;
        if (this instanceof SnapshotQueryWrapper) {
            SnapshotQueryWrapper wrapper = (SnapshotQueryWrapper)this;
            return new SnapshotQueryItemQuery(wrapper, opRunner);
        }
        if (this instanceof WorkspaceQueryWrapper) {
            WorkspaceQueryWrapper wrapper = (WorkspaceQueryWrapper)this;
            return new WorkspaceQueryItemQuery(wrapper, registry, opRunner);
        }
        return null;
    }
}

