/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.ui.wrapper.ComponentHierarchyData;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.util.Util;

public class MissingWorkspaceComponentWrapper
extends PlatformObject
implements IHierarchicalComponentWrapper {
    private final IWorkspaceConnection fWorkspaceConnection;
    private final IComponentHandle fComponentHandle;
    private final IComponent fComponent;
    private ComponentHierarchyData fHierarchyData;

    public MissingWorkspaceComponentWrapper(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IComponent component) {
        Assert.isNotNull((Object)workspaceConnection, (String)"IWorkspaceConnection workspaceConnection cannot be null.");
        Assert.isNotNull((Object)componentHandle, (String)"IComponent component cannot be null.");
        if (component != null) {
            Assert.isTrue((boolean)componentHandle.sameItemId((IItemHandle)component), (String)"The componentHandle and component must be the same component.");
        }
        this.fWorkspaceConnection = workspaceConnection;
        this.fComponentHandle = componentHandle;
        this.fComponent = component;
        this.fHierarchyData = null;
    }

    @Override
    public ITeamRepository getRepository() {
        return this.fWorkspaceConnection.teamRepository();
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.fWorkspaceConnection.getResolvedWorkspace();
    }

    @Override
    public IWorkspaceConnection getWorkspaceConnection() {
        return this.fWorkspaceConnection;
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getWorkspace();
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspaceConnection();
    }

    @Override
    public IComponentHandle getComponentHandle() {
        return this.fComponentHandle;
    }

    @Override
    public IComponent getComponent() {
        return this.fComponent;
    }

    @Override
    public IComponentHandle getWrappedItemHandle() {
        return this.getComponentHandle();
    }

    public ComponentHierarchyData getHierarchyData() {
        return this.fHierarchyData;
    }

    @Override
    public void createHierarchyData(IComponentHierarchyNode node, IHierarchicalComponentWrapper parent) {
        this.fHierarchyData = new ComponentHierarchyData(node, parent, this);
    }

    @Override
    public boolean canAddSubcomponents() {
        return false;
    }

    @Override
    public boolean canRemoveAsSubcomponent() {
        return !this.getWorkspaceConnection().isStream();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MissingWorkspaceComponentWrapper)) {
            return false;
        }
        MissingWorkspaceComponentWrapper other = (MissingWorkspaceComponentWrapper)obj;
        if (this.fHierarchyData != null && other.fHierarchyData == null || this.fHierarchyData == null && other.fHierarchyData != null) {
            return false;
        }
        if (((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).isBranchContainsCycles() != ((IComponentHierarchyNode)other.fHierarchyData.getHierarchyNode()).isBranchContainsCycles()) {
            return false;
        }
        if (((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).isInCycle() != ((IComponentHierarchyNode)other.fHierarchyData.getHierarchyNode()).isInCycle()) {
            return false;
        }
        Object hierarcyNode = this.fHierarchyData.getHierarchyNode();
        Object otherHierarcyNode = other.fHierarchyData.getHierarchyNode();
        return Util.equals((Object)this.fWorkspaceConnection, (Object)other.fWorkspaceConnection) && this.fComponentHandle.sameItemId((IItemHandle)other.fComponentHandle) && hierarcyNode.getAncestorPath().equals(otherHierarcyNode.getAncestorPath());
    }

    public int hashCode() {
        int prime = 31;
        int result = prime * Util.hashCode((Object)this.fWorkspaceConnection);
        result += Util.hashCode((Object)this.fComponentHandle.getItemId());
        return result += Util.hashCode((Object)((IComponentHierarchyNode)this.fHierarchyData.getHierarchyNode()).getAncestorPath());
    }

    @Override
    public void setMoveResult(ComponentHierarchyCompareResult.MovedComponentResult result) {
    }

    @Override
    public ComponentHierarchyCompareResult.MovedComponentResult getMoveResult() {
        return null;
    }

    @Override
    public void setStructuralChangesComponentNode(StructuralChangesComponentNode node) {
    }

    @Override
    public StructuralChangesComponentNode getStructuralChangesComponentNode() {
        return null;
    }

    @Override
    public void setForcedCanAddSubcomponentsValue(Boolean value) {
    }

    @Override
    public void setForcedCanRemoveAsSubcomponentValue(Boolean value) {
    }

    @Override
    public void setForcedCanRemoveComponentValue(Boolean value) {
    }
}

