/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.ui.wrapper.IConfigurationWrapper;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IHierarchyNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public abstract class HierarchyData<N extends IHierarchyNode, H extends IItemHandle, W extends IConfigurationWrapper> {
    private N fNode;
    private W fParent;
    private W fSelf;
    private List<W> fChildren;

    public HierarchyData(N node, W parent, W self) {
        Assert.isNotNull(node, (String)"node cannot be null.");
        Assert.isNotNull(self, (String)"self cannot be null.");
        Assert.isTrue((boolean)self.getWrappedItemHandle().sameItemId(node.getElementHandle()), (String)"node and self must represent the same component.");
        this.fNode = node;
        this.fParent = parent;
        this.fSelf = self;
        this.fChildren = new ArrayList<W>();
    }

    public void setChildren(List<W> children) {
        if (children != null) {
            HashSet<UUID> childrenUuids = new HashSet<UUID>();
            for (IHierarchyNode childNode : this.fNode.getChildren()) {
                UUID childUuid = childNode.getElementHandle().getItemId();
                childrenUuids.add(childUuid);
            }
            Assert.isTrue((children.size() == childrenUuids.size() ? 1 : 0) != 0);
            for (IConfigurationWrapper childWrapper : children) {
                Assert.isTrue((boolean)childrenUuids.contains(childWrapper.getWrappedItemHandle().getItemId()));
                Assert.isTrue((boolean)this.fSelf.getWrappedItemHandle().sameItemId(childWrapper.getHierarchyData().getParent().getWrappedItemHandle()));
            }
            this.fChildren = children;
        }
    }

    public W getConfigurationWrapper() {
        return this.fSelf;
    }

    public W getParent() {
        return this.fParent;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public List<W> getChildren() {
        return this.fChildren;
    }

    public boolean isInCycle() {
        return this.fNode.isInCycle();
    }

    public boolean isBranchContainsCycles() {
        return this.fNode.isBranchContainsCycles();
    }

    public N getHierarchyNode() {
        return this.fNode;
    }
}

