/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComponentWrapper
extends AbstractWrapper {
    private ITeamRepository fRepo;
    private IComponent fComponent;
    private boolean allowSuspendedChangeSetChildren;

    public ComponentWrapper(ITeamRepository repo, IComponent component) {
        super((IItem)component);
        this.fRepo = repo;
        this.fComponent = component;
    }

    public static ComponentWrapper createFrom(ITeamRepository repo, ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        return ComponentWrapper.createFrom((ItemLocator<IComponent>)ItemLocator.create((ITeamRepository)repo, component), monitor);
    }

    public static ComponentWrapper createFrom(ItemLocator<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = component.getNamespace().getRepository();
        IComponent fullComponentState = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)component.getItemId(), (IProgressMonitor)monitor);
        return new ComponentWrapper(repo, fullComponentState);
    }

    public IComponent getComponent() {
        return this.fComponent;
    }

    public ItemLocator<IComponent> getLocator() {
        return ItemLocator.forItem((IItem)this.getComponent());
    }

    @Override
    public ITeamRepository getRepository() {
        return this.fRepo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fRepo == null ? 0 : this.fRepo.hashCode());
        result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.hashCode());
        result = 31 * result + (this.allowSuspendedChangeSetChildren ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ComponentWrapper other = (ComponentWrapper)((Object)obj);
        if (this.fRepo == null ? other.fRepo != null : !this.fRepo.equals(other.fRepo)) {
            return false;
        }
        if (this.fComponent == null ? other.fComponent != null : !this.fComponent.equals((Object)other.fComponent)) {
            return false;
        }
        return this.allowSuspendedChangeSetChildren == other.allowSuspendedChangeSetChildren;
    }

    public boolean shouldAllowSuspendedChangeSetChildren() {
        return this.allowSuspendedChangeSetChildren;
    }

    public void setAllowSuspendedChangeSetChildren(boolean allowSuspendedChangeSetChildren) {
        this.allowSuspendedChangeSetChildren = allowSuspendedChangeSetChildren;
    }
}

