/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChangeSetWrapper
extends AbstractWrapper {
    private ITeamRepository repository;
    private IChangeSet toWrap;
    private boolean hideComponent;
    private boolean isSourceChangeSet;

    public ChangeSetWrapper(ITeamRepository repo, IChangeSet itemToWrap) {
        this(repo, itemToWrap, false);
    }

    public ChangeSetWrapper(ITeamRepository repo, IChangeSet itemToWrap, boolean isSourceChangeSet) {
        super((IItem)itemToWrap);
        this.repository = repo;
        this.toWrap = itemToWrap;
        this.isSourceChangeSet = isSourceChangeSet;
    }

    public IChangeSet getChangeSet() {
        return (IChangeSet)this.getItem();
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repository;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        result = 31 * result + (this.toWrap == null ? 0 : this.toWrap.hashCode());
        result = 31 * result + (this.hideComponent ? 1231 : 1237);
        result = 31 * result + (this.isSourceChangeSet ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChangeSetWrapper other = (ChangeSetWrapper)((Object)obj);
        if (this.hideComponent != other.hideComponent) {
            return false;
        }
        if (this.repository == null ? other.repository != null : !this.repository.equals(other.repository)) {
            return false;
        }
        if (this.toWrap == null ? other.toWrap != null : !this.toWrap.equals((Object)other.toWrap)) {
            return false;
        }
        return this.isSourceChangeSet == other.isSourceChangeSet;
    }

    public static List<IChangeSet> getChangeSets(Collection<? extends ChangeSetWrapper> changeSetWrappers) {
        ArrayList result = NewCollection.arrayList();
        for (ChangeSetWrapper changeSetWrapper : changeSetWrappers) {
            result.add(changeSetWrapper.getChangeSet());
        }
        return result;
    }

    public static List<ChangeSetWrapper> getWrappers(ITeamRepository repo, Collection<? extends IChangeSet> changeSets) {
        ArrayList result = NewCollection.arrayList();
        for (IChangeSet iChangeSet : changeSets) {
            result.add(new ChangeSetWrapper(repo, iChangeSet));
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IChangeSetHandle.class || adapter == IItemHandle.class) {
            return ItemId.forItem((IItem)this.getChangeSet()).toHandle((Object)this.getRepository());
        }
        return super.getAdapter(adapter);
    }

    public void setHideComponent(boolean value) {
        this.hideComponent = value;
    }

    public boolean shouldHideComponent() {
        return this.hideComponent;
    }

    public boolean shouldHideAuthor() {
        boolean sameAuthor = this.getChangeSet().getAuthor().sameItemId((IItemHandle)this.getRepository().loggedInContributor());
        return sameAuthor || !UiPlugin.getBooleanPreference("ACTIVITY_MODIFIED_BY_DECORATION");
    }

    public boolean shouldHideWorkItemDescription() {
        return !UiPlugin.getBooleanPreference("ACTIVITY_LINK_DECORATION");
    }

    public boolean shouldHideDate() {
        return !UiPlugin.getBooleanPreference("ACTIVITY_MODIFIED_DECORATION");
    }

    public boolean shouldHideComment() {
        return false;
    }

    public boolean isSourceChangeSet() {
        return this.isSourceChangeSet;
    }
}

