/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangeSetInContextWrapper
extends ChangeSetWrapper {
    private ItemNamespace namespace;

    public static List<ChangeSetWrapper> getWrappersWithContext(ITeamRepository repo, Collection<? extends IChangeSet> changeSets, IContextHandle context) {
        ArrayList result = NewCollection.arrayList();
        for (IChangeSet iChangeSet : changeSets) {
            result.add(new ChangeSetInContextWrapper(ItemNamespace.getNamespace((ITeamRepository)repo, (IContextHandle)context, (IComponentHandle)iChangeSet.getComponent()), iChangeSet));
        }
        return result;
    }

    public ChangeSetInContextWrapper(ItemNamespace namespace, IChangeSet changeSet) {
        this(namespace, changeSet, false);
    }

    public ChangeSetInContextWrapper(ItemNamespace namespace, IChangeSet changeSet, boolean isSourceChangeSet) {
        super(namespace.getRepository(), changeSet, isSourceChangeSet);
        this.namespace = namespace;
    }

    public ItemNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ChangeSetInContextWrapper other = (ChangeSetInContextWrapper)((Object)obj);
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals((Object)other.namespace));
    }

    public static Map<ItemNamespace, List<ChangeSetInContextWrapper>> groupByNamespace(Collection<ChangeSetInContextWrapper> changeSets) {
        HashMap result = NewCollection.hashMap();
        for (ChangeSetInContextWrapper next : changeSets) {
            CollectionUtil.addToMapOfLists((Map)result, (Object)next.getNamespace(), (Object)((Object)next));
        }
        return result;
    }

    public static Map<SnapshotId, List<ChangeSetInContextWrapper>> groupBySnapshot(Collection<ChangeSetInContextWrapper> changeSets) {
        HashMap result = NewCollection.hashMap();
        for (ChangeSetInContextWrapper next : changeSets) {
            SnapshotId snapshot = next.getSnapshot();
            CollectionUtil.addToMapOfLists((Map)result, (Object)snapshot, (Object)((Object)next));
        }
        return result;
    }

    public SnapshotId getSnapshot() {
        NamespaceSetId snapshot;
        ItemNamespace nextNamespace = this.getNamespace();
        if (nextNamespace instanceof WorkspaceNamespace) {
            WorkspaceNamespace workspaceNamespace = (WorkspaceNamespace)nextNamespace;
            snapshot = WorkspaceId.create((ITeamRepository)workspaceNamespace.getRepository(), (ItemId)workspaceNamespace.getWorkspaceId());
        } else {
            snapshot = NamespaceSetId.create((ItemNamespace)nextNamespace);
        }
        return snapshot;
    }
}

