/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.client.internal.namespace.BaselineNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyData;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalBaselineWrapper;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathContentProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.dto.QueryOperations;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class BaselineWrapper
extends ContextWrapper
implements IHierarchicalBaselineWrapper,
Comparable,
IDateProvider {
    private IBaseline baseline;
    private IBaselineConnection connection;
    private IComponent component;
    private BaselineHierarchyData hierarchyData;
    private IBaselineSet parentSnapshot;
    private IQueryItem parentQuery;

    public BaselineWrapper(ITeamRepository repo, IBaseline baseline, IComponent component) {
        super(repo, (IItem)baseline);
        this.baseline = baseline;
        this.component = component;
    }

    public BaselineWrapper(IBaselineConnection connection, IComponent component) {
        super(connection.teamRepository(), (IItem)connection.getResolvedBaseline());
        this.baseline = connection.getResolvedBaseline();
        this.connection = connection;
        this.component = component;
    }

    public static BaselineWrapper constructFrom(BaselineNamespace namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = namespace.getRepository();
        IBaseline baseline = (IBaseline)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)namespace.getBaselineId(), (IProgressMonitor)progress.newChild(50));
        IComponent component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)ItemUtil.getComponent((IBaseline)baseline), (IProgressMonitor)progress.newChild(50));
        return new BaselineWrapper(repo, baseline, component);
    }

    public IBaselineConnection getBaselineConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.connection == null) {
            this.connection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getBaselineConnection(this.baseline, monitor);
        }
        return this.connection;
    }

    public IBaseline getBaseline() {
        return this.baseline;
    }

    @Override
    public IComponent getComponent() {
        return this.component;
    }

    public boolean isInitialBaseline() {
        return this.baseline.sameItemId((IItemHandle)this.component.getInitialBaseline());
    }

    public String getName() {
        return this.baseline.getName();
    }

    public IBaselineSet getParentSnapshot() {
        return this.parentSnapshot;
    }

    public void setParentSnapshot(IBaselineSet parentSnapshot) {
        this.parentSnapshot = parentSnapshot;
    }

    public IQueryItem getParentQuery() {
        return this.parentQuery;
    }

    public void setParentQuery(IQueryItem parentQuery) {
        this.parentQuery = parentQuery;
    }

    public String getLabel() {
        return BaselineWrapper.getLabel(this.getBaseline());
    }

    public static String getLabel(IBaseline baseline) {
        return ContextNameUtil.getContextName((IBaseline)baseline);
    }

    public BaselineNamespace getNamespace() {
        return BaselineNamespace.create((ITeamRepository)this.getRepository(), (IBaselineHandle)this.baseline);
    }

    @Override
    public Set<ItemId<IComponent>> getComponents(IProgressMonitor monitor) throws TeamRepositoryException {
        return Collections.singleton(ItemId.forItem((IItem)this.component));
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getBaselineConnection(monitor);
    }

    public Date getDate() {
        return this.baseline.getCreationDate();
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.baseline;
    }

    @Override
    public IBaselineHandle getWrappedItemHandle() {
        return this.baseline;
    }

    public BaselineHierarchyData getHierarchyData() {
        return this.hierarchyData;
    }

    @Override
    public void createHierarchyData(IBaselineHierarchyNode node, IHierarchicalBaselineWrapper parent) {
        Assert.isTrue((boolean)node.getBaselineHandle().sameItemId((IItemHandle)this.baseline));
        this.hierarchyData = new BaselineHierarchyData(node, parent, this);
    }

    public String getTags() {
        Map allCustomAttrs = this.baseline.getCustomAttributes();
        if (allCustomAttrs.containsKey(QueryOperations.TAGS_NAME)) {
            return (String)allCustomAttrs.get(QueryOperations.TAGS_NAME);
        }
        return "";
    }

    public String toString() {
        return String.valueOf(this.baseline.getId()) + ": " + this.baseline.getName() + " for Component " + this.component.getName();
    }

    public int compareTo(Object o) {
        if (o instanceof BaselineWrapper) {
            BaselineWrapper other = (BaselineWrapper)o;
            Date d1 = this.getDate();
            Date d2 = other.getDate();
            if (d1 == null && d2 == null) {
                return this.getName().compareToIgnoreCase(other.getName());
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return -d1.compareTo(d2);
        }
        return 0;
    }

    public Object getAdapter(Class adapter) {
        try {
            if (IWorkbenchAdapter.class == adapter && DelegatingTreePathContentProvider.class.getName().equals(Thread.currentThread().getStackTrace()[2].getClassName())) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getAdapter(adapter);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.hierarchyData != null) {
            result = 31 * result + Util.hashCode((Object)((IBaselineHierarchyNode)this.hierarchyData.getHierarchyNode()).getAncestorPath());
        }
        if (this.parentSnapshot != null) {
            result = 31 * result + Util.hashCode((Object)this.parentSnapshot.getItemId());
        }
        if (this.parentQuery != null) {
            result = 31 * result + Util.hashCode((Object)this.parentQuery.getItemId());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaselineWrapper other = (BaselineWrapper)obj;
        if (this.hierarchyData == null) {
            if (other.hierarchyData != null) {
                return false;
            }
        } else {
            if (other.hierarchyData == null) {
                return false;
            }
            if (!((IBaselineHierarchyNode)this.hierarchyData.getHierarchyNode()).getAncestorPath().equals(((IBaselineHierarchyNode)other.hierarchyData.getHierarchyNode()).getAncestorPath())) {
                return false;
            }
        }
        if (this.parentSnapshot == null) {
            if (other.parentSnapshot != null) {
                return false;
            }
        } else {
            if (other.parentSnapshot == null) {
                return false;
            }
            if (!this.parentSnapshot.sameItemId((IItemHandle)other.parentSnapshot)) {
                return false;
            }
        }
        if (this.parentQuery == null) {
            if (other.parentQuery != null) {
                return false;
            }
        } else {
            if (other.parentQuery == null) {
                return false;
            }
            if (!this.parentQuery.sameItemId((IItemHandle)other.parentQuery)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getContextName() {
        return this.getLabel();
    }
}

