/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.util.Util;

public abstract class AbstractWrapper
extends PlatformObject
implements IModelAccessor {
    private IItem itemToWrap;
    private boolean allowFolderActions = false;

    public AbstractWrapper(IItem itemToWrap) {
        Assert.isLegal((itemToWrap != null ? 1 : 0) != 0);
        Repositories.assertShared(itemToWrap);
        this.itemToWrap = itemToWrap;
    }

    public abstract ITeamRepository getRepository();

    public final IItem getItem() {
        return this.itemToWrap;
    }

    public boolean shouldAllowFolderActions() {
        return this.allowFolderActions;
    }

    public void setAllowFolderActions(boolean allowFolderActions) {
        this.allowFolderActions = allowFolderActions;
    }

    public Object getModelInstance() {
        return this.getItem();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractWrapper other = (AbstractWrapper)((Object)obj);
        IItem otherItem = other.getItem();
        IItem thisItem = this.getItem();
        if (this.allowFolderActions != other.allowFolderActions) {
            return false;
        }
        return other.getRepository().getRepositoryURI().equals(this.getRepository().getRepositoryURI()) && thisItem == otherItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31;
        result = 31 * result + (this.allowFolderActions ? 1231 : 1237);
        IItem item = this.getItem();
        if (item != null) {
            result = 31 * result + Util.hashCode((int)item.getItemId().hashCode());
            result = 31 * result + Util.hashCode((int)this.getRepository().getRepositoryURI().hashCode());
        }
        return result;
    }

    public static <T extends AbstractWrapper> Map<ITeamRepository, List<T>> groupByRepository(Collection<T> wrappers) {
        HashMap result = NewCollection.hashMap();
        for (AbstractWrapper next : wrappers) {
            ITeamRepository repo = next.getRepository();
            CollectionUtil.addToMapOfLists((Map)result, (Object)repo, (Object)((Object)next));
        }
        return result;
    }
}

