/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.history.WorkspaceHistoryPageSource;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.WorkspaceHistoryViewInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.ui.history.IHistoryPageSource;

public abstract class AbstractPlaceWrapper
extends ContextWrapper {
    protected AbstractPlaceWrapper(ITeamRepository repoHandle, IWorkspace workspace) {
        super(repoHandle, (IItem)workspace);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkspace.class) {
            return this.getWorkspace();
        }
        if (adapter == IItemHandle.class) {
            return this.getWorkspace();
        }
        if (adapter == IHistoryPageSource.class) {
            return WorkspaceHistoryPageSource.getInstance();
        }
        if (adapter == WorkspaceHistoryViewInput.class) {
            return new WorkspaceHistoryViewInput(this.getRepository(), this.getWorkspace());
        }
        return super.getAdapter(adapter);
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspaceConnection(monitor, false);
    }

    @Override
    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getWorkspaceConnection(monitor, false);
    }

    @Override
    public Set<ItemId<IComponent>> getComponents(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection connection = this.getWorkspaceConnection(monitor);
        HashSet result = NewCollection.hashSet();
        result.addAll(ItemLists.handlesToIds((Collection)connection.getComponents()));
        return result;
    }

    public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor, boolean refresh) throws TeamRepositoryException {
        IWorkspaceConnection known;
        if (refresh && (known = WorkspaceUtil.getKnownConnection(this.getRepository(), (IWorkspaceHandle)this.getWorkspace())) != null) {
            known.refresh(monitor);
            return known;
        }
        return SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getWorkspaceConnection((IWorkspaceHandle)this.getWorkspace(), monitor);
    }

    public final IWorkspace getWorkspace() {
        return (IWorkspace)this.getItem();
    }

    public static AbstractPlaceWrapper newWrapper(IWorkspace workspace) {
        Assert.isLegal((workspace != null ? 1 : 0) != 0);
        ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)workspace);
        if (workspace.isStream()) {
            return new TeamPlaceWrapper(repo, workspace);
        }
        return new ContributorPlaceWrapper(repo, workspace);
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getWorkspace();
    }

    @Override
    public String getContextName() {
        return this.getWorkspace().getName();
    }
}

