/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wrapper;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.PlatformObject;

public abstract class AbstractFileSystemItemWrapper
extends PlatformObject {
    private final String fqName;
    private final String name;
    private final StateId theItem;
    private String path;
    private IComponent component;
    private final ItemNamespace workspace;
    private String scope;
    private String versionId;
    private String versionNumber;
    private VersionDisplayOption versionDisplayOpt = VersionDisplayOption.DO_NOT_SHOW_VERSION_INFO;

    protected AbstractFileSystemItemWrapper(String fqName, ItemNamespace workspace, StateId theItem) {
        this(fqName, workspace, theItem, null);
    }

    protected AbstractFileSystemItemWrapper(String fqName, ItemNamespace workspace, StateId theItem, String scope) {
        this.fqName = fqName;
        this.name = PathUtils.getBaseName((String)fqName);
        this.workspace = workspace;
        this.theItem = theItem;
        this.scope = scope;
    }

    public static <T extends AbstractFileSystemItemWrapper> T newWrapper(StateId state, String fqName, ItemNamespace workspace) {
        return AbstractFileSystemItemWrapper.newWrapper(state, fqName, workspace, null);
    }

    public static <T extends AbstractFileSystemItemWrapper> T newWrapper(StateId state, String fqName, ItemNamespace workspace, String scope) {
        IItemType itemType = state.getItemType();
        if (IFolder.ITEM_TYPE.equals(itemType)) {
            return (T)((Object)new FolderItemWrapper(state, fqName, workspace, scope));
        }
        if (IFileItem.ITEM_TYPE.equals(itemType)) {
            return (T)((Object)new FileItemWrapper(state, fqName, workspace, scope));
        }
        if (ISymbolicLink.ITEM_TYPE.equals(itemType)) {
            return (T)((Object)new SymbolicLinkItemWrapper(state, fqName, workspace, scope));
        }
        throw new IllegalArgumentException("Path:" + fqName + ", workspace:" + workspace.toString() + ", state:" + state.toString());
    }

    public ITeamRepository getRepository() {
        return this.workspace.getRepository();
    }

    @Deprecated
    public ITeamRepository getRepositoryHandle() {
        return this.workspace.getRepository();
    }

    public final ItemId getItem() {
        return this.theItem.getItemId();
    }

    public final StateId getFileItem() {
        return this.theItem;
    }

    public IVersionableHandle getVersionable() {
        return (IVersionableHandle)this.theItem.toHandle((Object)this.getRepository());
    }

    public String getName() {
        return this.name;
    }

    public String getFQName() {
        return this.fqName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ItemNamespace getWorkspace() {
        return this.workspace;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public void setComponent(IComponent component) {
        this.component = component;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public void setDisplayOption(VersionDisplayOption opt) {
        this.versionDisplayOpt = opt;
    }

    public VersionDisplayOption getDisplayOption() {
        return this.versionDisplayOpt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fqName == null ? 0 : this.fqName.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.theItem == null ? 0 : this.theItem.hashCode());
        result = 31 * result + (this.workspace == null ? 0 : this.workspace.hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.getItemId().hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        result = 31 * result + (this.versionDisplayOpt == null ? 0 : this.versionDisplayOpt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractFileSystemItemWrapper other = (AbstractFileSystemItemWrapper)((Object)obj);
        if (this.fqName == null ? other.fqName != null : !this.fqName.equals(other.fqName)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.theItem == null ? other.theItem != null : !this.theItem.equals((Object)other.theItem)) {
            return false;
        }
        if (this.workspace == null ? other.workspace != null : !this.workspace.equals((Object)other.workspace)) {
            return false;
        }
        if (this.component == null ? other.component != null : !this.component.sameItemId((IItemHandle)other.component)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId)) {
            return false;
        }
        return !(this.versionDisplayOpt == null ? other.versionDisplayOpt != null : !this.versionDisplayOpt.equals((Object)other.versionDisplayOpt));
    }

    public LockInfo getLockInfo() {
        IWorkspaceConnection lockContextConnection = null;
        IContributor lockOwner = null;
        boolean lockedByMe = false;
        IWorkspaceConnection connection = this.getCachedConnection();
        if (connection != null) {
            if (connection.isStream()) {
                lockContextConnection = connection;
            } else {
                IFlowEntry flowEntry = connection.getFlowTable().getCurrentDeliverFlow();
                if (flowEntry != null) {
                    lockContextConnection = this.getCachedConnection((IItemHandle)flowEntry.getFlowNode());
                }
            }
            if (lockContextConnection != null && (lockOwner = UserLockCache.get().getLock((IVersionableHandle)this.getItem().toHandle(), lockContextConnection)) != null) {
                lockedByMe = lockOwner.sameItemId((IItemHandle)this.getRepository().loggedInContributor());
            }
        }
        return new LockInfo(lockContextConnection, lockOwner, lockedByMe);
    }

    private IWorkspaceConnection getCachedConnection() {
        return this.getCachedConnection((IItemHandle)this.getWorkspace().getContextHandle());
    }

    private IWorkspaceConnection getCachedConnection(IItemHandle contextHandle) {
        IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        if (workspaceManager != null) {
            return workspaceManager.getKnownWorkspaceConnection(contextHandle);
        }
        return null;
    }

    public class LockInfo {
        private IWorkspaceConnection lockContextConnection;
        private IContributor lockOwner;
        private boolean lockedByMe;

        private LockInfo(IWorkspaceConnection lockContextConnection, IContributor lockOwner, boolean lockedByMe) {
            this.lockContextConnection = lockContextConnection;
            this.lockOwner = lockOwner;
            this.lockedByMe = lockedByMe;
        }

        public IWorkspaceConnection getLockContextConnetion() {
            return this.lockContextConnection;
        }

        public IContributor getLockOwner() {
            return this.lockOwner;
        }

        public boolean isLocked() {
            return this.lockOwner != null;
        }

        public boolean isLockedByMe() {
            return this.lockedByMe;
        }
    }

    public static enum VersionDisplayOption {
        DO_NOT_SHOW_VERSION_INFO,
        SHOW_VERSION_NUMBER,
        SHOW_VERSION_ID;

    }
}

