/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.wizards.newworkspace;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.actions.load.LoadAction;
import com.ibm.team.filesystem.ide.ui.internal.wizards.load.LoadOperationInput;
import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.ui.operations.JoinOperation;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.wizards.join.JoinStreamChain;
import com.ibm.team.internal.filesystem.ui.wizards.join.NewWorkspaceSeedData;
import com.ibm.team.internal.filesystem.ui.wizards.newworkspace.NewWizardTeamAreaPickerPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.ChainedWizard;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewWorkspaceWizard
extends ChainedWizard
implements INewWizard {
    private NewWizardTeamAreaPickerPage teamAreaPickerPage;
    private JoinStreamChain joinStreamChain;
    private UIContext context;
    private boolean loadWorkspace;
    private IPartResult<AbstractPlaceWrapper> partResult;
    private NewWorkspaceSeedData seedData;
    private ITeamRepository initialRepo;
    private boolean forceRepo;
    private IReadScope defaultScopeOption;

    public NewWorkspaceWizard() {
        this(null);
    }

    public NewWorkspaceWizard(UIContext context) {
        this(context, null);
    }

    public NewWorkspaceWizard(UIContext context, ITeamRepository initialRepo) {
        this(context, initialRepo, true, null);
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public NewWorkspaceWizard(UIContext context, ITeamRepository initialRepo, boolean loadWorkspace, IPartResult<AbstractPlaceWrapper> partResult) {
        this(context, initialRepo, loadWorkspace, partResult, false);
    }

    public NewWorkspaceWizard(UIContext context, ITeamRepository initialRepo, boolean loadWorkspace, IPartResult<AbstractPlaceWrapper> partResult, boolean forceRepo) {
        this(context, initialRepo, loadWorkspace, partResult, forceRepo, (IReadScope)IReadScope.FACTORY.createPrivateScope());
    }

    public NewWorkspaceWizard(UIContext context, ITeamRepository initialRepo, boolean loadWorkspace, IPartResult<AbstractPlaceWrapper> partResult, boolean forceRepo, IReadScope defaultScopeOption) {
        this.context = context;
        this.loadWorkspace = loadWorkspace;
        this.partResult = partResult;
        this.initialRepo = initialRepo;
        this.forceRepo = forceRepo;
        this.defaultScopeOption = defaultScopeOption;
        this.joinStreamChain = new JoinStreamChain(initialRepo, loadWorkspace, forceRepo, defaultScopeOption);
        this.setWindowTitle(Messages.NewWorkspaceWizard_0);
        this.setDefaultPageImageDescriptor(ImagePool.NEW_WKSP_WIZBAN);
    }

    public void addPages() {
        this.teamAreaPickerPage = new NewWizardTeamAreaPickerPage(this.initialRepo, this.forceRepo);
        this.addPage((IWizardPage)this.teamAreaPickerPage);
        this.joinStreamChain.init(this.getPageChainSite());
    }

    public List<IWizardPage> getPageOrder() {
        ArrayList result = NewCollection.arrayList();
        result.add(this.teamAreaPickerPage);
        if (this.teamAreaPickerPage.isPageComplete()) {
            AbstractPlaceWrapper wrapper = this.teamAreaPickerPage.getStream();
            if (this.seedData == null || !this.seedData.sameAs(wrapper == null ? null : wrapper.getWorkspace(), wrapper == null ? this.teamAreaPickerPage.getRepository() : wrapper.getRepository())) {
                this.seedData = new NewWorkspaceSeedData(wrapper == null ? this.teamAreaPickerPage.getRepository() : wrapper.getRepository(), wrapper == null ? null : wrapper.getWorkspace(), this.defaultScopeOption);
                this.joinStreamChain.setInputs(this.seedData, !this.teamAreaPickerPage.dontCollaborate());
            }
            result.addAll(this.joinStreamChain.getPageOrder());
        }
        return result;
    }

    public boolean performFinish() {
        String operationName = NLS.bind((String)Messages.NewWorkspaceWizard_1, (Object)this.getWorkspaceName());
        final String workspaceName = this.getWorkspaceName();
        final String description = this.getWorkspaceDescription();
        final Display display = this.context.getDisplay();
        if (this.teamAreaPickerPage.dontCollaborate()) {
            final ITeamRepository repo = this.teamAreaPickerPage.getRepository();
            final boolean load = this.loadWorkspace;
            this.context.getUserOperationRunner().enqueue(operationName, (Operation)new RepositoryOperation(repo){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
                    IContributor contributor = repo.loggedInContributor();
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    final IWorkspaceConnection workspace = wm.createWorkspace((IContributorHandle)contributor, workspaceName, description, (IProgressMonitor)progress.newChild(1));
                    workspace.setOwnerAndVisibility(IScmService.NOOP_OWNER, NewWorkspaceWizard.this.joinStreamChain.getReadScope(), (IProgressMonitor)progress.newChild(1));
                    if (NewWorkspaceWizard.this.shouldCreateDefaultComponent()) {
                        IComponent newComponent = wm.createComponent(NewWorkspaceWizard.this.joinStreamChain.getDefaultComponentName(), (IAuditableHandle)contributor, (IProgressMonitor)progress.newChild(1));
                        IFlowNodeConnection.IComponentAdditionOp addOp = workspace.componentOpFactory().addComponent((IComponentHandle)newComponent, false);
                        workspace.applyComponentOperations(Collections.singletonList(addOp), (IProgressMonitor)progress.newChild(1));
                        wm.setComponentOwnerAndVisibility((IComponentHandle)newComponent, IScmService.NOOP_OWNER, NewWorkspaceWizard.this.joinStreamChain.getReadScope(), (IProgressMonitor)progress.newChild(1));
                        if (load) {
                            LoadOperation op = new LoadOperation(workspace, newComponent);
                            LoadAction.requestShowPendingView(workspace.getResolvedWorkspace());
                            op.doLoad(NewWorkspaceWizard.this.context.getUserOperationRunner());
                        }
                    } else {
                        FileSystemResourcesPlugin.getActiveWorkspaceManager().activate((IWorkspaceHandle)workspace.getResolvedWorkspace());
                    }
                    if (NewWorkspaceWizard.this.partResult != null) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                NewWorkspaceWizard.this.partResult.setResult((Object)AbstractPlaceWrapper.newWrapper(workspace.getResolvedWorkspace()));
                            }
                        });
                    }
                }
            });
        } else {
            JoinOperation op = this.joinStreamChain.getJoinOperation(this.context);
            op.setPartResult(this.partResult);
            this.context.getUserOperationRunner().enqueue(operationName, (Operation)op);
        }
        return true;
    }

    private String getWorkspaceName() {
        return this.joinStreamChain.getWorkspaceName();
    }

    private String getWorkspaceDescription() {
        return this.joinStreamChain.getWorkspaceDescription();
    }

    private boolean shouldCreateDefaultComponent() {
        return this.joinStreamChain.shouldCreateDefaultComponent();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.context = UIContext.createShellContext((Shell)workbench.getActiveWorkbenchWindow().getShell());
    }

    private class LoadOperation
    extends LoadOperationInput {
        private IComponent component;
        private IWorkspaceConnection connection;

        protected LoadOperation(IWorkspaceConnection connection, IComponent component) {
            this.connection = connection;
            this.component = component;
            this.requestLoad((IComponentHandle)component, Collections.EMPTY_LIST);
        }

        @Override
        public String getComponentName(UUID componentId) {
            return this.component.getName();
        }

        @Override
        public IConnection getConnection() {
            return this.connection;
        }
    }
}

