/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import java.util.Date;

public class TimeFilter {
    public static final int FILTERBY_DAY = 0;
    public static final int FILTERBY_WEEK = 1;
    public static final int FILTERBY_ENTRIES = 2;
    private static final long MILLIS_PER_DAY = 86400000L;
    private int showLastCount = 100;
    private int showLastType = 2;

    public TimeFilter() {
    }

    public TimeFilter(int type, int count) {
        this.showLastCount = count;
        this.showLastType = type;
    }

    public TimeFilter copy() {
        return new TimeFilter(this.showLastType, this.showLastCount);
    }

    public int getFilterType() {
        return this.showLastType;
    }

    public int getEntryCount() {
        return this.showLastCount;
    }

    public void setEntryCount(int showLastCount) {
        this.showLastCount = showLastCount;
    }

    public void setFilterType(int showLastType) {
        this.showLastType = showLastType;
    }

    public boolean passesFilter(int entry, Date theDate) {
        switch (this.showLastType) {
            case 2: {
                return entry < this.showLastCount;
            }
            case 1: {
                long theTime = theDate.getTime();
                long currentTime = System.currentTimeMillis();
                long elapsed = currentTime - theTime;
                return elapsed < 604800000L * (long)this.showLastCount;
            }
            case 0: {
                long theTime = theDate.getTime();
                long currentTime = System.currentTimeMillis();
                long elapsed = currentTime - theTime;
                return elapsed < 86400000L * (long)this.showLastCount;
            }
        }
        return false;
    }
}

