/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.TeamAreaWrapper;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public final class TeamViewSorter
extends ViewerSorter {
    public int category(Object element) {
        if (element instanceof TeamAreaWrapper) {
            return 3;
        }
        if (element instanceof ContributorWrapper) {
            return 4;
        }
        if (element instanceof ComponentWrapper) {
            return 5;
        }
        if (element instanceof BaselineWrapper) {
            return 6;
        }
        if (element instanceof SnapshotWrapper) {
            return 7;
        }
        return 8;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof BaselineWrapper && e2 instanceof BaselineWrapper) {
            return TeamViewSorter.compareBaselines(e1, e2);
        }
        if (e1 instanceof SnapshotWrapper && e2 instanceof SnapshotWrapper) {
            return TeamViewSorter.compareSnapshots(e1, e2);
        }
        return super.compare(viewer, e1, e2);
    }

    private static int compareBaselines(Object e1, Object e2) {
        BaselineWrapper b1 = (BaselineWrapper)e1;
        BaselineWrapper b2 = (BaselineWrapper)e2;
        return b1.compareTo(b2);
    }

    private static int compareSnapshots(Object e1, Object e2) {
        SnapshotWrapper b1 = (SnapshotWrapper)((Object)e1);
        SnapshotWrapper b2 = (SnapshotWrapper)((Object)e2);
        return b1.compareTo((Object)b2);
    }

    public static Comparator getBaselineComparator() {
        return new Comparator(){

            public int compare(Object e1, Object e2) {
                if (e1 instanceof BaselineWrapper && e2 instanceof BaselineWrapper) {
                    return TeamViewSorter.compareBaselines(e1, e2);
                }
                return -1;
            }
        };
    }

    public static Comparator getSnapComparator() {
        return new Comparator(){

            public int compare(Object e1, Object e2) {
                if (e1 instanceof SnapshotWrapper && e2 instanceof SnapshotWrapper) {
                    return TeamViewSorter.compareSnapshots(e1, e2);
                }
                return -1;
            }
        };
    }
}

