/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeEntry;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.DialogUtil;
import com.ibm.team.filesystem.ui.operations.EditSnapshotOperation;
import com.ibm.team.filesystem.ui.operations.EditWorkspaceOperation;
import com.ibm.team.filesystem.ui.operations.NewStreamOperation;
import com.ibm.team.filesystem.ui.operations.NewWorkspaceOperation;
import com.ibm.team.filesystem.ui.views.CollaborationEntry;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.ProcessAreaWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WarnUpdateUser;
import com.ibm.team.internal.filesystem.ui.util.WarnWorkspaceUpdate;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetailsFunction;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.repository.rcp.common.collection.IFilter;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.StatusCollector;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyResult;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.flow.FlowTable;
import com.ibm.team.scm.common.internal.util.ReadScopeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TeamPlaceWorkingCopy
extends ScmItemWorkingCopy
implements IListener {
    private MODE mode;
    private String placeName = null;
    private String originalPlaceName = "";
    private String description = null;
    private String originalDescription = "";
    private String autoLockPatterns = null;
    private String originalAutoLockPatterns = "";
    private ProcessAreaWrapper defaultArea;
    private AbstractPlaceWrapper workspaceWrapper;
    private IWorkspaceConnection workspaceConnection;
    private IReadScope readScope;
    private IReadScope originalReadScope;
    private ITeamRepository repository;
    private IAuditable owner;
    private IAuditable originalOwner;
    private boolean isOwnerInaccessible = false;
    private IAuditable parentOwner;
    private IAuditable originalParentOwner;
    private boolean loadOnSave = false;
    private WritableSetWithListeners<ComponentEntry> components = new WritableSetWithListeners();
    private List<ComponentEntry> componentsToAdd = new ArrayList<ComponentEntry>();
    private List<ComponentEntry> componentsToRemove = new ArrayList<ComponentEntry>();
    private List<ComponentEntry> componentsToUpdate = new ArrayList<ComponentEntry>();
    private List<IBaseline> allBases = new ArrayList<IBaseline>();
    private AbstractPlaceWrapper originalPlace;
    private WritableSetWithListeners<CollaborationEntry> collaborations = new WritableSetWithListeners();
    private List<CollaborationEntry> collaborationsToAdd = new ArrayList<CollaborationEntry>();
    private List<CollaborationEntry> collaborationsToRemove = new ArrayList<CollaborationEntry>();
    private List<CollaborationEntry> collaborationsToUpdate = new ArrayList<CollaborationEntry>();
    private CollaborationEntry defaultIncomingCollaboration;
    private CollaborationEntry defaultOutgoingCollaboration;
    private CollaborationEntry currentIncomingCollaboration;
    private CollaborationEntry currentOutgoingCollaboration;
    private Map<String, CustomAttributeEntry> customAttributes = new HashMap<String, CustomAttributeEntry>();
    private Map<String, Object> originalCustomAttributes = new HashMap<String, Object>();
    private Set<String> customAttributesToRemove = new HashSet<String>();
    private IBaselineSet originalSnapshot;
    private IWorkspace snapshotOwner;
    private IWorkspace originalSnapshotOwner;
    private IAuditable snapshotCreator;
    private final Object LISTENER_MUTEX = new Object();
    protected ISharedItemChangeListener itemListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            boolean synchronizeToRepository = false;
            boolean synchronizeComponents = false;
            for (Object o : events) {
                IBaselineSet snapshot;
                boolean ownerChanged;
                boolean descChanged;
                boolean nameChanged;
                IWorkspace afterState;
                IWorkspace beforeState;
                AbstractPlaceWrapper wrapper;
                if (!(o instanceof ISharedItemChangeEvent)) continue;
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)o;
                if (event.getSharedItem() instanceof IComponent) {
                    final IComponent changedComponent = (IComponent)event.getSharedItem();
                    final Shell shell = TeamPlaceWorkingCopy.this.getShell();
                    if (shell != null && !shell.isDisposed()) {
                        final boolean[] existsInWorkingCopy = new boolean[1];
                        shell.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!shell.isDisposed() && TeamPlaceWorkingCopy.this.findMatchingEntry(changedComponent) != null) {
                                    existsInWorkingCopy[0] = true;
                                }
                            }
                        });
                        if (existsInWorkingCopy[0]) {
                            synchronizeToRepository = true;
                            synchronizeComponents = true;
                            break;
                        }
                    }
                }
                if (event.getSharedItem() instanceof IWorkspace && (wrapper = TeamPlaceWorkingCopy.this.getWorkspaceWrapper()) != null && wrapper.getWorkspace().sameItemId((IItemHandle)event.getSharedItem())) {
                    beforeState = (IWorkspace)event.getBeforeState();
                    afterState = (IWorkspace)event.getAfterState();
                    if (beforeState != null && afterState != null) {
                        boolean patternChanged;
                        boolean visibilityChanged;
                        boolean bl = nameChanged = !beforeState.getName().equals(afterState.getName());
                        descChanged = !(beforeState.getDescription() == null ? afterState.getDescription() == null : beforeState.getDescription().equals(afterState.getDescription()));
                        ownerChanged = !beforeState.getOwner().sameItemId((IItemHandle)afterState.getOwner());
                        boolean bl2 = visibilityChanged = !ReadScopeUtils.equals((IReadScope)beforeState.getReadScope(), (IReadScope)afterState.getReadScope());
                        boolean bl3 = (this.getAutoLockPatterns(beforeState) == null ? this.getAutoLockPatterns(afterState) == null : this.getAutoLockPatterns(beforeState).equals(this.getAutoLockPatterns(afterState))) ? false : (patternChanged = true);
                        if (nameChanged || descChanged || ownerChanged || visibilityChanged || patternChanged) {
                            synchronizeToRepository = true;
                        }
                    }
                }
                if (!(event.getSharedItem() instanceof IBaselineSet) || (snapshot = TeamPlaceWorkingCopy.this.getOriginalSnapshot()) == null || !snapshot.sameItemId((IItemHandle)event.getSharedItem())) continue;
                beforeState = (IBaselineSet)event.getBeforeState();
                afterState = (IBaselineSet)event.getAfterState();
                if (beforeState == null || afterState == null) continue;
                boolean bl = nameChanged = !beforeState.getName().equals(afterState.getName());
                descChanged = !(beforeState.getComment() == null ? afterState.getComment() == null : beforeState.getComment().equals(afterState.getComment()));
                boolean bl4 = ownerChanged = !beforeState.getOwner().sameItemId((IItemHandle)afterState.getOwner());
                if (!nameChanged && !descChanged && !ownerChanged) continue;
                TeamPlaceWorkingCopy.this.initForEditSnapshot(false);
            }
            if (synchronizeToRepository) {
                TeamPlaceWorkingCopy.this.synchronizeToRepository(synchronizeComponents, false);
            }
        }

        private String getAutoLockPatterns(IWorkspace ws) {
            String patterns;
            Map properties = ws.getProperties();
            if (properties.containsKey("exclusiveFileLockPattern") && (patterns = (String)properties.get("exclusiveFileLockPattern")) != null) {
                return patterns;
            }
            return "";
        }
    };
    private IComponentHandle componentToSelectHandle;
    protected IListener ownerVizListener = new IListener(){

        public void handleEvents(List events) {
            for (Object obj : events) {
                IEvent event = (IEvent)obj;
                List categories = event.getCategories();
                boolean containsComponent = false;
                boolean needsUpdate = false;
                block3: for (Object category : categories) {
                    if (containsComponent && needsUpdate) break;
                    IWorkspaceConnection wc = TeamPlaceWorkingCopy.this.workspaceConnection;
                    if (category instanceof IComponentHandle && wc != null) {
                        IComponentHandle component = (IComponentHandle)category;
                        try {
                            List currentComponents = wc.getComponents();
                            for (IComponentHandle wsComponent : currentComponents) {
                                if (!component.sameItemId((IItemHandle)wsComponent)) continue;
                                containsComponent = true;
                                continue block3;
                            }
                        }
                        catch (TeamRepositoryException e) {
                            StatusUtil.log((IStatus)StatusUtil.newStatus((Object)this, (Throwable)e));
                        }
                        continue;
                    }
                    if (!category.equals("component_owner") && !category.equals("component_visibility")) continue;
                    needsUpdate = true;
                }
                if (!containsComponent || !needsUpdate) continue;
                TeamPlaceWorkingCopy.this.synchronizeToRepository(true, false);
            }
        }
    };
    private ITeamRepository folderRepo;
    private IItemContainerHandle parentFolder;
    private boolean addToRootFolder = false;

    public TeamPlaceWorkingCopy(Object input, IOperationRunner runner, Shell shell) {
        super(Messages.TeamPlaceWorkingCopy_name, runner, shell);
        this.init(input);
    }

    public ProcessAreaWrapper getDefaultTeam() {
        return this.defaultArea;
    }

    private void setDefaultTeam(ProcessAreaWrapper defaultArea) {
        this.defaultArea = defaultArea;
        this.stateChanged();
    }

    public IAuditable getOwner() {
        return this.owner != null ? this.owner : this.getOriginalOwner();
    }

    public boolean isOwnerInaccessible() {
        return this.isOwnerInaccessible;
    }

    public IAuditable getParentOwner() {
        return this.parentOwner != null ? this.parentOwner : this.getOriginalParentOwner();
    }

    public IReadScope getReadScope() {
        return this.readScope != null ? this.readScope : this.getOriginalReadScope();
    }

    private IAuditable getOriginalOwner() {
        return this.originalOwner;
    }

    private IAuditable getOriginalParentOwner() {
        return this.originalParentOwner;
    }

    private IReadScope getOriginalReadScope() {
        return this.originalReadScope;
    }

    public void setOwnerInaccessible(boolean isInaccessible) {
        boolean originalValue = this.isOwnerInaccessible;
        this.isOwnerInaccessible = isInaccessible;
        if (isInaccessible != originalValue) {
            this.notifyListeners((Object)PROPERTY.OWNER);
        }
    }

    public void setOwner(IAuditable owner) {
        if (this.originalOwner == null ? owner == null : this.originalOwner.sameItemId((IItemHandle)owner)) {
            owner = null;
        }
        Assert.isLegal((owner == null || !(this.isWorkspace() ? !(owner instanceof IContributor) : !(owner instanceof IProcessArea)) ? 1 : 0) != 0);
        if (this.owner == null ? owner != null : !this.owner.sameItemId((IItemHandle)owner)) {
            IAuditable oldOwner = this.getOwner();
            this.owner = owner;
            this.stateChanged();
            if (oldOwner == null ? this.getOwner() != null : !oldOwner.equals((Object)this.getOwner())) {
                this.notifyListeners((Object)PROPERTY.OWNER);
            }
        }
    }

    public void setParentOwner(IAuditable parentOwner) {
        if (this.originalParentOwner == null ? parentOwner == null : this.originalParentOwner.sameItemId((IItemHandle)parentOwner)) {
            parentOwner = null;
        }
        Assert.isLegal((parentOwner == null || parentOwner instanceof IProjectArea ? 1 : 0) != 0);
        if (this.parentOwner == null ? parentOwner != null : !this.parentOwner.sameItemId((IItemHandle)parentOwner)) {
            IAuditable oldParentOwner = this.getParentOwner();
            this.parentOwner = parentOwner;
            this.stateChanged();
            if (oldParentOwner == null ? this.getParentOwner() != null : !oldParentOwner.equals((Object)this.getParentOwner())) {
                this.notifyListeners((Object)PROPERTY.VISIBILITY);
            }
        }
    }

    public void setReadScope(IReadScope newReadScope) {
        if (ReadScopeUtils.equals((IReadScope)this.getReadScope(), (IReadScope)newReadScope)) {
            return;
        }
        this.readScope = newReadScope;
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.VISIBILITY);
    }

    public String getPlaceName() {
        return this.placeName != null ? this.placeName : this.getOriginalPlaceName();
    }

    public String getOriginalPlaceName() {
        return this.originalPlaceName;
    }

    public void setPlaceName(String placeName) {
        if (this.originalPlaceName.equals(placeName)) {
            placeName = null;
        }
        if (placeName == null ? this.placeName != null : !placeName.equals(this.placeName)) {
            String oldPlaceName = this.getPlaceName();
            this.placeName = placeName;
            this.stateChanged();
            if (!oldPlaceName.equals(this.getPlaceName())) {
                this.notifyListeners((Object)PROPERTY.PLACE_NAME);
            }
        }
    }

    private void setOriginalDescription(String text) {
        Assert.isNotNull((Object)text);
        if (!text.equals(this.originalDescription)) {
            String oldDesc = this.getDescription();
            this.originalDescription = text;
            if (!oldDesc.equals(this.getDescription())) {
                this.notifyListeners((Object)PROPERTY.DESCRIPTION);
            }
        }
    }

    private void setOriginalAutoLockPatterns(String text) {
        Assert.isNotNull((Object)text);
        if (!text.equals(this.originalAutoLockPatterns)) {
            String oldPatterns = this.getAutoLockPatterns();
            this.originalAutoLockPatterns = text;
            if (!oldPatterns.equals(this.getAutoLockPatterns())) {
                this.notifyListeners((Object)PROPERTY.AUTO_LOCK_PATTERNS);
            }
        }
    }

    private void setOriginalOwner(IAuditable owner) {
        Assert.isLegal((owner == null || !(this.isWorkspace() ? !(owner instanceof IContributor) : !(owner instanceof IProcessArea)) ? 1 : 0) != 0);
        if (this.originalOwner != owner) {
            IAuditable oldOwner = this.getOwner();
            this.originalOwner = owner;
            if (oldOwner == null ? this.getOwner() != null : !oldOwner.equals((Object)this.getOwner())) {
                this.notifyListeners((Object)PROPERTY.OWNER);
            }
        }
    }

    private void setOriginalParentOwner(IAuditable parentOwner) {
        Assert.isLegal((parentOwner == null || parentOwner instanceof IProjectArea ? 1 : 0) != 0);
        if (this.originalParentOwner != parentOwner) {
            IAuditable oldParentOwner = this.getParentOwner();
            this.originalParentOwner = parentOwner;
            if (oldParentOwner == null ? this.getParentOwner() != null : !oldParentOwner.equals((Object)this.getParentOwner())) {
                this.notifyListeners((Object)PROPERTY.VISIBILITY);
            }
        }
    }

    private void setOriginalReadScope(IReadScope readScope) {
        Assert.isLegal((readScope != null ? 1 : 0) != 0);
        Assert.isLegal((this.isStream() || this.isWorkspace() ? 1 : 0) != 0);
        if (!ReadScopeUtils.equals((IReadScope)this.originalReadScope, (IReadScope)readScope)) {
            IReadScope oldReadScope = this.getReadScope();
            this.originalReadScope = readScope;
            if (oldReadScope == null ? this.getReadScope() != null : !ReadScopeUtils.equals((IReadScope)oldReadScope, (IReadScope)this.getReadScope())) {
                this.notifyListeners((Object)PROPERTY.VISIBILITY);
            }
        }
    }

    private void setOriginalPlaceName(String name) {
        Assert.isNotNull((Object)name);
        if (!name.equals(this.originalPlaceName)) {
            String oldName = this.getPlaceName();
            this.originalPlaceName = name;
            if (!oldName.equals(this.getPlaceName())) {
                this.notifyListeners((Object)PROPERTY.PLACE_NAME);
            }
        }
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ITeamRepository server) {
        if (this.repository != server) {
            this.repository = server;
            this.stateChanged();
        }
    }

    public AbstractPlaceWrapper getWorkspaceWrapper() {
        return this.workspaceWrapper;
    }

    public void setWorkspaceWrapper(AbstractPlaceWrapper workspaceWrapper) {
        this.workspaceWrapper = workspaceWrapper;
    }

    public IWorkspaceConnection getWorkspaceConnection() {
        return this.workspaceConnection;
    }

    public void setWorkspaceConnection(IWorkspaceConnection newConnection) {
        IWorkspaceConnection oldConnection = this.workspaceConnection;
        if (oldConnection != null) {
            oldConnection.removeGenericListener((Object)"components", (IListener)this);
            oldConnection.removeGenericListener((Object)"flow table", (IListener)this);
        }
        this.workspaceConnection = newConnection;
        if (newConnection != null) {
            newConnection.addGenericListener((Object)"components", (IListener)this);
            newConnection.addGenericListener((Object)"flow table", (IListener)this);
        }
    }

    public ISetWithListeners<ComponentEntry> getComponents() {
        return this.components;
    }

    public ComponentEntry addComponent(String name) {
        ComponentEntry entry = new ComponentEntry(name, false, this.repository, this.workspaceConnection);
        this.components.add((Object)entry);
        this.componentsToAdd.add(entry);
        this.stateChanged();
        return entry;
    }

    public boolean removeComponents(List<ComponentEntry> componentsToRemove) {
        return this.removeComponents(componentsToRemove, false);
    }

    private boolean removeComponentsFromWrappersForReplace(Collection<? extends AbstractWrapper> componentsToRemove) {
        boolean rval = true;
        ArrayList<ComponentEntry> matching = new ArrayList<ComponentEntry>();
        for (AbstractWrapper abstractWrapper : componentsToRemove) {
            ComponentEntry entry;
            IComponent component = WorkspaceUtil.getComponent(abstractWrapper);
            if (component == null || (entry = this.findMatchingEntry(component)) == null) continue;
            matching.add(entry);
        }
        if (!matching.isEmpty()) {
            rval = this.removeComponentsForReplace(matching);
        }
        return rval;
    }

    private boolean removeComponentsForReplace(List<ComponentEntry> componentsToRemove) {
        return this.removeComponents(componentsToRemove, true);
    }

    private static boolean hasOutgoingChanges(IWorkspaceConnection wc, Collection<IComponentHandle> components) {
        for (IComponentHandle component : components) {
            if (!WorkspaceUtil.hasUndeliveredChanges(wc, component, false)) continue;
            return true;
        }
        return false;
    }

    private static boolean cancelRemoveForOutgoingChanges(Shell shell, IWorkspaceConnection workspace, Collection<IComponentHandle> components, boolean forReplace) {
        Boolean isOpCanceled = false;
        if (TeamPlaceWorkingCopy.hasOutgoingChanges(workspace, components)) {
            String message = components.size() == 1 ? Messages.DeleteComponentsInContributorPlaceAction_ComponentOutgoingChangeSetsDialogMessage : Messages.DeleteComponentsInContributorPlaceAction_ComponentsOutgoingChangeSetsDialogMessage;
            isOpCanceled = forReplace ? Boolean.valueOf(!DialogUtil.openConfirm(shell, Messages.TeamPlaceWorkingCopy_replaceComponentTitle, message, false)) : Boolean.valueOf(!DialogUtil.openConfirm(shell, Messages.DeleteComponentsInContributorPlaceAction_ConfirmDeleteDialogTitle, message, false));
        }
        return isOpCanceled;
    }

    private boolean cancelRemoveForOutgoingChangesHierarchy(List<ComponentEntry> selectedComponentsToRemove, boolean forReplace) {
        IWorkspaceConnection wsConnection = this.getWorkspaceConnection();
        if (wsConnection == null) {
            return false;
        }
        ArrayList<IComponent> componentHandles = new ArrayList<IComponent>(selectedComponentsToRemove.size());
        for (ComponentEntry nextComponentEntry : selectedComponentsToRemove) {
            IComponent nextComponent = nextComponentEntry.getBackingComponentItem();
            if (nextComponent == null) continue;
            componentHandles.add(nextComponent);
        }
        if (componentHandles.isEmpty()) {
            return false;
        }
        IComponentHierarchyResult hierarchyResult = wsConnection.getComponentHierarchy(componentHandles);
        return TeamPlaceWorkingCopy.cancelRemoveForOutgoingChanges(this.getShell(), wsConnection, hierarchyResult.getFlattenedElementsMap().values(), forReplace);
    }

    private boolean removeComponents(final List<ComponentEntry> selectedComponentsToRemove, final boolean forReplace) {
        if (selectedComponentsToRemove == null || selectedComponentsToRemove.isEmpty()) {
            return true;
        }
        if (this.cancelRemoveForOutgoingChangesHierarchy(selectedComponentsToRemove, forReplace)) {
            return false;
        }
        if (forReplace) {
            this.doRemoveComponents(selectedComponentsToRemove, forReplace);
        } else {
            final HashMap<UUID, IComponentHandle> componentsInWorkspace = new HashMap<UUID, IComponentHandle>();
            if (this.workspaceConnection != null) {
                try {
                    for (Object o : this.workspaceConnection.getComponents()) {
                        if (!(o instanceof IComponentHandle)) continue;
                        IComponentHandle component = (IComponentHandle)o;
                        componentsInWorkspace.put(component.getItemId(), component);
                    }
                }
                catch (Exception o) {
                    // empty catch block
                }
            }
            final HashMap<UUID, ComponentEntry> componentsInWorkingCopy = new HashMap<UUID, ComponentEntry>();
            for (ComponentEntry entry : this.components.toCollection()) {
                IComponent c = entry.getBackingComponentItem();
                if (c == null) continue;
                componentsInWorkingCopy.put(c.getItemId(), entry);
            }
            ScmItemWorkingCopy.UIOperation<Collection<ComponentEntry>> op = new ScmItemWorkingCopy.UIOperation<Collection<ComponentEntry>>((ScmItemWorkingCopy)this){

                /*
                 * Exception decompiling
                 */
                @Override
                protected Collection<ComponentEntry> runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 4[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                protected void updateUI(Collection<ComponentEntry> updatedComponentsToRemove) {
                    if (TeamPlaceWorkingCopy.this.promptForNoBackupBaselineOnRemove(selectedComponentsToRemove, updatedComponentsToRemove)) {
                        TeamPlaceWorkingCopy.this.doRemoveComponents(updatedComponentsToRemove, forReplace);
                    }
                }
            };
            op.enqueue(this.getOperationRunner(), Messages.TeamPlaceWorkingCopy_RemoveComponentHierarchyJobName);
        }
        return true;
    }

    protected boolean promptForNoBackupBaselineOnRemove(Collection<ComponentEntry> selectedComponentsToRemove, Collection<ComponentEntry> updatedComponentsToRemove) {
        boolean continueToRemoveComponents = true;
        if (updatedComponentsToRemove.size() > selectedComponentsToRemove.size()) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            String prefKey = "warn_no_backup_baseline_before_remove";
            boolean prompt = store.getBoolean("warn_no_backup_baseline_before_remove");
            if (prompt) {
                String dialogMessage;
                int selectedSize = selectedComponentsToRemove.size();
                int allSize = updatedComponentsToRemove.size();
                String dialogTitle = WarnWorkspaceUpdate.getNoBackupBaselineForRemoveTitle();
                if (selectedSize == 1) {
                    ComponentEntry selected = selectedComponentsToRemove.iterator().next();
                    IComponent selectedComponentHandle = selected.getBackingComponentItem();
                    if (selectedComponentHandle != null && allSize == 2) {
                        Iterator<ComponentEntry> iterator = updatedComponentsToRemove.iterator();
                        ComponentEntry component1 = iterator.next();
                        ComponentEntry component2 = iterator.next();
                        String selectedComponentName = selected.getName();
                        String subComponentName = selectedComponentHandle.sameItemId((IItemHandle)component1.getBackingComponentItem()) ? component2.getName() : component1.getName();
                        dialogMessage = NLS.bind((String)Messages.RemoveComponentsInContributorPlaceAction_RemoveComponentHierarchyDialogMessage1, (Object)selectedComponentName, (Object)subComponentName);
                    } else {
                        dialogMessage = NLS.bind((String)Messages.RemoveComponentsInContributorPlaceAction_RemoveComponentHierarchyDialogMessage2, (Object)(allSize - selectedSize));
                    }
                } else {
                    dialogMessage = NLS.bind((String)Messages.RemoveComponentsInContributorPlaceAction_RemoveComponentHierarchyDialogMessage3, (Object)selectedSize);
                }
                dialogMessage = String.valueOf(dialogMessage) + "\n\n" + WarnWorkspaceUpdate.getNoBackupBaselineForRemovePluralMessage();
                String[] yesNoButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getShell(), dialogTitle, null, dialogMessage, 4, yesNoButtons, 1, Messages.PreferencesListener_18, false);
                dialog.open();
                if (dialog.getReturnCode() == 2) {
                    store.setValue("warn_no_backup_baseline_before_remove", !dialog.getToggleState());
                } else {
                    continueToRemoveComponents = false;
                }
            }
        }
        return continueToRemoveComponents;
    }

    private void doRemoveComponents(Collection<ComponentEntry> componentsToRemove, boolean forReplace) {
        if (componentsToRemove != null && componentsToRemove.size() > 0) {
            for (ComponentEntry entry : componentsToRemove) {
                if (entry.getSourceBaseline() == null && entry.getSourceComponent() == null && forReplace) {
                    this.reset(entry);
                }
                if (this.componentsToAdd.contains(entry)) {
                    this.componentsToAdd.remove(entry);
                    continue;
                }
                this.componentsToUpdate.remove(entry);
                if (forReplace) continue;
                this.componentsToRemove.add(entry);
            }
            this.components.removeAll(componentsToRemove);
            this.stateChanged();
        }
    }

    private void reset(ComponentEntry entry) {
        this.componentsToUpdate.remove(entry);
    }

    @Override
    public IStatus validateForSave() {
        if (this.getRepository() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.TeamPlaceWorkingCopy_missingRepo);
        }
        if (this.getPlaceName().equals("")) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.TeamPlaceWorkingCopy_missingName);
        }
        IStatus status = IItemValidator.INSTANCE.validateAttribute((IType)IWorkspace.ITEM_TYPE, IWorkspace.NAME_PROPERTY, (Object)this.getPlaceName());
        if (!status.isOK()) {
            return StatusUtil.newStatus((Object)((Object)this), (String)status.getMessage());
        }
        status = IItemValidator.INSTANCE.validateAttribute((IType)IWorkspace.ITEM_TYPE, IWorkspace.DESCRIPTION_PROPERTY, (Object)this.description);
        if (!status.isOK()) {
            return StatusUtil.newStatus((Object)((Object)this), (String)status.getMessage());
        }
        if (!this.isSnapshot() && this.getOwner() == null) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.TeamPlaceWorkingCopy_missingOwner);
        }
        if (this.getOwner() != null && this.isStream() && !this.getRepository().equals(this.getOwner().getOrigin())) {
            return StatusUtil.newStatus((Object)((Object)this), (String)NLS.bind((String)Messages.TeamPlaceWorkingCopy_repoDoesNotContainOwner, (Object)this.getMode().getType().getHeaderText()));
        }
        HashSet<ITeamRepository> repositories = new HashSet<ITeamRepository>();
        for (ComponentEntry entry : this.componentsToAdd) {
            AbstractWrapper source = entry.getSourceBaseline();
            if (source == null) {
                source = entry.getSourceComponent();
            }
            if (source == null) continue;
            repositories.add(source.getRepository());
        }
        if (repositories.size() > 1) {
            return StatusUtil.newStatus((Object)((Object)this), (String)Messages.TeamPlaceWorkingCopy_componentsFromMultipleRepositoryError);
        }
        return Status.OK_STATUS;
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        StatusCollector problems = new StatusCollector();
        if (this.isInMode(MODE.NEW_STREAM)) {
            new NewStreamOperation(this).run(monitor, (IStatusCollector)problems);
        } else if (this.isInMode(MODE.NEW_WORKSPACE)) {
            new NewWorkspaceOperation(this).run(monitor, (IStatusCollector)problems);
        } else if (this.isInMode(MODE.EDIT_WORKSPACE) || this.isInMode(MODE.EDIT_STREAM)) {
            WarnUpdateUser problemHandler = new WarnUpdateUser(null, NLS.bind((String)Messages.TeamPlaceWorkingCopy_saving, (Object)this.getPlaceName()));
            new EditWorkspaceOperation(this, problemHandler).run(monitor, (IStatusCollector)problems);
        } else if (this.isInMode(MODE.EDIT_SNAPSHOT)) {
            new EditSnapshotOperation(this).run(monitor, (IStatusCollector)problems);
        } else {
            Assert.isTrue((boolean)false, (String)Messages.TeamPlaceWorkingCopy_unexpectedMode);
        }
        if (!problems.getStatus().isOK()) {
            StatusUtil.log((IStatus)problems.getStatus());
        }
    }

    @Override
    protected void onSaved() {
        if (this.isInMode(MODE.NEW_STREAM)) {
            this.setMode(MODE.EDIT_STREAM);
        } else if (this.isInMode(MODE.NEW_WORKSPACE)) {
            this.setMode(MODE.EDIT_WORKSPACE);
        }
        this.clearChangeTrackingData();
        this.setOriginalPlace(null);
        this.setDirty(false);
    }

    @Override
    public void refresh() {
        if (this.isCreation()) {
            return;
        }
        this.reloadFromRepository();
        this.clearChangeTrackingData();
        this.setDirty(false);
    }

    private void reloadFromRepository() {
        this.setPlaceName(null);
        this.setDescription(null);
        this.setOwner(null);
        this.setOwnerInaccessible(false);
        this.setSnapshotCreator(null);
        this.setSnapshotOwner(null);
        this.setParentOwner(null);
        this.setReadScope(null);
        this.collaborations.clear();
        this.components.clear();
        if (this.isSnapshot()) {
            this.init(SnapshotEditorInput.newForEdit(this.getOriginalSnapshot()));
        } else {
            this.init(TeamPlaceEditorInput.newForEdit(this.getWorkspaceWrapper()));
        }
    }

    private void clearChangeTrackingData() {
        this.componentsToAdd.clear();
        this.componentsToRemove.clear();
        this.componentsToUpdate.clear();
        if (!this.isSnapshot()) {
            for (Object o : this.components) {
                if (!(o instanceof ComponentEntry)) continue;
                ComponentEntry entry = (ComponentEntry)o;
                entry.onSaved();
            }
        }
        this.collaborationsToAdd.clear();
        this.collaborationsToRemove.clear();
        this.collaborationsToUpdate.clear();
    }

    public MODE getMode() {
        return this.mode;
    }

    public boolean isInMode(MODE mode) {
        return this.mode == mode;
    }

    private void setMode(MODE newMode) {
        this.mode = newMode;
    }

    public String getNameableName() {
        String name;
        if (this.mode.isCreation() && (name = this.mode.getType().getCreationNameableName()) != null) {
            return name;
        }
        return this.getPlaceName();
    }

    public ImageDescriptor getNameableImage() {
        return this.mode.getType().getNameableImage();
    }

    private void init(Object input) {
        if (input instanceof TeamPlaceEditorInput) {
            this.doInit((TeamPlaceEditorInput)input);
        } else if (input instanceof SnapshotEditorInput) {
            this.doInit((SnapshotEditorInput)input);
        } else {
            throw new IllegalArgumentException(Messages.TeamPlaceWorkingCopy_wrongInput);
        }
    }

    private void doInit(TeamPlaceEditorInput input) {
        this.repository = input.getRepository();
        this.setFolderRepo(input.getRepository());
        this.setParentFolder((IItemContainerHandle)input.getParentFolder());
        this.setShouldAddToRootFolder(input.shouldAddToRootFolder());
        this.setFolderOwner(input.getFolderOwner());
        if (input.isCreation()) {
            IReadScope readScope = null;
            if (input.isStream()) {
                this.setMode(MODE.NEW_STREAM);
            } else {
                this.setMode(MODE.NEW_WORKSPACE);
            }
            if (input.getOwner() instanceof ProcessAreaWrapper) {
                ProcessAreaWrapper tw = (ProcessAreaWrapper)input.getOwner();
                this.setDefaultTeam(tw);
                this.setOwner((IAuditable)tw.getItem());
                readScope = IReadScope.FACTORY.createProcessAreaScope();
            }
            if (input.getOwner() instanceof ContributorWrapper) {
                ContributorWrapper cw = (ContributorWrapper)input.getOwner();
                this.setOwner((IAuditable)cw.getContributor());
                readScope = IReadScope.FACTORY.createPublicScope();
            }
            if (input.getReadScope() != null) {
                readScope = input.getReadScope();
            }
            if (input.getPlace() != null) {
                this.setOriginalPlace(input.getPlace());
            } else if (input.getOriginalSnapshot() != null) {
                this.setOriginalSnapshot(input.getOriginalSnapshot());
            } else {
                this.setDirty(false);
            }
            this.setReadScope(readScope);
            this.initForCreation();
        } else {
            if (input.isStream()) {
                this.setMode(MODE.EDIT_STREAM);
            } else {
                this.setMode(MODE.EDIT_WORKSPACE);
            }
            AbstractPlaceWrapper place = input.getPlace();
            if (place != null) {
                this.setWorkspaceWrapper(place);
                this.setOriginalPlaceName(place.getWorkspace().getName());
                this.setRepository(place.getRepository());
                if (input.getComponentToSelect() != null) {
                    this.setComponentToSelectHandle((IComponentHandle)input.getComponentToSelect().getComponent());
                }
            }
            this.initForEdit();
            this.setDirty(false);
        }
        this.setValid(this.checkValid());
    }

    public IComponentHandle getComponentToSelectHandle() {
        return this.componentToSelectHandle;
    }

    private void setComponentToSelectHandle(IComponentHandle componentHandle) {
        this.componentToSelectHandle = componentHandle;
    }

    private void doInit(SnapshotEditorInput input) {
        this.setMode(MODE.EDIT_SNAPSHOT);
        this.repository = (ITeamRepository)input.getSnapshot().getOrigin();
        this.setOriginalSnapshot(input.getSnapshot());
        this.initForEditSnapshot(true);
        this.setDirty(false);
        this.setValid(this.checkValid());
    }

    public AbstractPlaceWrapper getOriginalPlace() {
        return this.originalPlace;
    }

    private void setOriginalPlace(AbstractPlaceWrapper wrapper) {
        this.originalPlace = wrapper;
    }

    public IBaselineSet getOriginalSnapshot() {
        return this.originalSnapshot;
    }

    private void setOriginalSnapshot(IBaselineSet snapshot) {
        this.originalSnapshot = snapshot;
    }

    private void initForCreation() {
        IBaselineSet snapshot = this.getOriginalSnapshot();
        if (snapshot != null) {
            this.addComponentsFromSnapshot(snapshot, false, false);
            this.setPlaceName(snapshot.getName());
        } else if (this.getOriginalPlace() != null) {
            this.initializeFromOriginal(this.getOriginalPlace(), false);
            this.stateChanged();
        }
    }

    private void initForEditSnapshot(final boolean initSnapshot) {
        final IBaselineSet snapshot = this.getOriginalSnapshot();
        this.setOriginalPlaceName(snapshot.getName());
        this.setOriginalDescription(snapshot.getComment());
        ScmItemWorkingCopy.UIOperation<Object[]> op = new ScmItemWorkingCopy.UIOperation<Object[]>((ScmItemWorkingCopy)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object[] runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    ITeamRepository repo = (ITeamRepository)snapshot.getOrigin();
                    Object object = TeamPlaceWorkingCopy.this.LISTENER_MUTEX;
                    synchronized (object) {
                        if (TeamPlaceWorkingCopy.this.itemListener != null) {
                            repo.itemManager().addItemChangeListener((IItem)snapshot, TeamPlaceWorkingCopy.this.itemListener);
                        }
                    }
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (!repo.loggedIn()) {
                        repo.login((IProgressMonitor)progress.newChild(5));
                    }
                    progress.setWorkRemaining(100);
                    IBaselineSet refreshedSnapshot = (IBaselineSet)repo.itemManager().fetchCompleteItem(snapshot.getItemHandle(), 1, (IProgressMonitor)progress.newChild(10));
                    TeamPlaceWorkingCopy.this.setOriginalSnapshot(refreshedSnapshot);
                    TeamPlaceWorkingCopy.this.setOriginalPlaceName(refreshedSnapshot.getName());
                    TeamPlaceWorkingCopy.this.setOriginalDescription(refreshedSnapshot.getComment());
                    IAuditable snapshotCreator = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)refreshedSnapshot.getCreator(), 0, (IProgressMonitor)progress.newChild(5));
                    IWorkspaceHandle snapshotOwnerHandle = refreshedSnapshot.getOwner();
                    IWorkspace snapshotOwner = null;
                    if (snapshotOwnerHandle != null) {
                        try {
                            snapshotOwner = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)snapshotOwnerHandle, 1, (IProgressMonitor)progress.newChild(10));
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                    }
                    progress.setWorkRemaining(75);
                    List snapshotBaselines = TeamPlaceWorkingCopy.this.fetchBaselinesFromSnapshot(refreshedSnapshot, (IProgressMonitor)progress.newChild(75));
                    return new Object[]{refreshedSnapshot, snapshotCreator, snapshotOwner, snapshotBaselines};
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(Object[] arr) {
                IBaselineSet snapshot2 = (IBaselineSet)arr[0];
                TeamPlaceWorkingCopy.this.setOriginalPlaceName(snapshot2.getName());
                TeamPlaceWorkingCopy.this.setOriginalDescription(snapshot2.getComment());
                IAuditable snapshotCreator = (IAuditable)arr[1];
                TeamPlaceWorkingCopy.this.setSnapshotCreator(snapshotCreator);
                IWorkspace snapshotOwner = (IWorkspace)arr[2];
                TeamPlaceWorkingCopy.this.setOriginalSnapshotOwner(snapshotOwner);
                TeamPlaceWorkingCopy.this.components.clear();
                List components = (List)arr[3];
                TeamPlaceWorkingCopy.this.addComponentsFromWrappers(components, false);
                TeamPlaceWorkingCopy.this.setCustomAttributes(snapshot2.getCustomAttributes());
                if (initSnapshot) {
                    TeamPlaceWorkingCopy.this.setDirty(false);
                }
            }
        };
        op.enqueue(this.getOperationRunner(), Messages.TeamPlaceWorkingCopy_fetchingSnapshot);
    }

    public IAuditable getSnapshotCreator() {
        return this.snapshotCreator;
    }

    private void setSnapshotCreator(IAuditable creator) {
        if (this.snapshotCreator == null && creator != null || this.snapshotCreator != null && !this.snapshotCreator.sameItemId((IItemHandle)creator)) {
            this.snapshotCreator = creator;
            this.stateChanged();
            this.notifyListeners((Object)PROPERTY.SNAPSHOT_CREATOR);
        }
    }

    public IWorkspace getOriginalSnapshotOwner() {
        return this.originalSnapshotOwner;
    }

    private void setOriginalSnapshotOwner(IWorkspace snapshotOwner) {
        if (this.originalSnapshotOwner == null || !this.originalSnapshotOwner.sameItemId((IItemHandle)snapshotOwner)) {
            IWorkspace oldOwner = this.getSnapshotOwner();
            this.originalSnapshotOwner = snapshotOwner;
            if (oldOwner == null && this.getSnapshotOwner() != null || oldOwner != null && !oldOwner.sameItemId((IItemHandle)this.getSnapshotOwner())) {
                this.notifyListeners((Object)PROPERTY.SNAPSHOT_OWNER);
            }
        }
    }

    public IWorkspace getSnapshotOwner() {
        return this.snapshotOwner != null ? this.snapshotOwner : this.getOriginalSnapshotOwner();
    }

    public void setSnapshotOwner(IWorkspace newSnapshotOwner) {
        if (this.originalSnapshotOwner != null && this.originalSnapshotOwner.sameItemId((IItemHandle)newSnapshotOwner)) {
            newSnapshotOwner = null;
        }
        if (this.snapshotOwner == null && newSnapshotOwner != null || this.snapshotOwner != null && !this.snapshotOwner.sameItemId((IItemHandle)newSnapshotOwner)) {
            IWorkspace oldOwner = this.getSnapshotOwner();
            this.snapshotOwner = newSnapshotOwner;
            this.stateChanged();
            if (oldOwner == null && this.getSnapshotOwner() != null || oldOwner != null && !oldOwner.sameItemId((IItemHandle)this.getSnapshotOwner())) {
                this.notifyListeners((Object)PROPERTY.SNAPSHOT_OWNER);
            }
        }
    }

    private void initializeFromOriginal(final AbstractPlaceWrapper originalWorkspace, final boolean notifyStateChanged) {
        final boolean isDuplication = this.isStream() == originalWorkspace.getWorkspace().isStream();
        ScmItemWorkingCopy.UIOperation<WorkspaceData> op = new ScmItemWorkingCopy.UIOperation<WorkspaceData>((ScmItemWorkingCopy)this){

            @Override
            protected WorkspaceData runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    return TeamPlaceWorkingCopy.loadFromRepository(originalWorkspace, true, true, isDuplication, monitor);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(WorkspaceData workspaceData) {
                ArrayList<WorkspaceComponentWrapper> wrappers = new ArrayList<WorkspaceComponentWrapper>();
                for (ComponentWrapper originalComponent : workspaceData.getComponents()) {
                    WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.newWrapper(workspaceData.getConnection(), originalComponent.getComponent());
                    wrappers.add(wrapper);
                }
                TeamPlaceWorkingCopy.this.addComponentsFromWrappers(wrappers, notifyStateChanged);
                if (isDuplication) {
                    TeamPlaceWorkingCopy.this.setPlaceName(NLS.bind((String)Messages.TeamPlaceWorkingCopy_duplicateOf, (Object)workspaceData.getName()));
                    TeamPlaceWorkingCopy.this.setOwner((IAuditable)(TeamPlaceWorkingCopy.this.isWorkspace() ? TeamPlaceWorkingCopy.this.repository.loggedInContributor() : workspaceData.getOwner()));
                    TeamPlaceWorkingCopy.this.setOwnerInaccessible(TeamPlaceWorkingCopy.this.isWorkspace() ? false : workspaceData.isOwnerInaccessible());
                    TeamPlaceWorkingCopy.this.setReadScope(workspaceData.getReadScope());
                    TeamPlaceWorkingCopy.this.setDescription(workspaceData.getDescription());
                    TeamPlaceWorkingCopy.this.setCollaborations(workspaceData);
                    TeamPlaceWorkingCopy.this.collaborationsToAdd.addAll(TeamPlaceWorkingCopy.this.collaborations.toCollection());
                    if (TeamPlaceWorkingCopy.this.isStream()) {
                        TeamPlaceWorkingCopy.this.setAutoLockPatterns(workspaceData.getAutoLockPatterns());
                    }
                }
            }
        };
        String jobName = this.isStream() ? Messages.TeamPlaceWorkingCopy_InitializingNewStreamJobName : Messages.TeamPlaceWorkingCopy_InitializingNewWorkspaceJobName;
        op.enqueue(this.getOperationRunner(), jobName);
    }

    private void initForEdit() {
        final AbstractPlaceWrapper wrapper = this.getWorkspaceWrapper();
        ScmItemWorkingCopy.UIOperation<WorkspaceData> op = new ScmItemWorkingCopy.UIOperation<WorkspaceData>((ScmItemWorkingCopy)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected WorkspaceData runInBackground(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                try {
                    WorkspaceData result = TeamPlaceWorkingCopy.loadFromRepository(wrapper, true, true, true, reporter);
                    ITeamRepository repoToListenTo = wrapper.getRepository();
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)repoToListenTo);
                    Object object = TeamPlaceWorkingCopy.this.LISTENER_MUTEX;
                    synchronized (object) {
                        if (TeamPlaceWorkingCopy.this.itemListener != null) {
                            repoToListenTo.itemManager().addItemChangeListener((IItem)wrapper.getWorkspace(), TeamPlaceWorkingCopy.this.itemListener);
                            repoToListenTo.itemManager().addItemChangeListener(IComponent.ITEM_TYPE, TeamPlaceWorkingCopy.this.itemListener);
                        }
                        if (TeamPlaceWorkingCopy.this.ownerVizListener != null) {
                            wm.addGenericListener((Object)"component_owner", TeamPlaceWorkingCopy.this.ownerVizListener);
                            wm.addGenericListener((Object)"component_visibility", TeamPlaceWorkingCopy.this.ownerVizListener);
                        }
                    }
                    return result;
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(WorkspaceData workspaceData) {
                if (workspaceData == null) {
                    return;
                }
                TeamPlaceWorkingCopy.this.setWorkspaceConnection(workspaceData.getConnection());
                TeamPlaceWorkingCopy.this.setOriginalPlaceName(workspaceData.getName());
                TeamPlaceWorkingCopy.this.setOriginalOwner(workspaceData.getOwner());
                TeamPlaceWorkingCopy.this.setOwnerInaccessible(workspaceData.isOwnerInaccessible());
                TeamPlaceWorkingCopy.this.setOriginalParentOwner(workspaceData.getParentOwner());
                TeamPlaceWorkingCopy.this.setOriginalReadScope(workspaceData.getReadScope());
                TeamPlaceWorkingCopy.this.setOriginalDescription(workspaceData.getDescription());
                TeamPlaceWorkingCopy.this.setOriginalAutoLockPatterns(workspaceData.getAutoLockPatterns());
                TeamPlaceWorkingCopy.this.setCollaborations(workspaceData);
                TeamPlaceWorkingCopy.this.setAllBases(workspaceData.getAllBases());
                TeamPlaceWorkingCopy.this.setCustomAttributes(workspaceData.getConnection().getResolvedWorkspace().getCustomAttributes());
                for (ComponentWrapper component : workspaceData.getComponents()) {
                    ComponentDetails details = workspaceData.getComponentDetails().get((Object)component);
                    ComponentEntry componentEntry = new ComponentEntry(component, TeamPlaceWorkingCopy.this.repository, TeamPlaceWorkingCopy.this.workspaceConnection);
                    if (details != null) {
                        componentEntry.setDetails(details);
                    }
                    TeamPlaceWorkingCopy.this.components.add((Object)componentEntry);
                }
                TeamPlaceWorkingCopy.this.setDirty(false);
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.TeamPlaceWorkingCopy_loading, (Object)wrapper.getWorkspace().getName()));
    }

    protected void setCustomAttributes(Map<String, Object> attributes) {
        this.customAttributes.clear();
        this.originalCustomAttributes.clear();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            this.customAttributes.put(entry.getKey(), new CustomAttributeEntry(entry.getKey(), (String)entry.getValue()));
            this.originalCustomAttributes.put(entry.getKey(), entry.getValue());
        }
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    private void synchronizeToRepository(final boolean syncComponents, final boolean syncCollabs) {
        final AbstractPlaceWrapper wrapper = this.getWorkspaceWrapper();
        if (wrapper == null) {
            return;
        }
        ScmItemWorkingCopy.UIOperation<WorkspaceData> op = new ScmItemWorkingCopy.UIOperation<WorkspaceData>((ScmItemWorkingCopy)this){

            @Override
            protected WorkspaceData runInBackground(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                try {
                    return TeamPlaceWorkingCopy.loadFromRepository(wrapper, false, syncComponents, syncCollabs, reporter);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(WorkspaceData workspaceData) {
                if (workspaceData == null) {
                    return;
                }
                TeamPlaceWorkingCopy.this.setOriginalPlaceName(workspaceData.getName());
                TeamPlaceWorkingCopy.this.setOriginalDescription(workspaceData.getDescription());
                TeamPlaceWorkingCopy.this.setOriginalOwner(workspaceData.getOwner());
                TeamPlaceWorkingCopy.this.setOwnerInaccessible(workspaceData.isOwnerInaccessible());
                TeamPlaceWorkingCopy.this.setOriginalReadScope(workspaceData.getReadScope());
                if (TeamPlaceWorkingCopy.this.isStream()) {
                    TeamPlaceWorkingCopy.this.setOriginalAutoLockPatterns(workspaceData.getAutoLockPatterns());
                    TeamPlaceWorkingCopy.this.setOriginalParentOwner(workspaceData.getParentOwner());
                }
                if (syncComponents) {
                    ArrayList<ComponentEntry> loadedComponents = new ArrayList<ComponentEntry>();
                    IWorkspaceConnection wc = workspaceData.getConnection();
                    for (ComponentWrapper component : workspaceData.getComponents()) {
                        ComponentDetails details = workspaceData.getComponentDetails().get((Object)component);
                        if (details == null || wc == null) continue;
                        ComponentEntry componentEntry = new ComponentEntry(component, TeamPlaceWorkingCopy.this.repository, wc);
                        componentEntry.setDetails(details);
                        loadedComponents.add(componentEntry);
                    }
                    ArrayList<ComponentEntry> toRemove = new ArrayList<ComponentEntry>();
                    for (ComponentEntry componentEntry : TeamPlaceWorkingCopy.this.components.toCollection()) {
                        SameComponentItemId component = new SameComponentItemId(componentEntry);
                        if (!CollectionUtil.contains(loadedComponents, (IFilter)component)) {
                            if (CollectionUtil.contains((Collection)TeamPlaceWorkingCopy.this.componentsToAdd, (IFilter)component)) continue;
                            toRemove.add(componentEntry);
                            continue;
                        }
                        ComponentEntry findFirst = (ComponentEntry)CollectionUtil.findFirst(loadedComponents, (IFilter)component);
                        if (CollectionUtil.contains((Collection)TeamPlaceWorkingCopy.this.componentsToUpdate, (IFilter)component)) continue;
                        componentEntry.setName(findFirst.getName());
                        componentEntry.setDetails(findFirst.getDetails());
                    }
                    for (ComponentEntry componentEntry : TeamPlaceWorkingCopy.this.componentsToRemove) {
                        if (CollectionUtil.contains(loadedComponents, (IFilter)new SameComponentItemId(componentEntry))) continue;
                        toRemove.add(componentEntry);
                    }
                    for (ComponentEntry componentEntry : toRemove) {
                        TeamPlaceWorkingCopy.this.components.remove((Object)componentEntry);
                        TeamPlaceWorkingCopy.this.componentsToRemove.remove(componentEntry);
                        TeamPlaceWorkingCopy.this.componentsToUpdate.remove(componentEntry);
                    }
                    for (ComponentEntry componentEntry : loadedComponents) {
                        SameComponentItemId tester = new SameComponentItemId(componentEntry);
                        if (CollectionUtil.contains((Collection)TeamPlaceWorkingCopy.this.componentsToRemove, (IFilter)tester) || CollectionUtil.contains((Collection)TeamPlaceWorkingCopy.this.components.toCollection(), (IFilter)tester)) continue;
                        TeamPlaceWorkingCopy.this.components.add((Object)componentEntry);
                    }
                    Iterator compIter = TeamPlaceWorkingCopy.this.componentsToAdd.iterator();
                    while (compIter.hasNext()) {
                        ComponentEntry componentToAdd = (ComponentEntry)compIter.next();
                        ComponentEntry persistedComponent = (ComponentEntry)CollectionUtil.findFirst(loadedComponents, (IFilter)new SameComponentItemId(componentToAdd));
                        if (persistedComponent == null) continue;
                        compIter.remove();
                        TeamPlaceWorkingCopy.this.components.remove((Object)componentToAdd);
                        TeamPlaceWorkingCopy.this.components.add((Object)persistedComponent);
                    }
                }
                if (syncCollabs) {
                    TeamPlaceWorkingCopy.this.collaborations.clear();
                    TeamPlaceWorkingCopy.this.collaborationsToAdd.clear();
                    TeamPlaceWorkingCopy.this.collaborationsToRemove.clear();
                    TeamPlaceWorkingCopy.this.collaborationsToUpdate.clear();
                    TeamPlaceWorkingCopy.this.setCollaborations(workspaceData);
                }
            }
        };
        op.enqueue(this.getOperationRunner(), NLS.bind((String)Messages.TeamPlaceWorkingCopy_updating, (Object)wrapper.getWorkspace().getName()));
    }

    private static WorkspaceData loadFromRepository(AbstractPlaceWrapper workspaceWrapper, boolean refresh, boolean loadComponents, boolean loadCollabs, IProgressMonitor monitor) throws TeamRepositoryException {
        String autoLockPatterns;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repo = workspaceWrapper.getRepository();
        if (!repo.loggedIn()) {
            repo.login((IProgressMonitor)progress.newChild(5));
        }
        progress.setWorkRemaining(95);
        IWorkspaceConnection connection = workspaceWrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(10), refresh);
        String name = connection.getName();
        String description = connection.getDescription();
        if (description == null) {
            description = "";
        }
        if ((autoLockPatterns = connection.getExclusiveFileLockPatterns()) == null) {
            autoLockPatterns = "";
        }
        IAuditable owner = null;
        boolean isOwnerInaccessible = false;
        try {
            owner = (IAuditable)repo.itemManager().fetchCompleteItem((IItemHandle)connection.getOwner(), 0, (IProgressMonitor)progress.newChild(10));
        }
        catch (PermissionDeniedException e) {
            isOwnerInaccessible = true;
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        progress.setWorkRemaining(75);
        HashMap<ITeamRepository, Map<UUID, IWorkspaceHandle>> collaborationHandles = new HashMap<ITeamRepository, Map<UUID, IWorkspaceHandle>>();
        collaborationHandles.put(repo, new HashMap());
        HashMap<UUID, Integer> collaborationFlowDirection = new HashMap<UUID, Integer>();
        IFlowTable flowTable = null;
        if (loadCollabs) {
            IFlowEntry flowEntry;
            flowTable = connection.getFlowTable();
            for (Object o : flowTable.acceptSources()) {
                if (!(o instanceof IFlowEntry)) continue;
                flowEntry = (IFlowEntry)o;
                TeamPlaceWorkingCopy.addCollaboration(repo, flowEntry, collaborationHandles);
                if (!(flowEntry.getFlowNode() instanceof IWorkspaceHandle)) continue;
                collaborationFlowDirection.put(flowEntry.getFlowNode().getItemId(), 1);
            }
            for (Object o : flowTable.deliverTargets()) {
                if (!(o instanceof IFlowEntry)) continue;
                flowEntry = (IFlowEntry)o;
                TeamPlaceWorkingCopy.addCollaboration(repo, flowEntry, collaborationHandles);
                if (!(flowEntry.getFlowNode() instanceof IWorkspaceHandle)) continue;
                Integer flowDirection = (Integer)collaborationFlowDirection.get(flowEntry.getFlowNode().getItemId());
                flowDirection = flowDirection != null ? flowDirection | 2 : 2;
                collaborationFlowDirection.put(flowEntry.getFlowNode().getItemId(), flowDirection);
            }
        }
        ArrayList<ComponentWrapper> componentWrappers = new ArrayList<ComponentWrapper>();
        HashMap<IWorkspaceHandle, IWorkspace> workspaces = new HashMap<IWorkspaceHandle, IWorkspace>();
        SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(collaborationHandles.size());
        for (Map.Entry entry : collaborationHandles.entrySet()) {
            Iterator o4;
            ITeamRepository tr = (ITeamRepository)entry.getKey();
            ArrayList workspaceHandles = new ArrayList(((Map)entry.getValue()).values());
            Object fetchedWorkspaces = new HashMap(workspaceHandles.size());
            if (tr == repo) {
                ArrayList<Object> handlesToFetch = new ArrayList<Object>();
                ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>(connection.getComponents().size());
                for (Object o2 : connection.getComponents()) {
                    if (!(o2 instanceof IComponentHandle)) continue;
                    componentHandles.add((IComponentHandle)o2);
                }
                handlesToFetch.addAll(componentHandles);
                handlesToFetch.addAll(workspaceHandles);
                int refreshFlag = refresh ? 1 : 0;
                List fetchedItems = tr.itemManager().fetchCompleteItems(handlesToFetch, refreshFlag, (IProgressMonitor)loopProgress.newChild(1));
                for (Object o3 : fetchedItems) {
                    if (o3 instanceof IComponent) {
                        IComponent component = (IComponent)o3;
                        componentWrappers.add(new ComponentWrapper(tr, component));
                        continue;
                    }
                    if (!(o3 instanceof IWorkspace)) continue;
                    IWorkspace workspace = (IWorkspace)o3;
                    fetchedWorkspaces.put(workspace.getItemId(), workspace);
                }
            } else {
                try {
                    List fetchedItems = tr.itemManager().fetchCompleteItems(workspaceHandles, 0, (IProgressMonitor)loopProgress.newChild(1));
                    for (Iterator o4 : fetchedItems) {
                        if (!(o4 instanceof IWorkspace)) continue;
                        IWorkspace workspace = (IWorkspace)o4;
                        fetchedWorkspaces.put(workspace.getItemId(), workspace);
                    }
                }
                catch (TeamRepositoryException e) {
                    if (e instanceof NotLoggedInException || e instanceof ConnectionException) {
                        fetchedWorkspaces = null;
                    }
                    throw e;
                }
            }
            o4 = workspaceHandles.iterator();
            while (o4.hasNext()) {
                IWorkspaceHandle handle = (IWorkspaceHandle)o4.next();
                if (fetchedWorkspaces != null) {
                    workspaces.put(handle, (IWorkspace)fetchedWorkspaces.get(handle.getItemId()));
                    continue;
                }
                workspaces.put(handle, null);
            }
        }
        IAuditable parentOwner = null;
        if (owner != null && connection.isStream()) {
            IItemManager itemManager = connection.teamRepository().itemManager();
            IProcessArea teamArea = (IProcessArea)owner;
            parentOwner = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)teamArea.getProjectArea(), 0, (IProgressMonitor)progress.newChild(5));
        }
        progress.setWorkRemaining(20);
        IReadScope readScope = connection.getReadScope();
        ArrayList<IBaselineHandle> allBasesToFetch = new ArrayList<IBaselineHandle>();
        for (ICurrentComponentInfo info : connection.getComponentsInfo()) {
            allBasesToFetch.add(info.basis());
        }
        List allBases = repo.itemManager().fetchCompleteItems(allBasesToFetch, 0, (IProgressMonitor)progress.newChild(10));
        Map<ComponentWrapper, ComponentDetails> componentDetails = ComponentDetailsFunction.fetchComponentDetails(componentWrappers, (IProgressMonitor)progress.newChild(10));
        CollaborationEntry defaultIncomingCollaborationEntry = null;
        CollaborationEntry defaultOutgoingCollaborationEntry = null;
        CollaborationEntry currentIncomingCollaborationEntry = null;
        CollaborationEntry currentOutgoingCollaborationEntry = null;
        ArrayList<CollaborationEntry> collaborationEntries = new ArrayList<CollaborationEntry>();
        if (loadCollabs) {
            IFlowNodeHandle defaultIncomingCollaboration = flowTable.getDefaultAcceptFlow() == null ? null : flowTable.getDefaultAcceptFlow().getFlowNode();
            IFlowNodeHandle defaultOutgoingCollaboration = flowTable.getDefaultDeliverFlow() == null ? null : flowTable.getDefaultDeliverFlow().getFlowNode();
            IFlowNodeHandle currentIncomingCollaboration = flowTable.getCurrentAcceptFlow() == null ? null : flowTable.getCurrentAcceptFlow().getFlowNode();
            IFlowNodeHandle currentOutgoingCollaboration = flowTable.getCurrentDeliverFlow() == null ? null : flowTable.getCurrentDeliverFlow().getFlowNode();
            for (Map.Entry e : workspaces.entrySet()) {
                IWorkspaceHandle handle = (IWorkspaceHandle)e.getKey();
                IWorkspace workspace = (IWorkspace)e.getValue();
                AbstractPlaceWrapper wrapper = workspace == null ? null : AbstractPlaceWrapper.newWrapper(workspace);
                Collection componentScopes = flowTable.getComponentScopes((IFlowNodeHandle)handle);
                CollaborationEntry entry = new CollaborationEntry(handle, wrapper, componentScopes, (Integer)collaborationFlowDirection.get(handle.getItemId()));
                collaborationEntries.add(entry);
                if (handle.sameItemId((IItemHandle)defaultIncomingCollaboration)) {
                    defaultIncomingCollaborationEntry = entry;
                }
                if (handle.sameItemId((IItemHandle)defaultOutgoingCollaboration)) {
                    defaultOutgoingCollaborationEntry = entry;
                }
                if (handle.sameItemId((IItemHandle)currentIncomingCollaboration)) {
                    currentIncomingCollaborationEntry = entry;
                }
                if (!handle.sameItemId((IItemHandle)currentOutgoingCollaboration)) continue;
                currentOutgoingCollaborationEntry = entry;
            }
        }
        return new WorkspaceData(connection, name, description, autoLockPatterns, owner, isOwnerInaccessible, parentOwner, readScope, componentWrappers, collaborationEntries, defaultIncomingCollaborationEntry, defaultOutgoingCollaborationEntry, currentIncomingCollaborationEntry, currentOutgoingCollaborationEntry, componentDetails, allBases);
    }

    private static void addCollaboration(ITeamRepository localRepo, IFlowEntry entry, Map<ITeamRepository, Map<UUID, IWorkspaceHandle>> collaborationHandles) {
        if (entry.getFlowNode() instanceof IWorkspaceHandle) {
            IWorkspaceHandle handle = (IWorkspaceHandle)entry.getFlowNode();
            String remoteRepositoryURI = entry.getRemoteRepositoryURI();
            UUID remoteRepositoryUUID = entry.getRemoteRepositoryIdentifier();
            ITeamRepository repo = null;
            try {
                repo = remoteRepositoryURI == null ? localRepo : (remoteRepositoryUUID == null ? RepositoryUtils.getTeamRepository((String)remoteRepositoryURI) : RepositoryUtils.getTeamRepository((String)remoteRepositoryURI, (UUID)remoteRepositoryUUID));
            }
            catch (IllegalArgumentException e) {
                StatusUtil.log((Object)((Object)UiPlugin.getDefault()), (Throwable)e);
            }
            if (repo != null) {
                Map<UUID, IWorkspaceHandle> map = collaborationHandles.get(repo);
                if (map == null) {
                    map = new HashMap<UUID, IWorkspaceHandle>();
                    collaborationHandles.put(repo, map);
                }
                if (!map.containsKey(handle.getItemId())) {
                    map.put(handle.getItemId(), handle);
                }
            }
        }
    }

    public boolean getLoadOnSave() {
        return this.loadOnSave;
    }

    public void setLoadOnSave(boolean loadOnSave) {
        this.loadOnSave = loadOnSave;
    }

    public List<ComponentEntry> getComponentsToAdd() {
        return this.componentsToAdd;
    }

    public List<ComponentEntry> getComponentsToRemove() {
        return this.componentsToRemove;
    }

    public List<ComponentEntry> getComponentsToUpdate() {
        return this.componentsToUpdate;
    }

    private void stateChanged() {
        this.setDirty(true);
        this.setValid(this.checkValid());
    }

    private boolean checkValid() {
        return this.getPlaceName().length() > 0 && this.getRepository() != null && this.getOwner() != null;
    }

    public void addComponentsFromBaselines(Collection<BaselineWrapper> baselines, boolean addHierarchy, boolean promptForReplace, boolean notifyStateChanged) {
        if (baselines == null || baselines.isEmpty()) {
            return;
        }
        Assert.isTrue((this.getMode().getType().equals((Object)TYPE.WORKSPACE) || this.getMode().getType().equals((Object)TYPE.STREAM) ? 1 : 0) != 0, (String)"Can only add components into a repository workspace or stream");
        ArrayList<IComponent> hierarchicalComponentsToReplace = new ArrayList<IComponent>();
        if (this.workspaceConnection != null) {
            Map parentToChildMap = this.workspaceConnection.getComponentHierarchy(null).getParentToChildrenMap();
            for (BaselineWrapper baseline : baselines) {
                Collection subcomponents;
                IComponent componentFromBaseline = baseline.getComponent();
                if (!this.isReplacement(componentFromBaseline) || (subcomponents = (Collection)parentToChildMap.get(componentFromBaseline.getItemId())) == null || subcomponents.isEmpty()) continue;
                hierarchicalComponentsToReplace.add(componentFromBaseline);
            }
        }
        if (hierarchicalComponentsToReplace.isEmpty() || this.promptForNoBackupBaselineOnReplace(hierarchicalComponentsToReplace)) {
            this.doAddComponentsFromBaselines(baselines, addHierarchy, promptForReplace, notifyStateChanged);
        }
    }

    private void doAddComponentsFromBaselines(final Collection<BaselineWrapper> selectedBaselines, boolean addHierarchy, final boolean promptForReplace, final boolean notifyStateChanged) {
        if (!addHierarchy) {
            if (promptForReplace) {
                if (this.checkReplaceExistingComponents(selectedBaselines)) {
                    this.addComponentsFromWrappers(selectedBaselines, notifyStateChanged);
                }
            } else if (this.removeComponentsFromWrappersForReplace(selectedBaselines)) {
                this.addComponentsFromWrappers(selectedBaselines, notifyStateChanged);
            }
        } else {
            final HashMap subBaselinesToAdd = new HashMap();
            final HashSet inaccessibleSubBaselines = new HashSet();
            final HashSet inaccessibleSubComponents = new HashSet();
            final HashSet<UUID> baselinesNotToFetch = new HashSet<UUID>(selectedBaselines.size());
            for (BaselineWrapper baselineWrapper : selectedBaselines) {
                baselinesNotToFetch.add(baselineWrapper.getBaseline().getItemId());
            }
            ScmItemWorkingCopy.UIOperation<Object> op = new ScmItemWorkingCopy.UIOperation<Object>((ScmItemWorkingCopy)this){

                @Override
                protected Object runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selectedBaselines.size());
                        for (BaselineWrapper selectedBaseline : selectedBaselines) {
                            SubMonitor loopProgres = progress.newChild(1).setWorkRemaining(4);
                            IBaselineConnection baselineConnection = selectedBaseline.getBaselineConnection((IProgressMonitor)loopProgres.newChild(1));
                            IBaselineHierarchyResult baselineHierarchy = baselineConnection.getBaselineHierarchy((IProgressMonitor)loopProgres.newChild(1));
                            Collection subBaselines = baselineHierarchy.getFlattenedElementsMap().values();
                            HashMap<UUID, IBaselineHandle> subBaselinesToFetch = new HashMap<UUID, IBaselineHandle>(subBaselines.size());
                            for (IBaselineHandle baselineHandle : subBaselines) {
                                if (baselinesNotToFetch.contains(baselineHandle.getItemId())) continue;
                                subBaselinesToFetch.put(baselineHandle.getItemId(), baselineHandle);
                                baselinesNotToFetch.add(baselineHandle.getItemId());
                            }
                            if (!subBaselinesToFetch.isEmpty()) {
                                IComponent subComponent;
                                IBaseline subBaseline;
                                HashMap<UUID, IBaseline> fetchedSubBaselines = new HashMap<UUID, IBaseline>();
                                HashMap<UUID, IComponent> fetchedSubComponents = new HashMap<UUID, IComponent>();
                                IItemManager itemManager = baselineConnection.teamRepository().itemManager();
                                IFetchResult fetchResult = itemManager.fetchCompleteItemsPermissionAware(new ArrayList(subBaselinesToFetch.values()), 0, (IProgressMonitor)loopProgres.newChild(1));
                                ArrayList<IComponentHandle> subComponentsToFetch = new ArrayList<IComponentHandle>();
                                for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                                    if (!(retrievedItem instanceof IBaseline)) continue;
                                    subBaseline = (IBaseline)retrievedItem;
                                    fetchedSubBaselines.put(subBaseline.getItemId(), subBaseline);
                                    subComponentsToFetch.add(subBaseline.getComponent());
                                }
                                for (Object missingItem : fetchResult.getMissingItems()) {
                                    if (!(missingItem instanceof IBaselineHandle)) continue;
                                    subBaseline = (IBaselineHandle)missingItem;
                                    inaccessibleSubBaselines.add(subBaseline.getItemId());
                                }
                                fetchResult = itemManager.fetchCompleteItemsPermissionAware(subComponentsToFetch, 0, (IProgressMonitor)loopProgres.newChild(1));
                                for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                                    if (!(retrievedItem instanceof IComponent)) continue;
                                    subComponent = (IComponent)retrievedItem;
                                    fetchedSubComponents.put(subComponent.getItemId(), subComponent);
                                }
                                for (Object missingItem : fetchResult.getMissingItems()) {
                                    if (!(missingItem instanceof IComponentHandle)) continue;
                                    subComponent = (IComponentHandle)missingItem;
                                    inaccessibleSubComponents.add(subComponent.getItemId());
                                }
                                for (IBaseline baseline : fetchedSubBaselines.values()) {
                                    IComponent component = (IComponent)fetchedSubComponents.get(baseline.getComponent().getItemId());
                                    if (component == null) continue;
                                    subBaselinesToAdd.put(baseline.getItemId(), new BaselineWrapper(baselineConnection.teamRepository(), baseline, component));
                                }
                            }
                            loopProgres.done();
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    return null;
                }

                @Override
                protected void updateUI(Object notUsed) {
                    if (!inaccessibleSubBaselines.isEmpty()) {
                        String dialogTitle = Messages.TeamPlaceWorkingCopy_InaccessibleBaselineDialogTitle;
                        String dialogMessage = Messages.TeamPlaceWorkingCopy_InaccessibleBaselineDialogMessage;
                        MessageDialog.openError((Shell)TeamPlaceWorkingCopy.this.getShell(), (String)dialogTitle, (String)dialogMessage);
                        return;
                    }
                    TeamPlaceWorkingCopy.this.addComponentsAndSubcomponentsFromWrappers(selectedBaselines, subBaselinesToAdd.values(), promptForReplace, notifyStateChanged);
                }
            };
            op.enqueue(this.getOperationRunner(), Messages.TeamPlaceWorkingCopy_AddComponentHierarchyJobName);
        }
    }

    private boolean checkReplaceExistingComponents(Collection<? extends AbstractWrapper> wrappers) {
        ArrayList<ComponentEntry> matching = new ArrayList<ComponentEntry>();
        if (wrappers != null) {
            for (AbstractWrapper abstractWrapper : wrappers) {
                ComponentEntry entry;
                IComponent component = WorkspaceUtil.getComponent(abstractWrapper);
                if (component == null || (entry = this.findMatchingEntry(component)) == null) continue;
                matching.add(entry);
            }
        }
        if (!matching.isEmpty()) {
            String string = matching.size() == 1 ? Messages.TeamPlaceWorkingCopy_replaceComponentTitle : Messages.TeamPlaceWorkingCopy_replaceComponentsTitle;
            String dialogMessage = null;
            switch (this.getMode().getType()) {
                case STREAM: {
                    ComponentEntry entry;
                    if (matching.size() == 1) {
                        entry = (ComponentEntry)matching.get(0);
                        dialogMessage = NLS.bind((String)Messages.TeamPlaceWorkingCopy_replaceComponentMsgStream, (Object)entry.getName());
                        break;
                    }
                    dialogMessage = Messages.TeamPlaceWorkingCopy_replaceComponentsMsgStream;
                    break;
                }
                case WORKSPACE: {
                    ComponentEntry entry;
                    if (matching.size() == 1) {
                        entry = (ComponentEntry)matching.get(0);
                        dialogMessage = NLS.bind((String)Messages.TeamPlaceWorkingCopy_replaceComponentMsgRepositoryWorkspace, (Object)entry.getName());
                        break;
                    }
                    dialogMessage = Messages.TeamPlaceWorkingCopy_replaceComponentsMsgRepositoryWorkspace;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)string, (String)dialogMessage)) {
                return this.removeComponentsForReplace(matching);
            }
            return false;
        }
        return true;
    }

    private ComponentEntry findMatchingEntry(IComponent component) {
        for (Object o : this.getComponents()) {
            ComponentEntry entry;
            if (!(o instanceof ComponentEntry) || !(entry = (ComponentEntry)o).matches(component)) continue;
            return entry;
        }
        return null;
    }

    public void addComponentsFromSnapshot(final IBaselineSet snapshot, final boolean promptForReplace, final boolean notifyStateChanged) {
        ScmItemWorkingCopy.UIOperation<List<BaselineWrapper>> op = new ScmItemWorkingCopy.UIOperation<List<BaselineWrapper>>((ScmItemWorkingCopy)this){

            @Override
            protected List<BaselineWrapper> runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                try {
                    return TeamPlaceWorkingCopy.this.fetchBaselinesFromSnapshot(snapshot, monitor);
                }
                catch (TeamRepositoryException e) {
                    throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                }
            }

            @Override
            protected void updateUI(List<BaselineWrapper> baselines) {
                if (!baselines.isEmpty()) {
                    TeamPlaceWorkingCopy.this.addComponentsFromBaselines(baselines, false, promptForReplace, notifyStateChanged);
                }
            }
        };
        op.enqueue(this.getOperationRunner(), Messages.TeamPlaceWorkingCopy_addingComponentsFromSnapshot);
    }

    private List<BaselineWrapper> fetchBaselinesFromSnapshot(IBaselineSet snapshot, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponent component;
        ArrayList<BaselineWrapper> baselineWrapperResult = new ArrayList<BaselineWrapper>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repository = ClientRepositoryUtil.getRepository((IItemHandle)snapshot);
        HashMap<UUID, IBaseline> baselines = new HashMap<UUID, IBaseline>();
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        ArrayList<IComponentHandle> componentsToFetch = new ArrayList<IComponentHandle>();
        IFetchResult baselineFetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(snapshot.getBaselines(), 1, (IProgressMonitor)progress.newChild(50));
        for (Object o : baselineFetchResult.getRetrievedItems()) {
            if (!(o instanceof IBaseline)) continue;
            IBaseline baseline = (IBaseline)o;
            baselines.put(baseline.getItemId(), baseline);
            componentsToFetch.add(baseline.getComponent());
        }
        IFetchResult componentFetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(componentsToFetch, 1, (IProgressMonitor)progress.newChild(50));
        for (Object o : componentFetchResult.getRetrievedItems()) {
            if (!(o instanceof IComponent)) continue;
            component = (IComponent)o;
            components.put(component.getItemId(), component);
        }
        for (IBaseline baseline : baselines.values()) {
            component = (IComponent)components.get(baseline.getComponent().getItemId());
            if (component == null) continue;
            BaselineWrapper wrapper = new BaselineWrapper(repository, baseline, component);
            baselineWrapperResult.add(wrapper);
        }
        progress.done();
        return baselineWrapperResult;
    }

    public void addComponentsFromWorkspace(Collection<WorkspaceComponentWrapper> selectedComponents, boolean addHierarchy, boolean promptForReplace, boolean notifyStateChanged) {
        if (selectedComponents == null || selectedComponents.isEmpty()) {
            return;
        }
        Assert.isTrue((this.getMode().getType().equals((Object)TYPE.WORKSPACE) || this.getMode().getType().equals((Object)TYPE.STREAM) ? 1 : 0) != 0, (String)"Can only add components into a repository workspace or stream");
        ArrayList<IComponent> hierarchicalComponentsToReplace = new ArrayList<IComponent>();
        if (this.workspaceConnection != null) {
            Map parentToChildMap = this.workspaceConnection.getComponentHierarchy(null).getParentToChildrenMap();
            for (WorkspaceComponentWrapper wrapper : selectedComponents) {
                Collection subcomponents;
                IComponent component = wrapper.getComponent();
                if (!this.isReplacement(component) || (subcomponents = (Collection)parentToChildMap.get(component.getItemId())) == null || subcomponents.isEmpty()) continue;
                hierarchicalComponentsToReplace.add(component);
            }
        }
        if (hierarchicalComponentsToReplace.isEmpty() || this.promptForNoBackupBaselineOnReplace(hierarchicalComponentsToReplace)) {
            this.doAddComponentsFromWorkspace(selectedComponents, addHierarchy, promptForReplace, notifyStateChanged);
        }
    }

    protected boolean promptForNoBackupBaselineOnReplace(List<IComponent> hierarchicalComponents) {
        boolean continueToReplaceComponents = true;
        if (!hierarchicalComponents.isEmpty()) {
            IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
            String prefKey = "warn_no_backup_baseline_before_replace";
            boolean prompt = store.getBoolean("warn_no_backup_baseline_before_replace");
            if (prompt) {
                String dialogTitle = WarnWorkspaceUpdate.getNoBackupBaselineForReplaceTitle();
                String dialogMessage = hierarchicalComponents.size() == 1 ? WarnWorkspaceUpdate.getNoBackupBaselineForReplaceSingleMessage(hierarchicalComponents.iterator().next()) : WarnWorkspaceUpdate.getNoBackupBaselineForReplacePluralMessage();
                String[] yesNoButtons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getShell(), dialogTitle, null, dialogMessage, 4, yesNoButtons, 1, Messages.PreferencesListener_18, false);
                dialog.open();
                if (dialog.getReturnCode() == 2) {
                    store.setValue("warn_no_backup_baseline_before_replace", !dialog.getToggleState());
                } else {
                    continueToReplaceComponents = false;
                }
            }
        }
        return continueToReplaceComponents;
    }

    private void doAddComponentsFromWorkspace(final Collection<WorkspaceComponentWrapper> selectedComponents, boolean addHierarchy, final boolean promptForReplace, final boolean notifyStateChanged) {
        if (!addHierarchy) {
            if (promptForReplace) {
                if (this.checkReplaceExistingComponents(selectedComponents)) {
                    this.addComponentsFromWrappers(selectedComponents, notifyStateChanged);
                }
            } else if (this.removeComponentsFromWrappersForReplace(selectedComponents)) {
                this.addComponentsFromWrappers(selectedComponents, notifyStateChanged);
            }
        } else {
            final HashMap subcomponentsToAdd = new HashMap();
            final HashMap subcomponentsNotInSeedWorkspace = new HashMap();
            final HashSet allInaccessibleSubcomponents = new HashSet();
            final HashSet inaccessibleSubcomponentsAndInSeedWorkspace = new HashSet();
            final IWorkspaceConnection seedWorkspaceConnection = selectedComponents.iterator().next().getWorkspaceConnection();
            final HashSet<UUID> subcomponentsNotToFetch = new HashSet<UUID>(selectedComponents.size());
            for (WorkspaceComponentWrapper componentWrapper : selectedComponents) {
                Assert.isTrue((boolean)componentWrapper.getWorkspaceConnection().equals((Object)seedWorkspaceConnection), (String)"All selected components must belong to the same workspace or stream.");
                subcomponentsNotToFetch.add(componentWrapper.getComponentHandle().getItemId());
            }
            ScmItemWorkingCopy.UIOperation<Object> op = new ScmItemWorkingCopy.UIOperation<Object>((ScmItemWorkingCopy)this){

                @Override
                protected Object runInBackground(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selectedComponents.size());
                        HashSet<UUID> componentsInSeedWorkspace = new HashSet<UUID>();
                        for (Object o : seedWorkspaceConnection.getComponents()) {
                            if (!(o instanceof IComponentHandle)) continue;
                            componentsInSeedWorkspace.add(((IComponentHandle)o).getItemId());
                        }
                        HashSet<UUID> inaccessibleComponentsInSeedworkspace = new HashSet<UUID>();
                        for (IComponentHandle component : seedWorkspaceConnection.getUnreadableComponents()) {
                            inaccessibleComponentsInSeedworkspace.add(component.getItemId());
                        }
                        IItemManager itemManager = seedWorkspaceConnection.teamRepository().itemManager();
                        for (WorkspaceComponentWrapper selectedComponent : selectedComponents) {
                            IComponent subcomponent;
                            IComponentHierarchyResult subcomponentResult = seedWorkspaceConnection.getComponentHierarchy(Collections.singletonList(selectedComponent.getComponentHandle()));
                            HashMap subcomponentsToFetch = new HashMap(subcomponentResult.getFlattenedElementsMap());
                            subcomponentsToFetch.keySet().removeAll(subcomponentsNotToFetch);
                            if (subcomponentsToFetch.isEmpty()) continue;
                            IFetchResult fetchResult = itemManager.fetchCompleteItemsPermissionAware(new ArrayList(subcomponentsToFetch.values()), 0, (IProgressMonitor)progress.newChild(1));
                            for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                                if (!(retrievedItem instanceof IComponent)) continue;
                                subcomponent = (IComponent)retrievedItem;
                                if (componentsInSeedWorkspace.contains(subcomponent.getItemId())) {
                                    subcomponentsToAdd.put(subcomponent.getItemId(), WorkspaceComponentWrapper.newWrapper(seedWorkspaceConnection, subcomponent));
                                } else {
                                    subcomponentsNotInSeedWorkspace.put(subcomponent.getItemId(), subcomponent);
                                }
                                subcomponentsNotToFetch.add(subcomponent.getItemId());
                            }
                            for (Object missingItem : fetchResult.getMissingItems()) {
                                if (!(missingItem instanceof IComponentHandle)) continue;
                                subcomponent = (IComponentHandle)missingItem;
                                allInaccessibleSubcomponents.add(subcomponent.getItemId());
                                if (inaccessibleComponentsInSeedworkspace.contains(subcomponent.getItemId())) {
                                    inaccessibleSubcomponentsAndInSeedWorkspace.add(subcomponent.getItemId());
                                }
                                subcomponentsNotToFetch.add(subcomponent.getItemId());
                            }
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                    }
                    return null;
                }

                @Override
                protected void updateUI(Object notUsed) {
                    if (!allInaccessibleSubcomponents.isEmpty()) {
                        String dialogMessage;
                        String dialogTitle;
                        if (!inaccessibleSubcomponentsAndInSeedWorkspace.isEmpty()) {
                            String dialogMessage2;
                            String dialogTitle2;
                            if (inaccessibleSubcomponentsAndInSeedWorkspace.size() == 1) {
                                dialogTitle2 = Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentDialogTitle;
                                UUID uuid = (UUID)inaccessibleSubcomponentsAndInSeedWorkspace.iterator().next();
                                dialogMessage2 = seedWorkspaceConnection.isStream() ? NLS.bind((String)Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentInStreamDialogMessage, (Object)uuid.getUuidValue()) : NLS.bind((String)Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentInWorkspaceDialogMessage, (Object)uuid.getUuidValue());
                            } else {
                                dialogTitle2 = Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentsDialogTitle;
                                dialogMessage2 = seedWorkspaceConnection.isStream() ? Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentsInStreamDialogMessage : Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentsInWorkspaceDialogMessage;
                            }
                            MessageDialog.openError((Shell)TeamPlaceWorkingCopy.this.getShell(), (String)dialogTitle2, (String)dialogMessage2);
                            return;
                        }
                        if (allInaccessibleSubcomponents.size() == 1) {
                            dialogTitle = Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentDialogTitle;
                            UUID uuid = (UUID)allInaccessibleSubcomponents.iterator().next();
                            dialogMessage = seedWorkspaceConnection.isStream() ? NLS.bind((String)Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentNotInStreamDialogMessage, (Object)uuid.getUuidValue()) : NLS.bind((String)Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentNotInWorkspaceDialogMessage, (Object)uuid.getUuidValue());
                        } else {
                            dialogTitle = Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentsDialogTitle;
                            dialogMessage = seedWorkspaceConnection.isStream() ? Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentsNotInStreamDialogMessage : Messages.TeamPlaceWorkingCopy_InaccessibleSubcomponentsNotInWorkspaceDialogMessage;
                        }
                        MessageDialog dialog = new MessageDialog(TeamPlaceWorkingCopy.this.getShell(), dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                        if (dialog.open() != 0) {
                            return;
                        }
                    }
                    TeamPlaceWorkingCopy.this.addComponentsAndSubcomponentsFromWrappers(selectedComponents, subcomponentsToAdd.values(), promptForReplace, notifyStateChanged);
                }
            };
            op.enqueue(this.getOperationRunner(), Messages.TeamPlaceWorkingCopy_AddComponentHierarchyJobName);
        }
    }

    private void addComponentsAndSubcomponentsFromWrappers(Collection<? extends AbstractWrapper> selectedWrappersToAdd, Collection<? extends AbstractWrapper> subWrappersToAdd, boolean promptForReplace, boolean notifyStateChanged) {
        block31: {
            ArrayList<AbstractWrapper> allComponentsToAdd;
            block33: {
                String[] buttons;
                String replaceQuestion;
                String replaceTitle;
                HashMap<UUID, ComponentEntry> subcomponentsAlreadyInWorkingCopy;
                HashMap<UUID, ComponentEntry> selectionAlreadyInWorkingCopy;
                block35: {
                    ComponentEntry entry;
                    block34: {
                        block32: {
                            IComponent component;
                            block30: {
                                if (!subWrappersToAdd.isEmpty()) break block30;
                                if (promptForReplace) {
                                    if (this.checkReplaceExistingComponents(selectedWrappersToAdd)) {
                                        this.addComponentsFromWrappers(selectedWrappersToAdd, notifyStateChanged);
                                    }
                                } else if (this.removeComponentsFromWrappersForReplace(selectedWrappersToAdd)) {
                                    this.addComponentsFromWrappers(selectedWrappersToAdd, notifyStateChanged);
                                }
                                break block31;
                            }
                            allComponentsToAdd = new ArrayList<AbstractWrapper>(selectedWrappersToAdd.size() + subWrappersToAdd.size());
                            selectionAlreadyInWorkingCopy = new HashMap<UUID, ComponentEntry>();
                            subcomponentsAlreadyInWorkingCopy = new HashMap<UUID, ComponentEntry>();
                            for (AbstractWrapper abstractWrapper : selectedWrappersToAdd) {
                                ComponentEntry entry2;
                                component = WorkspaceUtil.getComponent(abstractWrapper);
                                if (component == null || (entry2 = this.findMatchingEntry(component)) == null) continue;
                                selectionAlreadyInWorkingCopy.put(entry2.getBackingComponentItem().getItemId(), entry2);
                            }
                            for (AbstractWrapper abstractWrapper : subWrappersToAdd) {
                                ComponentEntry entry2;
                                component = WorkspaceUtil.getComponent(abstractWrapper);
                                if (component == null || (entry2 = this.findMatchingEntry(component)) == null) continue;
                                subcomponentsAlreadyInWorkingCopy.put(entry2.getBackingComponentItem().getItemId(), entry2);
                            }
                            if (!selectionAlreadyInWorkingCopy.isEmpty() || !subcomponentsAlreadyInWorkingCopy.isEmpty()) break block32;
                            allComponentsToAdd.addAll(selectedWrappersToAdd);
                            allComponentsToAdd.addAll(subWrappersToAdd);
                            break block33;
                        }
                        if (selectionAlreadyInWorkingCopy.isEmpty() || promptForReplace || !subcomponentsAlreadyInWorkingCopy.isEmpty()) break block34;
                        if (this.removeComponentsForReplace(new ArrayList<ComponentEntry>(selectionAlreadyInWorkingCopy.values()))) {
                            allComponentsToAdd.addAll(selectedWrappersToAdd);
                            allComponentsToAdd.addAll(subWrappersToAdd);
                        }
                        break block33;
                    }
                    int n = selectionAlreadyInWorkingCopy.size() + subcomponentsAlreadyInWorkingCopy.keySet().size();
                    boolean replacingEverything = n == selectedWrappersToAdd.size() + subWrappersToAdd.size();
                    replaceTitle = n == 1 ? Messages.TeamPlaceWorkingCopy_replaceComponentTitle : Messages.TeamPlaceWorkingCopy_replaceComponentsTitle;
                    replaceQuestion = "";
                    boolean isWorkspace = this.getMode().getType().equals((Object)TYPE.WORKSPACE);
                    if (!selectionAlreadyInWorkingCopy.isEmpty() && subcomponentsAlreadyInWorkingCopy.isEmpty()) {
                        if (selectionAlreadyInWorkingCopy.size() == 1) {
                            entry = (ComponentEntry)selectionAlreadyInWorkingCopy.entrySet().iterator().next().getValue();
                            replaceQuestion = isWorkspace ? NLS.bind((String)Messages.TeamPlaceWorkingCopy_componentExistsMsgWorkspace, (Object)entry.getName()) : NLS.bind((String)Messages.TeamPlaceWorkingCopy_componentExistsMsgStream, (Object)entry.getName());
                        } else {
                            replaceQuestion = isWorkspace ? Messages.TeamPlaceWorkingCopy_componentsExistMsgWorkspace : Messages.TeamPlaceWorkingCopy_componentsExistMsgStream;
                        }
                    } else if (selectionAlreadyInWorkingCopy.isEmpty() && !subcomponentsAlreadyInWorkingCopy.isEmpty()) {
                        if (subcomponentsAlreadyInWorkingCopy.size() == 1) {
                            entry = (ComponentEntry)subcomponentsAlreadyInWorkingCopy.entrySet().iterator().next().getValue();
                            replaceQuestion = isWorkspace ? NLS.bind((String)Messages.TeamPlaceWorkingCopy_subcomponentExistsMsgWorkspace, (Object)entry.getName()) : NLS.bind((String)Messages.TeamPlaceWorkingCopy_subcomponentExistsMsgStream, (Object)entry.getName());
                        } else {
                            replaceQuestion = isWorkspace ? Messages.TeamPlaceWorkingCopy_subcomponentsExistMsgWorkspace : Messages.TeamPlaceWorkingCopy_subcomponentsExistMsgStream;
                        }
                    } else if (selectionAlreadyInWorkingCopy.size() == 1 && subcomponentsAlreadyInWorkingCopy.size() == 1) {
                        ComponentEntry selection = (ComponentEntry)selectionAlreadyInWorkingCopy.entrySet().iterator().next().getValue();
                        ComponentEntry subcomponent = (ComponentEntry)subcomponentsAlreadyInWorkingCopy.entrySet().iterator().next().getValue();
                        replaceQuestion = isWorkspace ? NLS.bind((String)Messages.TeamPlaceWorkingCopy_componentAndSubcomponentExistMsgWorkspace, (Object[])new String[]{selection.getName(), subcomponent.getName()}) : NLS.bind((String)Messages.TeamPlaceWorkingCopy_componentAndSubcomponentExistMsgStream, (Object[])new String[]{selection.getName(), subcomponent.getName()});
                    } else {
                        replaceQuestion = this.getMode().getType().equals((Object)TYPE.WORKSPACE) ? (replacingEverything ? Messages.TeamPlaceWorkingCopy_allComponentsAndSubcomponentsExistMsgWorkspace : Messages.TeamPlaceWorkingCopy_componentsAndSubcomponentsExistMsgWorkspace) : (replacingEverything ? Messages.TeamPlaceWorkingCopy_allComponentsAndSubcomponentsExistMsgStream : Messages.TeamPlaceWorkingCopy_componentsAndSubcomponentsExistMsgStream);
                    }
                    replaceQuestion = n == 1 ? (replacingEverything ? String.valueOf(replaceQuestion) + Messages.TeamPlaceWorkingCopy_replaceAllSingleMsg : String.valueOf(replaceQuestion) + Messages.TeamPlaceWorkingCopy_replaceSingleMsg) : (replacingEverything ? String.valueOf(replaceQuestion) + Messages.TeamPlaceWorkingCopy_replaceAllPluralMsg : String.valueOf(replaceQuestion) + Messages.TeamPlaceWorkingCopy_replacePluralMsg);
                    if (!replacingEverything) break block35;
                    buttons = new String[]{Messages.TeamPlaceWorkingCopy_replaceButton, Messages.TeamPlaceWorkingCopy_cancelButton};
                    int returnCode = JFaceUtils.showMessageButtonsBlocking((String)replaceTitle, (String)replaceQuestion, (String[])buttons, (int)4, (int)1, null);
                    switch (returnCode) {
                        case -1: {
                            break;
                        }
                        case 0: {
                            if (this.removeComponentsForReplace(new ArrayList<ComponentEntry>(selectionAlreadyInWorkingCopy.values())) && this.removeComponentsForReplace(new ArrayList<ComponentEntry>(subcomponentsAlreadyInWorkingCopy.values()))) {
                                allComponentsToAdd.addAll(selectedWrappersToAdd);
                                allComponentsToAdd.addAll(subWrappersToAdd);
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block33;
                }
                buttons = new String[]{Messages.TeamPlaceWorkingCopy_addAndReplaceExistingButton, Messages.TeamPlaceWorkingCopy_addAndSkipExistingButton, Messages.TeamPlaceWorkingCopy_cancelButton};
                int returnCode = JFaceUtils.showMessageButtonsBlocking((String)replaceTitle, (String)replaceQuestion, (String[])buttons, (int)4, (int)1, null);
                switch (returnCode) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        if (!this.removeComponentsForReplace(new ArrayList<ComponentEntry>(selectionAlreadyInWorkingCopy.values())) || !this.removeComponentsForReplace(new ArrayList<ComponentEntry>(subcomponentsAlreadyInWorkingCopy.values()))) break;
                        allComponentsToAdd.addAll(selectedWrappersToAdd);
                        allComponentsToAdd.addAll(subWrappersToAdd);
                        break;
                    }
                    case 1: {
                        IComponent component;
                        for (AbstractWrapper abstractWrapper : selectedWrappersToAdd) {
                            component = WorkspaceUtil.getComponent(abstractWrapper);
                            if (selectionAlreadyInWorkingCopy.containsKey(component.getItemId())) continue;
                            allComponentsToAdd.add(abstractWrapper);
                        }
                        for (AbstractWrapper abstractWrapper : subWrappersToAdd) {
                            component = WorkspaceUtil.getComponent(abstractWrapper);
                            if (subcomponentsAlreadyInWorkingCopy.containsKey(component.getItemId())) continue;
                            allComponentsToAdd.add(abstractWrapper);
                        }
                        break;
                    }
                }
            }
            if (!allComponentsToAdd.isEmpty()) {
                this.addComponentsFromWrappers(allComponentsToAdd, notifyStateChanged);
            }
        }
    }

    protected void addComponentsFromWrappers(Collection<? extends AbstractWrapper> toAdd, boolean notifyStateChanged) {
        if (toAdd != null && !toAdd.isEmpty()) {
            Assert.isNotNull((Object)Display.getCurrent());
            for (AbstractWrapper abstractWrapper : toAdd) {
                ComponentEntry entry = null;
                if (abstractWrapper instanceof WorkspaceComponentWrapper) {
                    WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)abstractWrapper;
                    entry = new ComponentEntry(component, this.repository, this.workspaceConnection);
                } else if (abstractWrapper instanceof BaselineWrapper) {
                    BaselineWrapper baseline = (BaselineWrapper)abstractWrapper;
                    entry = new ComponentEntry(baseline, this.repository, this.workspaceConnection);
                }
                this.components.add(entry);
                this.componentsToAdd.add(entry);
            }
            if (notifyStateChanged) {
                this.stateChanged();
            }
        }
    }

    @Override
    public boolean isCreation() {
        return this.mode.isCreation();
    }

    public boolean isWorkspace() {
        return this.mode.isType(TYPE.WORKSPACE);
    }

    public boolean isStream() {
        return this.mode.isType(TYPE.STREAM);
    }

    public boolean isSnapshot() {
        return this.mode.isType(TYPE.SNAPSHOT);
    }

    public boolean isLoaded(IFolderHandle project, IProgressMonitor monitor) throws FileSystemException {
        ISharingDescriptor desc;
        IShare share;
        IShareable shareable;
        IWorkspaceConnection conn = this.getWorkspaceConnection();
        if (conn != null && (shareable = (IShareable)project.getAdapter(IShareable.class)) != null && (share = shareable.getShare(monitor)) != null && (desc = share.getSharingDescriptor()) != null) {
            return desc.isAssociatedWithConnection((IConnection)conn);
        }
        return false;
    }

    public String getDefaultComponentName() {
        return WorkspaceUtil.getDefaultComponentName(this.getPlaceName());
    }

    public void setComponentName(ComponentEntry entry, String name) {
        entry.setName(name);
        this.stateChanged(entry);
    }

    private void stateChanged(ComponentEntry entry) {
        if (!this.componentsToAdd.contains(entry) && !this.componentsToUpdate.contains(entry) && entry.getComponent() != null) {
            this.componentsToUpdate.add(entry);
        }
        this.stateChanged();
    }

    private void stateChanged(CollaborationEntry entry) {
        if (!this.collaborationsToAdd.contains(entry) && !this.collaborationsToUpdate.contains(entry)) {
            this.collaborationsToUpdate.add(entry);
        }
        this.stateChanged();
    }

    public ISetWithListeners<CollaborationEntry> getCollaborations() {
        return this.collaborations;
    }

    public List<CollaborationEntry> getCollaborationsToAdd() {
        return new ArrayList<CollaborationEntry>(this.collaborationsToAdd);
    }

    public List<CollaborationEntry> getCollaborationsToRemove() {
        return new ArrayList<CollaborationEntry>(this.collaborationsToRemove);
    }

    public List<CollaborationEntry> getCollaborationsToUpdate() {
        return new ArrayList<CollaborationEntry>(this.collaborationsToUpdate);
    }

    public CollaborationEntry addCollaboration(AbstractPlaceWrapper wrapper) {
        for (Object o : this.collaborations) {
            CollaborationEntry entry;
            if (!(o instanceof CollaborationEntry) || !wrapper.equals((Object)(entry = (CollaborationEntry)o).getCollaboration())) continue;
            return entry;
        }
        CollaborationEntry entry = new CollaborationEntry(wrapper);
        if (this.getDefaultIncomingCollaboration() == null) {
            this.setDefaultIncomingCollaboration(entry);
        }
        if (this.getDefaultOutgoingCollaboration() == null) {
            this.setDefaultOutgoingCollaboration(entry);
        }
        if (this.getCurrentIncomingCollaboration() == null) {
            this.setCurrentIncomingCollaboration(entry);
        }
        if (this.getCurrentOutgoingCollaboration() == null) {
            this.setCurrentOutgoingCollaboration(entry);
        }
        this.collaborationsToAdd.add(entry);
        this.collaborations.add((Object)entry);
        this.stateChanged();
        return entry;
    }

    public void removeCollaborations(List<CollaborationEntry> toRemove) {
        for (CollaborationEntry entry : toRemove) {
            if (!this.collaborations.toCollection().contains(entry)) continue;
            if (this.collaborationsToAdd.contains(entry)) {
                this.collaborationsToAdd.remove(entry);
            } else {
                this.collaborationsToRemove.add(entry);
            }
            this.collaborationsToUpdate.remove(entry);
            if (entry.equals(this.defaultIncomingCollaboration)) {
                this.defaultIncomingCollaboration = null;
            }
            if (entry.equals(this.defaultOutgoingCollaboration)) {
                this.defaultOutgoingCollaboration = null;
            }
            if (entry.equals(this.currentIncomingCollaboration)) {
                this.currentIncomingCollaboration = null;
            }
            if (entry.equals(this.currentOutgoingCollaboration)) {
                this.currentOutgoingCollaboration = null;
            }
            this.collaborations.remove((Object)entry);
        }
        this.stateChanged();
    }

    public CollaborationEntry getDefaultIncomingCollaboration() {
        return this.defaultIncomingCollaboration;
    }

    public CollaborationEntry getDefaultOutgoingCollaboration() {
        return this.defaultOutgoingCollaboration;
    }

    public void setDefaultIncomingCollaboration(CollaborationEntry entry) {
        if (this.defaultIncomingCollaboration != entry) {
            this.defaultIncomingCollaboration = entry;
            this.stateChanged();
            this.notifyListeners((Object)PROPERTY.DEFAULT_COLLABORATION);
        }
    }

    public void setDefaultOutgoingCollaboration(CollaborationEntry entry) {
        if (this.defaultOutgoingCollaboration != entry) {
            this.defaultOutgoingCollaboration = entry;
            this.stateChanged();
            this.notifyListeners((Object)PROPERTY.DEFAULT_COLLABORATION);
        }
    }

    public CollaborationEntry getCurrentIncomingCollaboration() {
        return this.currentIncomingCollaboration;
    }

    public CollaborationEntry getCurrentOutgoingCollaboration() {
        return this.currentOutgoingCollaboration;
    }

    public void setCurrentIncomingCollaboration(CollaborationEntry entry) {
        if (this.currentIncomingCollaboration != entry) {
            this.currentIncomingCollaboration = entry;
            this.stateChanged();
            this.notifyListeners((Object)PROPERTY.CURRENT_COLLABORATION);
        }
    }

    public void setCurrentOutgoingCollaboration(CollaborationEntry entry) {
        if (this.currentOutgoingCollaboration != entry) {
            this.currentOutgoingCollaboration = entry;
            this.stateChanged();
            this.notifyListeners((Object)PROPERTY.CURRENT_COLLABORATION);
        }
    }

    public void setCollaborationFlow(CollaborationEntry entry, int flowDirection) {
        entry.setFlowDirection(flowDirection);
        this.stateChanged(entry);
        this.notifyListeners((Object)PROPERTY.COLLABORATION_FLOW);
    }

    public void setComponentScopes(CollaborationEntry entry, List<IComponentHandle> componentHandles) {
        entry.setComponentScopes(componentHandles);
        this.stateChanged(entry);
    }

    public void replaceComponentFromBaseline(ComponentEntry componentToReplace, boolean addHierarchy, BaselineWrapper baseline) {
        this.addComponentsFromBaselines(Collections.singletonList(baseline), addHierarchy, false, true);
    }

    public void replaceComponentFromWorkspace(ComponentEntry componentToReplace, boolean addHierarchy, WorkspaceComponentWrapper replacement) {
        this.addComponentsFromWorkspace(Collections.singletonList(replacement), addHierarchy, false, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReplacement(IComponent toTest) {
        if (this.workspaceConnection == null) return false;
        try {
            IComponentHandle component;
            Object o;
            Iterator iterator = this.workspaceConnection.getComponents().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((o = iterator.next()) instanceof IComponentHandle) || !(component = (IComponentHandle)o).sameItemId((IItemHandle)toTest));
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void handleEvents(List events) {
        if (!this.isCreation()) {
            boolean syncComponents = false;
            boolean syncCollabs = false;
            for (Object o : events) {
                FlowTable newFlow;
                FlowTable oldFlow;
                if (!(o instanceof IPropertyChangeEvent)) continue;
                IPropertyChangeEvent event = (IPropertyChangeEvent)o;
                if ("components".equals(event.getProperty())) {
                    syncComponents = true;
                    continue;
                }
                if (!"flow table".equals(event.getProperty())) continue;
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                if (oldValue == null && newValue != null || oldValue != null && newValue == null) {
                    syncCollabs = true;
                    continue;
                }
                if (!(oldValue instanceof FlowTable) || !(newValue instanceof FlowTable) || (oldFlow = (FlowTable)oldValue).equals((Object)(newFlow = (FlowTable)newValue), true)) continue;
                syncCollabs = true;
            }
            if (syncComponents || syncCollabs) {
                this.synchronizeToRepository(syncComponents, syncCollabs);
            }
        }
    }

    public void setDescription(String text) {
        if (this.originalDescription.equals(text)) {
            text = null;
        }
        if (text == null ? this.description != null : !text.equals(this.description)) {
            String oldDesc = this.getDescription();
            this.description = text;
            this.stateChanged();
            if (!oldDesc.equals(this.getDescription())) {
                this.notifyListeners((Object)PROPERTY.DESCRIPTION);
            }
        }
    }

    public void setAutoLockPatterns(String text) {
        if (this.originalAutoLockPatterns.equals(text)) {
            text = null;
        }
        if (text == null ? this.autoLockPatterns != null : !text.equals(this.autoLockPatterns)) {
            String oldPattern = this.getAutoLockPatterns();
            this.autoLockPatterns = text;
            this.stateChanged();
            if (!oldPattern.equals(this.getAutoLockPatterns())) {
                this.notifyListeners((Object)PROPERTY.AUTO_LOCK_PATTERNS);
            }
        }
    }

    public void setAllBases(List<IBaseline> bases) {
        this.allBases = bases;
    }

    public List<IBaseline> getAllBases() {
        return this.allBases;
    }

    public String getDescription() {
        return this.description != null ? this.description : this.getOriginalDescription();
    }

    public String getOriginalDescription() {
        return this.originalDescription;
    }

    public String getAutoLockPatterns() {
        return this.autoLockPatterns != null ? this.autoLockPatterns : this.getOriginalAutoLockPatterns();
    }

    public String getOriginalAutoLockPatterns() {
        return this.originalAutoLockPatterns;
    }

    private void setCollaborations(WorkspaceData workspaceData) {
        this.defaultIncomingCollaboration = workspaceData.getDefaultIncomingCollaboration();
        this.defaultOutgoingCollaboration = workspaceData.getDefaultOutgoingCollaboration();
        this.currentIncomingCollaboration = workspaceData.getCurrentIncomingCollaboration();
        this.currentOutgoingCollaboration = workspaceData.getCurrentOutgoingCollaboration();
        List<CollaborationEntry> collabsToAdd = workspaceData.getCollaborations();
        if (collabsToAdd != null) {
            this.collaborations.addAll(collabsToAdd);
        }
        this.notifyListeners((Object)PROPERTY.COLLABORATION_FLOW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.LISTENER_MUTEX;
        synchronized (object) {
            AbstractPlaceWrapper wrapper = this.getWorkspaceWrapper();
            if (wrapper != null) {
                if (this.itemListener != null) {
                    IItemManager itemManager = wrapper.getRepository().itemManager();
                    itemManager.removeItemChangeListener((IItem)wrapper.getWorkspace(), this.itemListener);
                    itemManager.removeItemChangeListener(IComponent.ITEM_TYPE, this.itemListener);
                }
                if (this.ownerVizListener != null) {
                    IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
                    wm.removeGenericListener((Object)"component_owner", this.ownerVizListener);
                    wm.removeGenericListener((Object)"component_visibility", this.ownerVizListener);
                }
            }
            IBaselineSet snapshot = this.getOriginalSnapshot();
            if (this.getRepository() != null && snapshot != null && this.itemListener != null) {
                IItemManager itemManager = this.getRepository().itemManager();
                itemManager.removeItemChangeListener((IItem)snapshot, this.itemListener);
            }
            this.itemListener = null;
            this.ownerVizListener = null;
        }
        this.setWorkspaceConnection(null);
        this.componentsToAdd.clear();
        this.componentsToRemove.clear();
        this.componentsToUpdate.clear();
        this.components.clear();
        this.collaborationsToAdd.clear();
        this.collaborationsToRemove.clear();
        this.collaborationsToUpdate.clear();
        this.collaborations.clear();
        super.dispose();
    }

    public ITeamRepository getFolderRepo() {
        return this.folderRepo;
    }

    public void setFolderRepo(ITeamRepository folderRepo) {
        this.folderRepo = folderRepo;
    }

    @Override
    public IItemContainerHandle getParentFolder() {
        return this.parentFolder;
    }

    @Override
    public void setParentFolder(IItemContainerHandle parent) {
        this.parentFolder = parent;
    }

    @Override
    public boolean shouldAddToRootFolder() {
        return this.addToRootFolder;
    }

    @Override
    public void setShouldAddToRootFolder(boolean shouldAddToRootFolder) {
        this.addToRootFolder = shouldAddToRootFolder;
    }

    public Collection<CustomAttributeEntry> getCustomAttributeSet() {
        return this.customAttributes.values();
    }

    public void setCustomAttribute(String name, String newValue) {
        CustomAttributeEntry entry = this.customAttributes.get(name);
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        if (entry == null) {
            throw new IllegalArgumentException();
        }
        if (entry.getValue().equals(newValue)) {
            return;
        }
        this.customAttributes.put(entry.getName(), new CustomAttributeEntry(entry.getName(), newValue));
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public void removeCustomAttributes(Collection<CustomAttributeEntry> toRemove) {
        for (CustomAttributeEntry entryToRemove : toRemove) {
            if (this.customAttributes.remove(entryToRemove.getName()) == null) {
                throw new IllegalArgumentException();
            }
            this.customAttributesToRemove.add(entryToRemove.getName());
        }
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public void addCustomAttribute(CustomAttributeEntry entry) {
        if (this.customAttributes.containsKey(entry.getName())) {
            throw new IllegalArgumentException();
        }
        this.customAttributes.put(entry.getName(), new CustomAttributeEntry(entry.getName(), entry.getValue()));
        this.customAttributesToRemove.remove(entry.getName());
        this.stateChanged();
        this.notifyListeners((Object)PROPERTY.CUSTOM_ATTRIBUTES);
    }

    public boolean isCustomAttributesChanged() {
        return !this.customAttributesToRemove.isEmpty() || !this.getCustomAttributesToAdd().isEmpty();
    }

    public Map<String, Object> getCustomAttributesToAdd() {
        Map<String, Object> original = this.getOriginalCustomAttributes();
        HashMap<String, Object> toAdd = new HashMap<String, Object>();
        for (Map.Entry<String, CustomAttributeEntry> entry : this.customAttributes.entrySet()) {
            String name = entry.getValue().getName();
            if (original.containsKey(name) && original.get(name).equals(entry.getValue().getValue())) continue;
            toAdd.put(name, entry.getValue().getValue());
        }
        return toAdd;
    }

    private Map<String, Object> getOriginalCustomAttributes() {
        return this.originalCustomAttributes;
    }

    public String[] getCustomAttributesToRemove() {
        return this.customAttributesToRemove.toArray(new String[this.customAttributesToRemove.size()]);
    }

    public static enum MODE {
        NEW_STREAM(true, TYPE.STREAM),
        NEW_WORKSPACE(true, TYPE.WORKSPACE),
        EDIT_STREAM(false, TYPE.STREAM),
        EDIT_WORKSPACE(false, TYPE.WORKSPACE),
        EDIT_SNAPSHOT(false, TYPE.SNAPSHOT);

        private boolean isCreation;
        private TYPE type;

        private MODE(boolean isCreation, TYPE type) {
            this.isCreation = isCreation;
            this.type = type;
        }

        public boolean isCreation() {
            return this.isCreation;
        }

        public TYPE getType() {
            return this.type;
        }

        public boolean isType(TYPE type) {
            return this.type == type;
        }
    }

    public static enum PROPERTY {
        PLACE_NAME,
        OWNER,
        SNAPSHOT_CREATOR,
        SNAPSHOT_OWNER,
        DESCRIPTION,
        DEFAULT_COLLABORATION,
        CURRENT_COLLABORATION,
        COLLABORATION_FLOW,
        VISIBILITY,
        AUTO_LOCK_PATTERNS,
        CUSTOM_ATTRIBUTES;

    }

    public static class ProjectEntry {
        private IProject project;
        private IVersionableHandle versionableHandle;

        public ProjectEntry(IProject project, IVersionableHandle versionableHandle) {
            this.project = project;
            this.versionableHandle = versionableHandle;
        }

        public IProject getProject() {
            return this.project;
        }

        public IVersionableHandle getVersionableHandle() {
            return this.versionableHandle;
        }

        public int hashCode() {
            int result = this.project.hashCode();
            result = result * 17 + (this.versionableHandle == null ? 0 : this.versionableHandle.getItemId().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectEntry other = (ProjectEntry)obj;
            if (!this.project.equals((Object)other.project)) {
                return false;
            }
            return !(this.versionableHandle == null ? other.versionableHandle != null : !this.versionableHandle.sameItemId((IItemHandle)other.versionableHandle));
        }
    }

    private static class SameComponentItemId
    implements IFilter<ComponentEntry> {
        private ComponentEntry toTest;

        public SameComponentItemId(ComponentEntry toTest) {
            this.toTest = toTest;
        }

        public boolean select(ComponentEntry toTest) {
            IComponent c2backingItem = this.toTest.getBackingComponentItem();
            if (c2backingItem == null) {
                return toTest.equals(this.toTest);
            }
            return toTest.matches(c2backingItem);
        }
    }

    public static enum TYPE {
        WORKSPACE(Messages.TeamPlaceWorkingCopy_titleRepositoryWorkspace, Messages.TeamPlaceWorkingCopy_componentsDescRepositoryWorkspace, Messages.TeamPlaceWorkingCopy_newRepositoryWorkspace, Messages.TeamPlaceWorkingCopy_flowsDescRepositoryWorkspace, null, ImagePool.WORKSPACE),
        STREAM(Messages.TeamPlaceWorkingCopy_titleStream, Messages.TeamPlaceWorkingCopy_componentsDescStream, Messages.TeamPlaceWorkingCopy_newStream, Messages.TeamPlaceWorkingCopy_flowsDescStream, Messages.TeamPlaceWorkingCopy_autoLockDescStream, ImagePool.STREAM),
        SNAPSHOT(Messages.TeamPlaceWorkingCopy_titleSnapshot, Messages.TeamPlaceWorkingCopy_componentsDescSnapshot, null, null, null, ImagePool.SNAPSHOT);

        private String headerText;
        private String componentDescription;
        private String creationNameableName;
        private String collaborationDescription;
        private String autoLockDescription;
        private ImageDescriptor nameableImage;

        private TYPE(String headerText, String componentDescription, String creationNameableName, String collaborationDescription, String autoLockDescription, ImageDescriptor nameableImage) {
            this.headerText = headerText;
            this.componentDescription = componentDescription;
            this.creationNameableName = creationNameableName;
            this.collaborationDescription = collaborationDescription;
            this.autoLockDescription = autoLockDescription;
            this.nameableImage = nameableImage;
        }

        public ImageDescriptor getNameableImage() {
            return this.nameableImage;
        }

        public String getHeaderText() {
            return this.headerText;
        }

        public String getCollaborationDescription() {
            return this.collaborationDescription;
        }

        public String getComponentDescription() {
            return this.componentDescription;
        }

        public String getAutLockDescription() {
            return this.autoLockDescription;
        }

        public String getCreationNameableName() {
            return this.creationNameableName;
        }
    }

    private static class WorkspaceData {
        private IWorkspaceConnection connection;
        private String name;
        private IAuditable owner;
        private boolean isOwnerInaccessible = false;
        private IAuditable parentOwner;
        private String description;
        private String autoLockPatterns;
        private IReadScope readScope;
        private List<ComponentWrapper> components;
        private Map<ComponentWrapper, ComponentDetails> componentDetails;
        private List<CollaborationEntry> collaborations;
        private CollaborationEntry defaultIncomingCollaboration;
        private CollaborationEntry defaultOutgoingCollaboration;
        private CollaborationEntry currentIncomingCollaboration;
        private CollaborationEntry currentOutgoingCollaboration;
        private List<IBaseline> allBases;

        public WorkspaceData(IWorkspaceConnection connection, String name, String description, String autoLockPatterns, IAuditable owner, boolean isOwnerInaccessible, IAuditable parentOwner, IReadScope readScope, List<ComponentWrapper> components, List<CollaborationEntry> collaborations, CollaborationEntry defaultIncomingCollaboration, CollaborationEntry defaultOutgoingCollaboration, CollaborationEntry currentIncomingCollaboration, CollaborationEntry currentOutgoingCollaboration, Map<ComponentWrapper, ComponentDetails> componentDetails, List<IBaseline> allBases) {
            this.connection = connection;
            this.name = name;
            this.owner = owner;
            this.isOwnerInaccessible = isOwnerInaccessible;
            this.parentOwner = parentOwner;
            this.readScope = readScope;
            this.description = description;
            this.autoLockPatterns = autoLockPatterns;
            this.components = components;
            this.componentDetails = componentDetails;
            this.collaborations = collaborations;
            this.defaultIncomingCollaboration = defaultIncomingCollaboration;
            this.defaultOutgoingCollaboration = defaultOutgoingCollaboration;
            this.currentIncomingCollaboration = currentIncomingCollaboration;
            this.currentOutgoingCollaboration = currentOutgoingCollaboration;
            this.allBases = allBases;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getAutoLockPatterns() {
            return this.autoLockPatterns;
        }

        public IReadScope getReadScope() {
            return this.readScope;
        }

        public IWorkspaceConnection getConnection() {
            return this.connection;
        }

        public List<CollaborationEntry> getCollaborations() {
            return this.collaborations;
        }

        public CollaborationEntry getDefaultIncomingCollaboration() {
            return this.defaultIncomingCollaboration;
        }

        public CollaborationEntry getDefaultOutgoingCollaboration() {
            return this.defaultOutgoingCollaboration;
        }

        public CollaborationEntry getCurrentIncomingCollaboration() {
            return this.currentIncomingCollaboration;
        }

        public CollaborationEntry getCurrentOutgoingCollaboration() {
            return this.currentOutgoingCollaboration;
        }

        public IAuditable getOwner() {
            return this.owner;
        }

        public boolean isOwnerInaccessible() {
            return this.owner == null && this.isOwnerInaccessible;
        }

        public IAuditable getParentOwner() {
            return this.parentOwner;
        }

        public List<ComponentWrapper> getComponents() {
            return this.components;
        }

        public Map<ComponentWrapper, ComponentDetails> getComponentDetails() {
            return this.componentDetails;
        }

        public List<IBaseline> getAllBases() {
            return this.allBases;
        }
    }
}

