/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemWorkingCopy;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlaceHeader;
import com.ibm.team.filesystem.ui.views.TeamPlaceOverviewPage;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.WorkbenchUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IBaselineSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.progress.IJobRunnable;

public class TeamPlacePart2
extends ScmItemEditor
implements IShowEditorInput {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.TeamPlacePart";
    private TeamPlaceWorkingCopy fWorkingCopy;
    private TeamPlaceHeader fHeader;
    private TeamPlaceOverviewPage fOverviewPage;
    private Saveable fSaveable;

    public static void open(IWorkbenchPage page, TeamPlaceEditorInput input) {
        try {
            page.openEditor((IEditorInput)input, ID);
        }
        catch (PartInitException e) {
            StatusUtil.log(TeamPlacePart2.class, (Throwable)e);
        }
    }

    public static void open(IWorkbenchPage page, SnapshotEditorInput input) {
        try {
            page.openEditor((IEditorInput)input, ID);
        }
        catch (PartInitException e) {
            StatusUtil.log(TeamPlacePart2.class, (Throwable)e);
        }
    }

    @Override
    protected void createWorkingCopy() {
        if (this.fWorkingCopy == null) {
            this.fWorkingCopy = new TeamPlaceWorkingCopy(this.getEditorInput(), (IOperationRunner)this.getPartSiteJobRunner(), this.getSite().getShell());
            this.fWorkingCopy.addListener(this.getWorkingCopyChangeListener());
            IBaselineSet item = null;
            if (this.fWorkingCopy.isSnapshot()) {
                item = this.fWorkingCopy.getOriginalSnapshot();
            } else if (this.fWorkingCopy.getWorkspaceWrapper() != null) {
                item = this.fWorkingCopy.getWorkspaceWrapper().getWorkspace();
            }
            if (item != null) {
                this.registerWorkspaceDeletedListener((IItem)item, this.fWorkingCopy.getRepository());
            }
        }
    }

    private void registerWorkspaceDeletedListener(IItem item, ITeamRepository repo) {
        repo.itemManager().addItemChangeListener(item, this.getScmItemDeletedListener());
    }

    @Override
    public ScmItemWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == TeamPlaceWorkingCopy.class) {
            return this.fWorkingCopy;
        }
        return super.getAdapter(adapter);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        if (this.fHeader == null) {
            this.fHeader = new TeamPlaceHeader((IEditorPart)this, headerForm, this.fWorkingCopy);
            headerForm.addPart((IFormPart)this.fHeader);
        }
    }

    @Override
    public ScmItemEditorHeader getEditorHeader() {
        return this.fHeader;
    }

    protected void addPages() {
        try {
            this.fOverviewPage = new TeamPlaceOverviewPage((FormEditor)this, this.fWorkingCopy, (IOperationRunner)this.getPartSiteJobRunner());
            this.addPage((IFormPage)this.fOverviewPage);
            TextActionHandler textActionHandler = this.getTextActionHandler();
            if (textActionHandler != null) {
                this.fOverviewPage.addTextControls(textActionHandler);
            }
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    @Override
    public String getHelpID() {
        String helpID = null;
        TeamPlaceWorkingCopy.MODE mode = this.fWorkingCopy.getMode();
        if (mode == TeamPlaceWorkingCopy.MODE.EDIT_STREAM || mode == TeamPlaceWorkingCopy.MODE.NEW_STREAM) {
            helpID = "com.ibm.team.filesystem.ide.ui.editor_stream";
        } else if (mode == TeamPlaceWorkingCopy.MODE.EDIT_WORKSPACE || mode == TeamPlaceWorkingCopy.MODE.NEW_WORKSPACE) {
            helpID = "com.ibm.team.filesystem.ide.ui.editor_repositoryworkspace";
        } else if (mode == TeamPlaceWorkingCopy.MODE.EDIT_SNAPSHOT) {
            helpID = "com.ibm.team.filesystem.ide.ui.editor_snapshot";
        }
        return helpID;
    }

    public void setFocus() {
        if (this.fOverviewPage != null) {
            this.fOverviewPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Override
    public void updateTitle() {
        String name = "";
        if (this.fWorkingCopy != null) {
            name = this.fWorkingCopy.getNameableName();
            ResourceManager resourceManager = this.getResourceManager();
            if (resourceManager != null) {
                this.setTitleImage(this.getResourceManager().createImageWithDefault(this.fWorkingCopy.getNameableImage()));
            }
        }
        this.setPartName(name);
    }

    @Override
    public String getItemNotFoundExceptionMessage() {
        if (this.fWorkingCopy != null) {
            return NLS.bind((String)Messages.TeamPlacePart2_1, (Object)this.fWorkingCopy.getPlaceName());
        }
        return null;
    }

    @Override
    public String getLicenseNotGrantedExceptionMessage() {
        if (this.fWorkingCopy != null) {
            if (this.fWorkingCopy.isStream()) {
                return NLS.bind((String)Messages.TeamPlacePart2_3, (Object)this.fWorkingCopy.getPlaceName());
            }
            if (this.fWorkingCopy.isSnapshot()) {
                return NLS.bind((String)Messages.TeamPlacePart2_5, (Object)this.fWorkingCopy.getPlaceName());
            }
            return NLS.bind((String)Messages.TeamPlacePart2_4, (Object)this.fWorkingCopy.getPlaceName());
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.fWorkingCopy != null) {
            IBaselineSet item = null;
            if (this.fWorkingCopy.isSnapshot()) {
                item = this.fWorkingCopy.getOriginalSnapshot();
            } else if (this.fWorkingCopy.getWorkspaceWrapper() != null) {
                item = this.fWorkingCopy.getWorkspaceWrapper().getWorkspace();
            }
            if (item != null) {
                this.fWorkingCopy.getRepository().itemManager().removeItemChangeListener((IItem)item, this.getScmItemDeletedListener());
            }
            this.fWorkingCopy.removeListener(this.getWorkingCopyChangeListener());
            this.fWorkingCopy.dispose();
            this.fWorkingCopy = null;
        }
        this.fSaveable = null;
        this.fOverviewPage = null;
        this.fHeader = null;
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        Assert.isLegal((input instanceof TeamPlaceEditorInput || input instanceof SnapshotEditorInput ? 1 : 0) != 0);
        super.setInput(input);
    }

    public synchronized Saveable[] getSaveables() {
        if (this.fSaveable == null) {
            if (this.fWorkingCopy == null) {
                return new Saveable[0];
            }
            this.fSaveable = new TeamPlaceSaveable(this.fWorkingCopy);
        }
        return new Saveable[]{this.fSaveable};
    }

    public void showEditorInput(IEditorInput editorInput) {
        this.fOverviewPage.showEditorInput(editorInput);
    }

    private class TeamPlaceSaveable
    extends Saveable {
        private final TeamPlaceWorkingCopy workingCopy;

        private TeamPlaceSaveable(TeamPlaceWorkingCopy workingCopy) {
            Assert.isNotNull((Object)((Object)workingCopy));
            this.workingCopy = workingCopy;
        }

        TeamPlaceWorkingCopy getWorkingCopy() {
            return this.workingCopy;
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public IJobRunnable doSave(IProgressMonitor monitor, IShellProvider shellProvider) throws CoreException {
            TeamPlacePart2.this.commit(monitor);
            IStatus status = this.workingCopy.validateForSave();
            if (!status.isOK()) {
                TeamPlacePart2.this.fHeader.setSaveError(NLS.bind((String)Messages.TeamPlacePart2_ErrorDuringSave, (Object)status.getMessage()));
                this.workingCopy.setShowingSavePermissionError(false);
                monitor.setCanceled(true);
                return null;
            }
            TeamPlacePart2.this.fHeader.setSaveError(null);
            final Display display = shellProvider.getShell().getDisplay();
            final boolean fromWorkspaceOrSnapshot = !(!this.workingCopy.isWorkspace() && !this.workingCopy.isStream() || this.workingCopy.getOriginalPlace() == null && this.workingCopy.getOriginalSnapshot() == null);
            final String name = this.workingCopy.getNameableName();
            final boolean bnewStream = this.workingCopy.isStream() && this.workingCopy.isCreation();
            return new IJobRunnable(){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Display.getCurrent() == null) {
                            TeamPlaceSaveable.this.workingCopy.save(monitor);
                        } else {
                            TeamPlaceSaveable.this.workingCopy.saveStarting();
                            WorkbenchUtil.runBackgroundSave((IProgressMonitor)monitor, (Operation)new Operation(){

                                public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
                                    try {
                                        TeamPlaceSaveable.this.workingCopy.save(monitor);
                                    }
                                    catch (CoreException e) {
                                        throw new OperationFailedException(StatusUtil.newStatus((Object)this, (Throwable)e));
                                    }
                                }
                            }, (String)NLS.bind((String)Messages.TeamPlacePart2_0, (Object)name));
                            TeamPlaceSaveable.this.workingCopy.saveDone();
                        }
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (TeamPlacePart2.this.isDisposed()) {
                                    return;
                                }
                                TeamPlaceSaveable.this.workingCopy.saveSucceeded();
                                if (fromWorkspaceOrSnapshot || bnewStream) {
                                    TeamPlacePart2.this.setInput(TeamPlaceEditorInput.newForEdit(TeamPlaceSaveable.this.workingCopy.getWorkspaceWrapper()));
                                }
                            }
                        });
                        IBaselineSet teamPlace = null;
                        if (TeamPlaceSaveable.this.workingCopy.isSnapshot()) {
                            teamPlace = TeamPlaceSaveable.this.workingCopy.getOriginalSnapshot();
                        } else if (TeamPlaceSaveable.this.workingCopy.getWorkspaceWrapper() != null) {
                            teamPlace = TeamPlaceSaveable.this.workingCopy.getWorkspaceWrapper().getWorkspace();
                        }
                        if (teamPlace != null) {
                            TeamPlacePart2.this.registerWorkspaceDeletedListener((IItem)teamPlace, TeamPlaceSaveable.this.workingCopy.getRepository());
                        }
                        TeamPlaceSaveable.this.workingCopy.setShowingSavePermissionError(false);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        final Throwable rootException = e.getStatus().getException();
                        if (rootException instanceof TeamOperationCanceledException) {
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof PermissionDeniedException) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!TeamPlacePart2.this.isDisposed()) {
                                        Object data;
                                        if (TeamPlaceSaveable.this.workingCopy.isCreation() && TeamPlaceSaveable.this.workingCopy.getWorkspaceConnection() != null) {
                                            TeamPlaceSaveable.this.workingCopy.saveSucceeded();
                                        }
                                        if ((data = ((PermissionDeniedException)rootException).getData()) == null || !data.equals("com.ibm.team.internal.filesystem.ui.operations.permission.denied")) {
                                            TeamPlacePart2.this.fHeader.setSaveError(NLS.bind((String)Messages.TeamPlacePart2_ErrorDuringSave, (Object)rootException.getMessage()));
                                            TeamPlaceSaveable.this.workingCopy.setShowingSavePermissionError(true);
                                        }
                                    }
                                }
                            });
                            return Status.OK_STATUS;
                        }
                        if (rootException instanceof ItemNotFoundException) {
                            String message = NLS.bind((String)Messages.TeamPlacePart2_1, (Object)TeamPlaceSaveable.this.workingCopy.getPlaceName());
                            return StatusUtil.newStatus((Object)this, (String)message, (Throwable)new CoreException(StatusUtil.newStatus((Object)this, (String)message, (Throwable)rootException)));
                        }
                        return e.getStatus();
                    }
                    catch (OperationCanceledException e) {
                        return Status.CANCEL_STATUS;
                    }
                }
            };
        }

        public void disableUI(IWorkbenchPart[] parts, boolean closing) {
            this.workingCopy.saveStarting();
            super.disableUI(parts, closing);
        }

        public void enableUI(IWorkbenchPart[] parts) {
            this.workingCopy.saveDone();
            super.enableUI(parts);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TeamPlaceSaveable)) {
                return false;
            }
            TeamPlaceSaveable other = (TeamPlaceSaveable)((Object)object);
            return this.getWorkingCopy() == other.getWorkingCopy();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.getWorkingCopy().getNameableImage();
        }

        public String getName() {
            return this.getWorkingCopy().getNameableName();
        }

        public String getToolTipText() {
            return this.getWorkingCopy().getToolTipText();
        }

        public int hashCode() {
            return ((Object)((Object)this.getWorkingCopy())).hashCode();
        }

        public boolean isDirty() {
            return this.getWorkingCopy().isDirty();
        }
    }
}

