/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.SnapshotId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.filesystem.ide.ui.internal.editors.OwnerOrCreatorControl;
import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ide.ui.internal.views.AbstractCustomAttributeSection;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForSnapshotEditor;
import com.ibm.team.filesystem.ide.ui.internal.views.CustomAttributeSectionForStreamEditor;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.actions.TanActions;
import com.ibm.team.filesystem.ui.changes.actions.CompareWithSnapshotWizard;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.filesystem.ui.inputs.RepositoryFilesViewInput;
import com.ibm.team.filesystem.ui.queries.KnownTeamRepositoryQuery;
import com.ibm.team.filesystem.ui.views.CollaborationEntry;
import com.ibm.team.filesystem.ui.views.CollaborationsContentProvider;
import com.ibm.team.filesystem.ui.views.CollaborationsLabelProvider;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.views.ComponentsLabelProvider;
import com.ibm.team.filesystem.ui.views.EditCollaborationDialog;
import com.ibm.team.filesystem.ui.views.SetFlowTargetDirectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.WildcardFilter;
import com.ibm.team.internal.filesystem.ui.adapters.WrapperUtil;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineLabelProvider;
import com.ibm.team.internal.filesystem.ui.picker.ContributorPicker;
import com.ibm.team.internal.filesystem.ui.picker.TeamAreaPicker;
import com.ibm.team.internal.filesystem.ui.picker.VisibilityPicker;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.wizards.component.AddComponentWizard;
import com.ibm.team.internal.filesystem.ui.wizards.component.ComponentConfigurationPickerWizard;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.FilteredSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleComboViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.repository.rcp.ui.wizards.WizardDialogWithCustomButtons;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAccessGroupScope;
import com.ibm.team.scm.common.dto.IContributorDeferringScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class TeamPlaceOverviewPage
extends TeamFormPage {
    private static final int MIN_TABLE_WIDTH = 100;
    private static final int MIN_TABLE_HEIGHT = -1;
    public static final String PAGE_ID = "com.ibm.team.filesystem.ide.ui.TeamPlacePart.overview";
    private TeamPlaceWorkingCopy workingCopy;
    private IOperationRunner runner;
    private SimpleComboViewer repositoryViewer;
    private Text creationDateLabel;
    private Text modificationDateLabel;
    private OwnerOrCreatorControl workspaceOwnerControl;
    private OwnerOrCreatorControl snapshotCreatorControl;
    private OwnerOrCreatorControl snapshotOwnerControl;
    private Label visibilityControl;
    private Button browseVisibilityButton;
    private Button browseOwnerButton;
    private Text descriptionText;
    private SimpleTableViewer<ComponentEntry> componentsViewer;
    private ComponentsLabelProvider componentsLabelProvider;
    private boolean componentsHasFocus;
    private ISelectionChangedListener updateEnablementListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TeamPlaceOverviewPage.this.updateEnablement();
        }
    };
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection ssel;
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1) {
                Object firstElement = ssel.getFirstElement();
                IRunnableWithSelection runnableWithSelection = new IRunnableWithSelection(){

                    public void run(Object selectedObject, Shell targetShell) {
                        TeamPlaceOverviewPage.this.openCollaborationAction.run();
                    }
                };
                runnableWithSelection.run(firstElement, TeamPlaceOverviewPage.this.collaborationsViewer.getControl().getShell());
            }
        }
    };
    private Button newComponentButton;
    private Button replaceComponentButton;
    private Button loadOnSaveButton;
    private Button addComponentButton;
    private Button removeComponentsButton;
    private Action renameComponentAction;
    private Button showComponentInRepositoryFilesViewButton;
    private TableViewer collaborationsViewer;
    private final int NAME_COLUMN_WEIGHT = 52;
    private final int FLOW_COLUMN_WEIGHT = 16;
    private final int NAME_COLUMN_MIN_WIDTH = 125;
    private final int FLOW_COLUMN_MIN_WIDTH = 125;
    private Button addCollaborationButton;
    private Button removeCollaborationButton;
    private Button setDefaultCollaborationButton;
    private Button setCurrentCollaborationButton;
    private Button setCollaborationFlowButton;
    private Button editCollaborationButton;
    private CollaborationsLabelProvider collaborationsLabelProvider;
    private CollaborationsContentProvider collaborationsContentProvider;
    private OpenCollaborationAction openCollaborationAction;
    private Text autoLockText;
    private IChangeListener changeListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            if (TeamPlaceOverviewPage.this.getPartControl().isDisposed()) {
                return;
            }
            TeamPlaceOverviewPage.this.updateEnablement();
            if (property == "busy") {
                if (!TeamPlaceOverviewPage.this.workingCopy.isBusy()) {
                    TeamPlaceOverviewPage.this.updateComponentLabels();
                    if (TeamPlaceOverviewPage.this.workingCopy.isSnapshot()) {
                        TeamPlaceOverviewPage.this.updateSnapshotDetails();
                    }
                }
            } else if (property == TeamPlaceWorkingCopy.PROPERTY.OWNER) {
                TeamPlaceOverviewPage.this.updateOwner();
            } else if (property == TeamPlaceWorkingCopy.PROPERTY.SNAPSHOT_CREATOR || property == TeamPlaceWorkingCopy.PROPERTY.SNAPSHOT_OWNER) {
                if (TeamPlaceOverviewPage.this.workingCopy.isSnapshot()) {
                    TeamPlaceOverviewPage.this.updateSnapshotDetails();
                }
            } else if (property == TeamPlaceWorkingCopy.PROPERTY.DESCRIPTION) {
                TeamPlaceOverviewPage.this.updateDescription();
            } else if (property == TeamPlaceWorkingCopy.PROPERTY.AUTO_LOCK_PATTERNS) {
                TeamPlaceOverviewPage.this.updateAutoLockPatterns();
            } else if (property == TeamPlaceWorkingCopy.PROPERTY.VISIBILITY) {
                TeamPlaceOverviewPage.this.updateVisibility();
            } else if (property == TeamPlaceWorkingCopy.PROPERTY.DEFAULT_COLLABORATION || property == TeamPlaceWorkingCopy.PROPERTY.CURRENT_COLLABORATION || property == TeamPlaceWorkingCopy.PROPERTY.COLLABORATION_FLOW) {
                TeamPlaceOverviewPage.this.collaborationsViewer.refresh();
            }
        }
    };
    private ViewerComparator collaborationsComparator;
    private LabelColumn componentsLabelColumn;
    private Comparator componentsComparator;
    private ISelectionChangedListener selectionChangedListener;
    private TextActionHandler textActionHandler;
    private AbstractCustomAttributeSection customAttributeSection;

    public TeamPlaceOverviewPage(FormEditor editor, TeamPlaceWorkingCopy workingCopy, IOperationRunner runner) {
        super(editor, PAGE_ID, Messages.TeamPlaceOverviewPage_pageTitle);
        this.workingCopy = workingCopy;
        this.runner = runner;
    }

    private IOperationRunner getOperationRunner() {
        return this.runner;
    }

    private IStructuredSelection convertComponentSelectionForContextMenus(IStructuredSelection viewerSelection) {
        ArrayList<AbstractWrapper> wrappers = new ArrayList<AbstractWrapper>();
        for (Object next : viewerSelection) {
            if (!(next instanceof ComponentEntry)) continue;
            ComponentEntry entry = (ComponentEntry)next;
            if (this.workingCopy.getWorkspaceConnection() != null && entry.getComponent() != null) {
                wrappers.add(WorkspaceComponentWrapper.newWrapper(this.workingCopy.getWorkspaceConnection(), entry.getComponent().getComponent()));
                continue;
            }
            if (entry.getSourceBaseline() != null) {
                wrappers.add(entry.getSourceBaseline());
                continue;
            }
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(wrappers);
    }

    private Control createAutoLockSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(toolkit, parent, 384, Messages.TeamPlaceOverviewPage_autoLockTitle);
        String autoLockDescription = this.workingCopy.getMode().getType().getAutLockDescription();
        if (autoLockDescription != null) {
            section.setDescription(autoLockDescription);
        }
        Composite composite = toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        this.autoLockText = toolkit.createText(composite, "", 2626);
        this.autoLockText.setTextLimit(32768);
        this.autoLockText.setEnabled(true);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).applyTo((Control)this.autoLockText);
        this.updateAutoLockPatterns();
        this.autoLockText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeamPlaceOverviewPage.this.workingCopy.removeListener(TeamPlaceOverviewPage.this.changeListener);
                TeamPlaceOverviewPage.this.workingCopy.setAutoLockPatterns(TeamPlaceOverviewPage.this.autoLockText.getText());
                TeamPlaceOverviewPage.this.workingCopy.addListener(TeamPlaceOverviewPage.this.changeListener);
            }
        });
        return section;
    }

    private Control createCollaborationsSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(toolkit, parent, 384, Messages.TeamPlaceOverviewPage_flowsTitle);
        section.setDescription(this.workingCopy.getMode().getType().getCollaborationDescription());
        Composite composite = toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Composite tableComposite = toolkit.createComposite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 6).hint(1, 1).minSize(100, -1).applyTo((Control)tableComposite);
        Table table = toolkit.createTable(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TeamPlaceOverviewPage.this.doRemoveCollaborations();
                }
            }
        });
        TableColumnLayout columnLayout = new TableColumnLayout();
        TableColumn name = new TableColumn(table, 0);
        name.setText(Messages.TeamPlaceOverviewPage_ColumnName);
        columnLayout.setColumnData((Widget)name, (ColumnLayoutData)new ColumnWeightData(52, 125, true));
        TableColumn flowDirection = new TableColumn(table, 0);
        flowDirection.setText(Messages.TeamPlaceOverviewPage_ColumnFlowDirection);
        columnLayout.setColumnData((Widget)flowDirection, (ColumnLayoutData)new ColumnWeightData(16, 125, true));
        TableColumn currentFlowDirection = new TableColumn(table, 0);
        currentFlowDirection.setText(Messages.TeamPlaceOverviewPage_ColumnCurrent);
        columnLayout.setColumnData((Widget)currentFlowDirection, (ColumnLayoutData)new ColumnWeightData(16, 125, true));
        TableColumn defaultFlowDirection = new TableColumn(table, 0);
        defaultFlowDirection.setText(Messages.TeamPlaceOverviewPage_ColumnDefault);
        columnLayout.setColumnData((Widget)defaultFlowDirection, (ColumnLayoutData)new ColumnWeightData(16, 125, true));
        tableComposite.setLayout((Layout)columnLayout);
        this.collaborationsViewer = new TableViewer(table);
        this.collaborationsLabelProvider = new CollaborationsLabelProvider(this.collaborationsViewer);
        this.collaborationsViewer.setLabelProvider((IBaseLabelProvider)this.collaborationsLabelProvider);
        this.collaborationsComparator = new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                CollaborationEntry e1 = (CollaborationEntry)o1;
                CollaborationEntry e2 = (CollaborationEntry)o2;
                return e1.getName().compareToIgnoreCase(e2.getName());
            }
        };
        this.collaborationsViewer.setComparator(this.collaborationsComparator);
        this.collaborationsContentProvider = new CollaborationsContentProvider();
        this.collaborationsViewer.setContentProvider((IContentProvider)this.collaborationsContentProvider);
        this.collaborationsViewer.addSelectionChangedListener(this.updateEnablementListener);
        this.collaborationsViewer.addDoubleClickListener(this.doubleClickListener);
        MenuManager menuMgr = new MenuManager();
        this.openCollaborationAction = new OpenCollaborationAction();
        menuMgr.add((IAction)this.openCollaborationAction);
        table.setMenu(menuMgr.createContextMenu((Control)table));
        this.addCollaborationButton = this.createPushButton(composite, Messages.TeamPlaceOverviewPage_flowsAdd, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamPlaceOverviewPage.this.doAddCollaboration();
            }
        });
        this.removeCollaborationButton = this.createPushButton(composite, Messages.TeamPlaceOverviewPage_flowsRemove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamPlaceOverviewPage.this.doRemoveCollaborations();
            }
        });
        this.editCollaborationButton = this.createPushButton(composite, Messages.TeamPlaceOverviewPage_flowsEdit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamPlaceOverviewPage.this.doEditCollaboration(TeamPlaceOverviewPage.this.getFirstCollaborationSelection());
            }
        });
        this.setCollaborationFlowButton = this.createPushButton(composite, Messages.TeamPlaceOverviewPage_flowsSetFlow, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamPlaceOverviewPage.this.doSetCollaborationFlow(TeamPlaceOverviewPage.this.getFirstCollaborationSelection());
            }
        });
        this.setCurrentCollaborationButton = this.createPushButton(composite, Messages.TeamPlaceOverviewPage_flowsSetCurrent, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamPlaceOverviewPage.this.doSetCurrentCollaboration(TeamPlaceOverviewPage.this.getFirstCollaborationSelection());
            }
        });
        this.setDefaultCollaborationButton = this.createPushButton(composite, Messages.TeamPlaceOverviewPage_flowsSetDefault, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TeamPlaceOverviewPage.this.doSetDefaultCollaboration(TeamPlaceOverviewPage.this.getFirstCollaborationSelection());
            }
        });
        return section;
    }

    private Control createComponentsSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        boolean isSnapshot = this.workingCopy.isSnapshot();
        String sectionTitle = isSnapshot ? Messages.TeamPlaceOverviewPage_baselinesSectionTitle : Messages.TeamPlaceOverviewPage_componentsTitle;
        Section section = this.createSection(toolkit, parent, 384, sectionTitle);
        String componentDescription = this.workingCopy.getMode().getType().getComponentDescription();
        if (componentDescription != null) {
            section.setDescription(componentDescription);
        }
        Composite componentsComposite = toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)componentsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(componentsComposite);
        Composite filterComposite = toolkit.createComposite(componentsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterComposite);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)filterComposite);
        Label filterLabel = toolkit.createLabel(filterComposite, Messages.TeamPlaceOverviewPage_componentNameFilterLabel);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)filterLabel);
        final Text filterText = toolkit.createText(filterComposite, "", 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).hint(1, -1).applyTo((Control)filterText);
        Table table = toolkit.createTable(componentsComposite, 2818);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    TeamPlaceOverviewPage.this.doRemoveComponents();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(1, 5).hint(1, 1).minSize(100, -1).applyTo((Control)table);
        this.componentsViewer = new SimpleTableViewer(table, null, null);
        this.componentsLabelProvider = new ComponentsLabelProvider(this.componentsViewer, this.getOperationRunner(), this.workingCopy);
        this.componentsComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ComponentEntry)o1).getName().compareToIgnoreCase(((ComponentEntry)o2).getName());
            }
        };
        this.componentsLabelColumn = new LabelColumn(this.componentsViewer, "", -1, (IViewerLabelProvider)this.componentsLabelProvider).setComparator(this.componentsComparator);
        this.setComponentSelection(this.workingCopy.getComponentToSelectHandle());
        this.componentsViewer.getSelectionProvider().addSelectionChangedListener(this.updateEnablementListener);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newFilterText = filterText.getText();
                if (TeamPlaceOverviewPage.this.workingCopy != null && TeamPlaceOverviewPage.this.componentsViewer != null) {
                    ISetWithListeners<ComponentEntry> allComponents = TeamPlaceOverviewPage.this.workingCopy.getComponents();
                    FilteredSetWithListeners filteredComponents = new FilteredSetWithListeners(allComponents, (IFilter)new WildcardFilter(newFilterText));
                    TeamPlaceOverviewPage.this.componentsViewer.setInput((ISetWithListeners)filteredComponents);
                }
            }
        });
        MenuManager menuMgr = new MenuManager();
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)menuMgr);
        ContextMenuHelper.addNewSubmenu((IMenuManager)menuMgr, (boolean)false);
        ConvertingSelectionProvider sp = new ConvertingSelectionProvider(this.componentsViewer.getSelectionProvider()){

            protected ISelection convertFrom(ISelection viewerSelection) {
                return TeamPlaceOverviewPage.this.convertComponentSelectionForContextMenus((IStructuredSelection)viewerSelection);
            }
        };
        TanActions.addTanActions(null, (IMenuManager)menuMgr, (IWorkbenchSite)this.getSite(), (ISelectionProvider)sp, new String[]{"jazz.open"});
        this.getSite().registerContextMenu(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".components", menuMgr, (ISelectionProvider)sp);
        final Menu menu = menuMgr.createContextMenu((Control)table);
        table.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    ActionExtContributionItem tanItem;
                    MenuItem item = items[i];
                    if (item.getData() instanceof ActionExtContributionItem && "jazz.open".equals((tanItem = (ActionExtContributionItem)item.getData()).getId())) {
                        menu.setDefaultItem(items[i]);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.componentsViewer.setDoubleClickHandler((IRunnableWithSelection)new OpenAction(this.getSite().getPage()){

            public void run(Object selection, Shell targetShell) {
                Object convertedSelection = selection;
                if (selection instanceof ComponentEntry) {
                    ComponentEntry entry = (ComponentEntry)selection;
                    if (TeamPlaceOverviewPage.this.workingCopy.getWorkspaceConnection() != null && entry.getComponent() != null) {
                        convertedSelection = WorkspaceComponentWrapper.newWrapper(TeamPlaceOverviewPage.this.workingCopy.getWorkspaceConnection(), entry.getComponent().getComponent());
                    } else if (entry.getSourceBaseline() != null) {
                        convertedSelection = entry.getSourceBaseline();
                    }
                }
                super.run(convertedSelection, targetShell);
            }
        });
        this.componentsViewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                IStructuredSelection ss;
                event.detail = 0;
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    return;
                }
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                if ((TeamPlaceOverviewPage.this.workingCopy.isWorkspace() || TeamPlaceOverviewPage.this.workingCopy.isStream()) && TeamPlaceOverviewPage.this.workingCopy.getWorkspaceConnection() != null && (ss = (IStructuredSelection)selection).size() > 0) {
                    IWorkspace workspace = TeamPlaceOverviewPage.this.workingCopy.getWorkspaceConnection().getResolvedWorkspace();
                    boolean allValid = true;
                    Object[] objectArray = ss.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof WorkspaceComponentWrapper) {
                            WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)element;
                            if (workspace.sameItemId((IItemHandle)wrapper.getWorkspace())) {
                                allValid = false;
                                break;
                            }
                        } else if (element instanceof IComponentSyncContext) {
                            IComponentSyncContext componentSyncContext = (IComponentSyncContext)element;
                            IWorkspaceConnection wc = componentSyncContext.getOutgoingTeamPlace();
                            IComponent component = componentSyncContext.getComponent();
                            if (wc == null || wc.getResolvedWorkspace().sameItemId((IItemHandle)workspace) || component == null) {
                                allValid = false;
                                break;
                            }
                        } else {
                            allValid = false;
                            break;
                        }
                        ++n2;
                    }
                    if (allValid) {
                        event.detail = 1;
                    }
                }
            }

            public void drop(DropTargetEvent event) {
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
                    return;
                }
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() > 0) {
                    HashMap<UUID, WorkspaceComponentWrapper> components = new HashMap<UUID, WorkspaceComponentWrapper>(ss.size());
                    HashMap<UUID, WorkspaceComponentWrapper> componentsWithSubcomponents = new HashMap<UUID, WorkspaceComponentWrapper>(ss.size());
                    Object[] objectArray = ss.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof WorkspaceComponentWrapper) {
                            WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)element;
                            components.put(component.getComponent().getItemId(), component);
                            if (component.getHierarchyData() != null && !((IComponentHierarchyNode)component.getHierarchyData().getHierarchyNode()).getChildren().isEmpty()) {
                                componentsWithSubcomponents.put(component.getComponent().getItemId(), component);
                            }
                        } else if (element instanceof IComponentSyncContext) {
                            IComponentSyncContext componentSyncContext = (IComponentSyncContext)element;
                            IWorkspaceConnection wc = componentSyncContext.getOutgoingTeamPlace();
                            IComponent component = componentSyncContext.getComponent();
                            if (wc != null && component != null) {
                                components.put(component.getItemId(), WorkspaceComponentWrapper.newWrapper(wc, component));
                            }
                        }
                        ++n2;
                    }
                    if (!components.isEmpty()) {
                        boolean addHierarchy = false;
                        if (!componentsWithSubcomponents.isEmpty()) {
                            String dialogMessage;
                            String dialogTitle = Messages.TeamPlaceOverviewPage_addSubcomponentsDialogTitle;
                            if (componentsWithSubcomponents.size() == 1) {
                                WorkspaceComponentWrapper wrapper = (WorkspaceComponentWrapper)componentsWithSubcomponents.values().iterator().next();
                                dialogMessage = NLS.bind((String)Messages.TeamPlaceOverviewPage_addSubcomponentsDialogMessageSingle, (Object)wrapper.getComponent().getName());
                            } else {
                                dialogMessage = Messages.TeamPlaceOverviewPage_addSubcomponentsDialogMessageMulti;
                            }
                            int returnCode = JFaceUtils.showMessageButtonsBlocking((String)dialogTitle, (String)dialogMessage, (String[])new String[]{Messages.TeamPlaceOverviewPage_YesButtonLabel, Messages.TeamPlaceOverviewPage_NoButtonLabel, Messages.TeamPlaceOverviewPage_CancelButtonLabel}, (int)3, (int)0, null);
                            switch (returnCode) {
                                case -1: {
                                    return;
                                }
                                case 0: {
                                    addHierarchy = true;
                                    break;
                                }
                                case 1: {
                                    addHierarchy = false;
                                    break;
                                }
                                case 2: {
                                    return;
                                }
                            }
                        }
                        TeamPlaceOverviewPage.this.workingCopy.addComponentsFromWorkspace(new ArrayList<WorkspaceComponentWrapper>(components.values()), addHierarchy, true, true);
                        TeamPlaceOverviewPage.this.updateEnablement();
                    }
                }
            }
        });
        if (!isSnapshot) {
            this.newComponentButton = this.createPushButton(componentsComposite, Messages.TeamPlaceOverviewPage_componentsNew, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TeamPlaceOverviewPage.this.doNewComponent();
                }
            });
            this.addComponentButton = this.createPushButton(componentsComposite, Messages.TeamPlaceOverviewPage_componentsAdd, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TeamPlaceOverviewPage.this.doAddComponent();
                }
            });
            this.removeComponentsButton = this.createPushButton(componentsComposite, Messages.TeamPlaceOverviewPage_componentsRemove, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TeamPlaceOverviewPage.this.doRemoveComponents();
                }
            });
            this.renameComponentAction = new Action(){

                public void runWithEvent(Event event) {
                    List<ComponentEntry> selection = TeamPlaceOverviewPage.this.getComponentSelection();
                    if (!selection.isEmpty()) {
                        TeamPlaceOverviewPage.this.doRenameComponent(selection.get(0));
                    }
                }
            };
            this.renameComponentAction.setEnabled(false);
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameComponentAction);
            table.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    TeamPlaceOverviewPage.this.componentsHasFocus = true;
                    TeamPlaceOverviewPage.this.updateEnablement();
                }

                public void focusLost(FocusEvent e) {
                    TeamPlaceOverviewPage.this.componentsHasFocus = false;
                    TeamPlaceOverviewPage.this.updateEnablement();
                }
            });
            this.replaceComponentButton = this.createPushButton(componentsComposite, Messages.TeamPlaceOverviewPage_componentsReplaceWith, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List<ComponentEntry> selection = TeamPlaceOverviewPage.this.getComponentSelection();
                    if (!selection.isEmpty()) {
                        TeamPlaceOverviewPage.this.doReplaceComponent(selection.get(0));
                    }
                }
            });
        }
        this.showComponentInRepositoryFilesViewButton = this.createPushButton(componentsComposite, Messages.TeamPlaceOverviewPage_componentsShowInRFV, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Set namespaces = TeamPlaceOverviewPage.this.getSelectedNamespaces();
                if (!namespaces.isEmpty()) {
                    NamespaceSetId snapshotId = NamespaceSetId.create((ITeamRepository)((ItemNamespace)namespaces.iterator().next()).getRepository(), (Set)namespaces);
                    RepositoryFilesViewInput input = new RepositoryFilesViewInput((SnapshotId)snapshotId);
                    Parts.openView((IWorkbenchPage)TeamPlaceOverviewPage.this.getEditorSite().getPage(), (Object)input, (String)"com.ibm.team.filesystem.history.FileSystemView");
                }
            }
        });
        if (!isSnapshot && !this.workingCopy.isStream()) {
            this.loadOnSaveButton = toolkit.createButton(componentsComposite, Messages.TeamPlaceOverviewPage_componentsLoadOnSave, 32);
            this.loadOnSaveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TeamPlaceOverviewPage.this.workingCopy.setLoadOnSave(TeamPlaceOverviewPage.this.loadOnSaveButton.getSelection());
                }
            });
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.loadOnSaveButton);
        }
        return section;
    }

    private Set<ItemNamespace> getSelectedNamespaces() {
        List<ComponentEntry> selection = this.getComponentSelection();
        if (!selection.isEmpty()) {
            HashSet<ItemNamespace> namespaces = new HashSet<ItemNamespace>();
            for (ComponentEntry entry : selection) {
                ItemNamespace namespace = entry.getNamespace();
                if (namespace == null) continue;
                namespaces.add(namespace);
            }
            return namespaces;
        }
        return Collections.emptySet();
    }

    public List<ComponentEntry> getComponentSelection() {
        IStructuredSelection selection = this.componentsViewer.getSelection();
        ArrayList<ComponentEntry> components = new ArrayList<ComponentEntry>(selection.size());
        for (Object o : selection) {
            if (!(o instanceof ComponentEntry)) continue;
            components.add((ComponentEntry)o);
        }
        return components;
    }

    private void setComponentSelection(final IComponentHandle componentToSelectHandle) {
        if (componentToSelectHandle == null) {
            this.componentsViewer.setSelectionCriteria(null);
        } else {
            this.componentsViewer.setSelectionCriteria(new IFilter(){

                public boolean select(Object toTest) {
                    ComponentEntry entry;
                    if (toTest instanceof ComponentEntry && (entry = (ComponentEntry)toTest).getComponent() != null) {
                        return entry.getComponent().getComponent().sameItemId((IItemHandle)componentToSelectHandle);
                    }
                    return false;
                }
            });
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(body);
        Section infoSection = this.createInfoSection(body);
        int infoSpan = this.workingCopy.isSnapshot() ? 1 : 2;
        GridDataFactory.fillDefaults().grab(true, false).span(infoSpan, 1).applyTo((Control)infoSection);
        if (this.workingCopy.isSnapshot()) {
            Section linksSection = this.createLinksSection(body);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)linksSection);
        }
        Control componentsSection = this.createComponentsSection(body);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(componentsSection);
        if (!this.workingCopy.isSnapshot()) {
            Control collabSection = this.createCollaborationsSection(body);
            GridDataFactory.fillDefaults().grab(true, false).indent(0, 0).span(2, 1).applyTo(collabSection);
        }
        if (this.workingCopy.isStream()) {
            Control autoLockSection = this.createAutoLockSection(body);
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).minSize(160, -1).applyTo(autoLockSection);
        }
        if (this.workingCopy.isStream() || this.workingCopy.isSnapshot()) {
            Control customAttributeSection = this.createCustomAttributeSection(body);
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo(customAttributeSection);
        }
        this.componentsViewer.setInput(this.workingCopy.getComponents());
        Object[] components = this.workingCopy.getComponents().toArray();
        if (components.length > 0) {
            this.componentsViewer.getSelectionProvider().setSelection((ISelection)new StructuredSelection(components[0]));
        }
        if (this.collaborationsViewer != null) {
            this.collaborationsViewer.setInput((Object)this.workingCopy);
        }
        new TooltipSupport((Control)this.componentsViewer.getTable(), true, true);
        this.workingCopy.addListener(this.changeListener);
        this.updateEnablement();
    }

    private Control createCustomAttributeSection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        this.customAttributeSection = this.workingCopy.isSnapshot() ? new CustomAttributeSectionForSnapshotEditor(this.getOperationRunner(), parent, toolkit, this.workingCopy) : new CustomAttributeSectionForStreamEditor(this.getOperationRunner(), parent, toolkit, this.workingCopy);
        return this.customAttributeSection.getControl();
    }

    private Section createInfoSection(Composite parent) {
        FileSystemEditorToolkit toolkit = (FileSystemEditorToolkit)this.getManagedForm().getToolkit();
        Section infoSection = this.createSection(toolkit, parent, 256, Messages.TeamPlaceOverviewPage_detailsTitle);
        Composite infoComposite = toolkit.createComposite((Composite)infoSection);
        infoSection.setClient((Control)infoComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(LayoutConstants.getSpacing()).applyTo(infoComposite);
        if (this.workingCopy.isWorkspace() || this.workingCopy.isStream()) {
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_repositoryLabel);
            this.repositoryViewer = new SimpleComboViewer(infoComposite);
            this.repositoryViewer.sortByLabel();
            this.repositoryViewer.setInput((ISetWithListeners)new KnownTeamRepositoryQuery());
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (!sel.isEmpty()) {
                        TeamPlaceOverviewPage.this.updateSelectedRepository((ITeamRepository)sel.getFirstElement());
                    }
                }
            };
            this.repositoryViewer.getSelectionProvider().addSelectionChangedListener(this.selectionChangedListener);
            this.repositoryViewer.setSelectedElement((Object)this.workingCopy.getRepository());
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(350, -1).applyTo(this.repositoryViewer.getControl());
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_ownerLabel);
            this.workspaceOwnerControl = new OwnerOrCreatorControl(this.getSite(), toolkit, infoComposite, "owner");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.workspaceOwnerControl);
            this.browseOwnerButton = this.createPushButton(infoComposite, Messages.TeamPlaceOverviewPage_ownerBrowse, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TeamPlaceOverviewPage.this.workingCopy.isWorkspace()) {
                        TeamPlaceOverviewPage.this.doBrowseContributor();
                    } else {
                        TeamPlaceOverviewPage.this.doBrowseProcessArea();
                    }
                }
            });
            this.browseOwnerButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = TeamPlaceOverviewPage.this.workingCopy.isStream() ? Messages.TeamPlaceOverviewPage_BrowseOwnerAccessibilityNameForStream : Messages.TeamPlaceOverviewPage_BrowseOwnerAccessibilityNameForWorkspace;
                }
            });
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_VISIBILITY_LABEL);
            if (this.workingCopy.isWorkspace() || this.workingCopy.isStream()) {
                this.visibilityControl = toolkit.createLabel(infoComposite, "", 64);
                GridDataFactory.defaultsFor((Control)this.visibilityControl).align(1, 0x1000000).hint(-1, -1).applyTo((Control)this.visibilityControl);
                this.browseVisibilityButton = this.createPushButton(infoComposite, Messages.TeamPlaceOverviewPage_VISIBILITY_CHANGE_BUTTON, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (TeamPlaceOverviewPage.this.workingCopy.isWorkspace() || TeamPlaceOverviewPage.this.workingCopy.isStream()) {
                            TeamPlaceOverviewPage.this.doBrowseVisibility();
                        }
                    }
                });
                GridDataFactory.defaultsFor((Control)this.browseVisibilityButton).align(1, 0x1000000).applyTo((Control)this.browseVisibilityButton);
            }
            this.updateOwner();
            this.updateVisibility();
        } else if (this.workingCopy.isSnapshot()) {
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_creatorLabel);
            this.snapshotCreatorControl = new OwnerOrCreatorControl(this.getSite(), toolkit, infoComposite, "snapshotCreator");
            GridDataFactory.defaultsFor((Control)this.snapshotCreatorControl).grab(true, false).span(2, 1).applyTo((Control)this.snapshotCreatorControl);
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_ownerLabel);
            this.snapshotOwnerControl = new OwnerOrCreatorControl(this.getSite(), toolkit, infoComposite, "snapshotOwner");
            GridDataFactory.defaultsFor((Control)this.snapshotOwnerControl).grab(true, false).span(1, 1).applyTo((Control)this.snapshotOwnerControl);
            this.browseOwnerButton = this.createPushButton(infoComposite, Messages.TeamPlaceOverviewPage_ownerBrowse, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TeamPlaceOverviewPage.this.workingCopy.isSnapshot()) {
                        TeamPlaceOverviewPage.this.doBrowseSnapshotOwner();
                    }
                }
            });
            this.browseOwnerButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.TeamPlaceOverviewPage_BrowseSnapshotOwnerButtonDescription;
                }
            });
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_createdLabel);
            this.creationDateLabel = new Text(infoComposite, 8);
            GridDataFactory.defaultsFor((Control)this.creationDateLabel).grab(true, false).span(2, 1).applyTo((Control)this.creationDateLabel);
            toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_ModifiedOn);
            this.modificationDateLabel = new Text(infoComposite, 8);
            GridDataFactory.defaultsFor((Control)this.modificationDateLabel).grab(true, false).span(2, 1).applyTo((Control)this.modificationDateLabel);
            this.updateSnapshotDetails();
        }
        Label textLabel = toolkit.createLabel(infoComposite, Messages.TeamPlaceOverviewPage_descriptionLabel);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)textLabel);
        this.descriptionText = toolkit.createText(infoComposite, "", 2626);
        if (this.workingCopy.isWorkspace() || this.workingCopy.isStream()) {
            this.descriptionText.setTextLimit(32768);
        }
        int h = this.calcTextHeight(this.descriptionText, 3);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, h).span(2, 1).applyTo((Control)this.descriptionText);
        this.updateDescription();
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TeamPlaceOverviewPage.this.workingCopy.removeListener(TeamPlaceOverviewPage.this.changeListener);
                TeamPlaceOverviewPage.this.workingCopy.setDescription(TeamPlaceOverviewPage.this.descriptionText.getText());
                TeamPlaceOverviewPage.this.workingCopy.addListener(TeamPlaceOverviewPage.this.changeListener);
            }
        });
        return infoSection;
    }

    private int calcTextHeight(Text text, int numRows) {
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        int h = fm.getHeight() * numRows;
        Rectangle r = text.computeTrim(0, 0, 250, h);
        return r.height;
    }

    private Section createLinksSection(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = this.createSection(toolkit, parent, 256, Messages.TeamPlaceOverviewPage_linksTitle);
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().spacing(LayoutConstants.getSpacing()).applyTo(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)composite);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        FormText formText = toolkit.createFormText(composite, true);
        formText.setImage("workspace", resourceManager.createImage(ImagePool.CREATE_WORKSPACE));
        formText.setImage("stream", resourceManager.createImage(ImagePool.CREATE_STREAM));
        formText.setImage("compare", resourceManager.createImage(ImagePool.CHANGES_VIEW_ICON));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)formText);
        String content = "<form><li style=\"image\" value=\"workspace\"><a href=\"newWorkspace\">" + Messages.TeamPlaceOverviewPage_createNewRepositoryWorkspace + "</a></li>" + "<li style=\"image\" value=\"stream\"><a href=\"newStream\">" + Messages.TeamPlaceOverviewPage_createNewStream + "</a></li>" + "<li style=\"image\" value=\"compare\"><a href=\"compareWithSnapshot\">" + Messages.TeamPlaceOverviewPage_compareWithSnapshot + "</a></li>" + "<li style=\"image\" value=\"compare\"><a href=\"compareWithWorkspace\">" + Messages.TeamPlaceOverviewPage_compareWithOr + "</a></li>" + "</form>";
        formText.setText(content, true, false);
        formText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = Messages.TeamPlaceOverviewPage_createNewRepositoryWorkspace;
                }
            }
        });
        formText.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
                IStatusLineManager mgr = TeamPlaceOverviewPage.this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
                mgr.setMessage(null);
            }

            public void linkEntered(HyperlinkEvent e) {
                IStatusLineManager mgr = TeamPlaceOverviewPage.this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
                mgr.setMessage(e.getLabel());
            }

            public void linkActivated(HyperlinkEvent e) {
                Object href = e.getHref();
                if ("newWorkspace".equals(href)) {
                    TeamPlaceOverviewPage.this.doNewWorkspace();
                } else if ("newStream".equals(href)) {
                    TeamPlaceOverviewPage.this.doNewStream();
                } else if ("compareWithSnapshot".equals(href)) {
                    TeamPlaceOverviewPage.this.doCompareSnapshotWithSnapshot();
                } else if ("compareWithWorkspace".equals(href)) {
                    TeamPlaceOverviewPage.this.doCompareSnapshotWithWorkspaceOrStream();
                }
            }
        });
        return section;
    }

    private void doCompareSnapshotWithSnapshot() {
        CompareWithSnapshotWizard.open(this.getSite().getShell(), this.getSite().getPage(), this.workingCopy.getOriginalSnapshot());
    }

    private void doCompareSnapshotWithWorkspaceOrStream() {
        IBaselineSet snapshot = this.workingCopy.getOriginalSnapshot();
        ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)snapshot);
        AbstractPlaceWrapper workspace = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(this.getSite().getShell(), repo, null, null, WORKSPACES_OR_STREAMS.WORKSPACES, true, null, null, false);
        if (workspace != null) {
            ChangesViewConverter.compare(this.getSite().getPage(), (SnapshotId)BaselineSetId.create((ITeamRepository)this.workingCopy.getRepository(), (IBaselineSetHandle)snapshot), (SnapshotId)WorkspaceId.create((ITeamRepository)workspace.getRepository(), (IWorkspaceHandle)workspace.getWorkspace()));
        }
    }

    private Button createPushButton(Composite parent, String text, SelectionListener listener) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Button button = toolkit.createButton(parent, text, 8);
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    private Section createSection(FormToolkit toolkit, Composite parent, int style, String title) {
        Section section = toolkit.createSection(parent, style | 0x2000);
        section.setText(title);
        return section;
    }

    public void dispose() {
        TableViewer selectionProvider;
        this.workingCopy.removeListener(this.changeListener);
        this.workingCopy = null;
        this.changeListener = null;
        if (this.collaborationsViewer != null && (selectionProvider = this.collaborationsViewer) != null) {
            selectionProvider.removeSelectionChangedListener(this.updateEnablementListener);
            this.collaborationsViewer.setComparator(null);
            this.collaborationsViewer.setLabelProvider(null);
            this.collaborationsViewer.setContentProvider(null);
            this.collaborationsViewer.removeDoubleClickListener(this.doubleClickListener);
        }
        this.collaborationsComparator = null;
        if (this.collaborationsLabelProvider != null) {
            this.collaborationsLabelProvider.dispose();
        }
        this.collaborationsLabelProvider = null;
        if (this.collaborationsContentProvider != null) {
            this.collaborationsContentProvider.dispose();
        }
        this.collaborationsContentProvider = null;
        this.doubleClickListener = null;
        selectionProvider = this.componentsViewer.getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener(this.updateEnablementListener);
        }
        this.updateEnablementListener = null;
        this.componentsLabelColumn.setComparator(null);
        this.componentsComparator = null;
        this.componentsLabelColumn.dispose();
        this.componentsLabelColumn = null;
        this.componentsLabelProvider = null;
        if (this.repositoryViewer != null && (selectionProvider = this.repositoryViewer.getSelectionProvider()) != null) {
            selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        }
        this.selectionChangedListener = null;
        this.textActionHandler.setDeleteAction(null);
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.RENAME.getId()) == this.renameComponentAction) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
        }
        this.renameComponentAction = null;
        if (this.openCollaborationAction != null) {
            this.openCollaborationAction.dispose();
        }
        this.openCollaborationAction = null;
        this.workspaceOwnerControl = null;
        this.snapshotCreatorControl = null;
        this.snapshotOwnerControl = null;
        this.runner = null;
        if (this.customAttributeSection != null) {
            this.customAttributeSection.dispose();
            this.customAttributeSection = null;
        }
        this.initialize(null);
        super.dispose();
    }

    private void doAddCollaboration() {
        ArrayList<IWorkspaceHandle> toIgnore = new ArrayList<IWorkspaceHandle>();
        for (CollaborationEntry entry : this.workingCopy.getCollaborations().toCollection()) {
            toIgnore.add(entry.getHandle());
        }
        ITeamRepository repo = this.workingCopy.getRepository();
        AbstractPlaceWrapper pw = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(this.getSite().getShell(), repo, null, null, WORKSPACES_OR_STREAMS.STREAMS, true, null, toIgnore, false);
        if (pw == null) {
            return;
        }
        CollaborationEntry entry = this.workingCopy.addCollaboration(pw);
        this.collaborationsViewer.refresh();
        this.collaborationsViewer.setSelection((ISelection)new StructuredSelection((Object)entry));
    }

    private void doAddComponent() {
        AddComponentWizard.ICallback callback = new AddComponentWizard.ICallback(){

            @Override
            public void addComponentFromBaseline(BaselineWrapper toAdd, boolean addWithHierarchy) {
                TeamPlaceOverviewPage.this.workingCopy.addComponentsFromBaselines(Collections.singletonList(toAdd), addWithHierarchy, true, true);
                TeamPlaceOverviewPage.this.updateEnablement();
            }

            @Override
            public void addComponentsFromSnapshot(SnapshotWrapper toAdd) {
                TeamPlaceOverviewPage.this.workingCopy.addComponentsFromSnapshot(toAdd.getSnapshot(), true, true);
                TeamPlaceOverviewPage.this.updateEnablement();
            }

            @Override
            public void addComponentsFromWorkspace(List<WorkspaceComponentWrapper> toAdd, boolean addWithHierarchy) {
                TeamPlaceOverviewPage.this.workingCopy.addComponentsFromWorkspace(toAdd, addWithHierarchy, true, true);
                TeamPlaceOverviewPage.this.updateEnablement();
            }
        };
        IWorkspace toIgnore = this.workingCopy.getWorkspaceWrapper() == null ? null : this.workingCopy.getWorkspaceWrapper().getWorkspace();
        AddComponentWizard wizard = new AddComponentWizard(this.workingCopy.getRepository(), (IWorkspaceHandle)toIgnore, callback);
        WizardDialogWithCustomButtons dialog = new WizardDialogWithCustomButtons(this.getSite().getShell(), (IWizard)wizard, wizard.needsProgressMonitor(), true);
        dialog.open();
    }

    private void doBrowseSnapshotOwner() {
        ITeamRepository repo = this.workingCopy.getRepository();
        IBaselineSet snapshot = this.workingCopy.getOriginalSnapshot();
        WorkspaceAndStreamSelectionDialogOptions options = new WorkspaceAndStreamSelectionDialogOptions().setShowWorkspaces(WORKSPACES_OR_STREAMS.BOTH).setShowWorkspacesRadio(true).setToIgnore(Collections.singletonList(snapshot.getOwner())).setForceRepo(true).setAllowMultiSelect(false).setTarget(null).setComponents(null).setExactOwnerName(null).setFilter(null);
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream(this.getSite().getShell(), repo, options);
        if (wrapper != null) {
            IWorkspace snapshotOwner = wrapper.getWorkspace();
            this.workingCopy.setSnapshotOwner(snapshotOwner);
        }
    }

    private void doBrowseProcessArea() {
        ITeamRepository repo = this.workingCopy.getRepository();
        IProcessArea result = TeamAreaPicker.selectProcessArea(this.getSite().getShell(), repo, false, true);
        if (result != null) {
            this.doSetOwner((IAuditable)result);
        }
    }

    private void doBrowseContributor() {
        final ITeamRepository repo = this.workingCopy.getRepository();
        try {
            UIContext uiContext = UIContext.createShellContext((Shell)this.getSite().getShell());
            String shellTitle = Messages.OwnerSelectionField_4;
            String dialogTitle = Messages.OwnerSelectionField_9;
            String dialogMessage = Messages.OwnerSelectionField_5;
            final ItemId<IContributor> contributor = ContributorPicker.pickContributor(uiContext, shellTitle, dialogTitle, dialogMessage, repo, Collections.EMPTY_LIST);
            final Display display = Display.getCurrent();
            Button c = this.browseOwnerButton;
            this.getOperationRunner().enqueue(Messages.TeamPlaceOverviewPage_fetchingContributor, (Operation)new RepositoryOperation((Control)c){
                private final /* synthetic */ Control val$c;
                {
                    this.val$c = control;
                }

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    final IContributor theContributor = (IContributor)RepoFetcher.fetchCurrent((ITeamRepository)repo, (ItemId)contributor, (IProgressMonitor)progress.newChild(50));
                    SWTUtil.greedyExec((Display)display, (Control)this.val$c, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TeamPlaceOverviewPage.this.doSetOwner((IAuditable)theContributor);
                        }
                    });
                }
            });
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    private void doEditCollaboration(CollaborationEntry entry) {
        EditCollaborationDialog dialog = new EditCollaborationDialog(this.getSite().getShell(), this.workingCopy, entry, this.getOperationRunner());
        if (dialog.open() == 0) {
            this.collaborationsViewer.refresh();
        }
    }

    private void doBrowseVisibility() {
        IProjectArea projectArea = null;
        ITeamArea teamArea = null;
        if (this.workingCopy.isStream()) {
            IAuditable owner = this.workingCopy.getOwner();
            if (owner instanceof IProjectArea) {
                projectArea = (IProjectArea)owner;
            } else if (owner instanceof ITeamArea) {
                teamArea = (ITeamArea)owner;
                projectArea = (IProjectArea)this.workingCopy.getParentOwner();
            }
        }
        VisibilityPicker picker = new VisibilityPicker((IShellProvider)this.getSite(), this.workingCopy.getRepository(), this.workingCopy.getReadScope(), this.workingCopy.isStream() ? VisibilityPicker.PickerMode.STREAM : VisibilityPicker.PickerMode.WORKSPACE, this.workingCopy.isStream() ? Messages.TeamPlaceOverviewPage_streamVisibilityPickerDialogDescription : Messages.TeamPlaceOverviewPage_VisibilityPickerDialogDescription);
        picker.setProcessAreas(projectArea, teamArea);
        picker.setOwner(this.workingCopy.getOwner());
        if (picker.open() == 0) {
            this.workingCopy.setReadScope(picker.getReadScope());
        }
    }

    private void doNewComponent() {
        InputDialog dialog = new InputDialog(this.getSite().getShell(), Messages.TeamPlaceOverviewPage_componentsNewTitle, Messages.TeamPlaceOverviewPage_componentsNewMsg, "", WorkspaceUtil.getComponentNameValidator());
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getValue();
        ComponentEntry component = this.workingCopy.addComponent(name);
        this.componentsViewer.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)component));
    }

    private void doNewWorkspace() {
        IBaselineSet snapshot = this.workingCopy.getOriginalSnapshot();
        ITeamRepository repo = this.workingCopy.getRepository();
        ContributorWrapper contributor = new ContributorWrapper(repo.loggedInContributor());
        TeamPlacePart2.open(this.getSite().getPage(), TeamPlaceEditorInput.newWorkspace().setOwner(contributor).setRepository(repo).setOriginalSnapshot(snapshot).setReadScope((IReadScope)IReadScope.FACTORY.createPrivateScope()));
    }

    private void doNewStream() {
        IBaselineSet snapshot = this.workingCopy.getOriginalSnapshot();
        ITeamRepository repo = this.workingCopy.getRepository();
        TeamPlacePart2.open(this.getSite().getPage(), TeamPlaceEditorInput.newStream().setRepository(repo).setOriginalSnapshot(snapshot));
    }

    private void doRemoveCollaborations() {
        Table table;
        int[] selectionIndices;
        List<CollaborationEntry> collaborations = this.getCollaborationSelection();
        if (collaborations.size() > 0 && (selectionIndices = (table = this.collaborationsViewer.getTable()).getSelectionIndices()).length > 0) {
            int newIndex = table.getItemCount() - selectionIndices.length - 1;
            int i = 0;
            while (i < selectionIndices.length) {
                if (selectionIndices[i] < newIndex) {
                    newIndex = selectionIndices[i];
                }
                ++i;
            }
            this.workingCopy.removeCollaborations(collaborations);
            this.collaborationsViewer.refresh();
            if (newIndex > -1 && newIndex <= table.getItemCount()) {
                Object data = table.getItem(newIndex).getData();
                StructuredSelection selection = new StructuredSelection(data);
                this.collaborationsViewer.setSelection((ISelection)selection);
            }
        }
    }

    private CollaborationEntry getFirstCollaborationSelection() {
        ISelection selection = this.collaborationsViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof CollaborationEntry)) continue;
                return (CollaborationEntry)element;
            }
        }
        return null;
    }

    private List<CollaborationEntry> getCollaborationSelection() {
        ArrayList<CollaborationEntry> selectedItems = new ArrayList<CollaborationEntry>();
        ISelection selection = this.collaborationsViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object element : structuredSelection) {
                if (!(element instanceof CollaborationEntry)) continue;
                selectedItems.add((CollaborationEntry)element);
            }
        }
        return selectedItems;
    }

    private void doRemoveComponents() {
        Table table;
        int[] selectionIndices;
        List<ComponentEntry> components = this.getComponentSelection();
        if (!components.isEmpty() && (selectionIndices = (table = this.componentsViewer.getTable()).getSelectionIndices()).length > 0) {
            int newIndex = table.getItemCount() - selectionIndices.length - 1;
            int i = 0;
            while (i < selectionIndices.length) {
                if (selectionIndices[i] < newIndex) {
                    newIndex = selectionIndices[i];
                }
                ++i;
            }
            this.workingCopy.removeComponents(components);
            if (newIndex > -1 && newIndex <= table.getItemCount()) {
                Object data = table.getItem(newIndex).getData();
                StructuredSelection selection = new StructuredSelection(data);
                this.componentsViewer.getSelectionProvider().setSelection((ISelection)selection);
            }
        }
    }

    private void doRenameComponent(ComponentEntry entry) {
        InputDialog dialog = new InputDialog(this.getSite().getShell(), Messages.TeamPlaceOverviewPage_componentsRenameTitle, Messages.TeamPlaceOverviewPage_componentsRenameMsg, entry.getName(), WorkspaceUtil.getComponentNameValidator());
        if (dialog.open() != 0) {
            return;
        }
        String name = dialog.getValue();
        this.workingCopy.setComponentName(entry, name);
        this.updateComponentLabels();
    }

    private void doReplaceComponent(final ComponentEntry toReplace) {
        ComponentWrapper backingComponent = toReplace.getBackingComponent();
        if (backingComponent != null) {
            IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult> callback = new IPartResult<ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult>(){

                public void setResult(final ComponentConfigurationPickerWizard.ComponentConfigurationPickerResult result) {
                    if (result == null) {
                        return;
                    }
                    final Display d = Display.getCurrent();
                    TeamPlaceOverviewPage.this.getOperationRunner().enqueue(Messages.TeamPlaceOverviewPage_replacingComponent, (Operation)new RepositoryOperation(){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            try {
                                final Object wrapper = WrapperUtil.createWrapperFromNamespace(result.getItemNamespace(), (IProgressMonitor)progress.newChild(20));
                                SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (TeamPlaceOverviewPage.this.workingCopy != null) {
                                            if (wrapper instanceof BaselineWrapper) {
                                                BaselineWrapper replacement = (BaselineWrapper)wrapper;
                                                TeamPlaceOverviewPage.this.workingCopy.replaceComponentFromBaseline(toReplace, result.isReplaceWithHierarchy(), replacement);
                                            } else if (wrapper instanceof WorkspaceComponentWrapper) {
                                                WorkspaceComponentWrapper replacement = (WorkspaceComponentWrapper)wrapper;
                                                TeamPlaceOverviewPage.this.workingCopy.replaceComponentFromWorkspace(toReplace, result.isReplaceWithHierarchy(), replacement);
                                            }
                                        }
                                    }
                                });
                            }
                            finally {
                                progress.done();
                            }
                        }
                    });
                }
            };
            boolean hierarchyAware = FileSystemCore.getComponentHierarchyManager().isHierarchicalComponentsEnabled(this.workingCopy.getRepository());
            IWorkspace sourceWorkspace = this.workingCopy.getWorkspaceWrapper() == null ? null : this.workingCopy.getWorkspaceWrapper().getWorkspace();
            CollaborationEntry collab = this.workingCopy.getCurrentIncomingCollaboration();
            IWorkspaceHandle additionalScope = collab != null && !collab.isDeleted() ? collab.getHandle() : null;
            ComponentConfigurationPickerWizard wizard = new ComponentConfigurationPickerWizard(new ComponentConfigurationPickerWizard.ConfigurationPickerInput(ComponentConfigurationPickerWizard.ConfigurationPickerInput.ConfigurationPickerMode.REPLACE_COMPONENT, hierarchyAware), backingComponent, (IWorkspaceHandle)sourceWorkspace, additionalScope, true, false, callback);
            wizard.setDescription(Messages.TeamPlaceOverviewPage_ReplaceComponentDescription);
            wizard.setWindowTitle(Messages.TeamPlaceOverviewPage_ReplaceComponentTitle);
            WizardDialogWithCustomButtons dialog = new WizardDialogWithCustomButtons(this.getSite().getShell(), (IWizard)wizard, wizard.needsProgressMonitor(), true);
            dialog.open();
        }
    }

    private void doSetDefaultCollaboration(CollaborationEntry entry) {
        boolean setDefaultOutgoing;
        int flowDirection = entry.getFlowDirection();
        boolean setDefaultIncoming = (flowDirection & 1) != 0;
        boolean bl = setDefaultOutgoing = (flowDirection & 2) != 0;
        if ((flowDirection & 1) != 0 && (flowDirection & 2) != 0) {
            SetFlowTargetDirectionDialog dialog;
            CollaborationEntry defaultIncoming = this.workingCopy.getDefaultIncomingCollaboration();
            CollaborationEntry defaultOutgoing = this.workingCopy.getDefaultOutgoingCollaboration();
            int showFlowDirection = 0;
            if (defaultIncoming != null && defaultIncoming == entry) {
                showFlowDirection = 1;
            }
            if (defaultOutgoing != null && defaultOutgoing == entry) {
                showFlowDirection |= 2;
            }
            int oldFlowDirection = showFlowDirection;
            if (showFlowDirection == 0) {
                showFlowDirection = flowDirection;
            }
            if ((dialog = new SetFlowTargetDirectionDialog(this.getSite().getShell(), Messages.TeamPlaceOverviewPage_SetDefaultFlowTitle, Messages.TeamPlaceOverviewPage_SetDefaultFlowMessage, showFlowDirection)).open() == 0) {
                flowDirection = dialog.getFlowDirection();
                setDefaultIncoming = (oldFlowDirection & 1) != (flowDirection & 1);
                setDefaultOutgoing = (oldFlowDirection & 2) != (flowDirection & 2);
            } else {
                return;
            }
        }
        if (setDefaultIncoming) {
            this.workingCopy.setDefaultIncomingCollaboration((flowDirection & 1) != 0 ? entry : null);
        }
        if (setDefaultOutgoing) {
            this.workingCopy.setDefaultOutgoingCollaboration((flowDirection & 2) != 0 ? entry : null);
        }
        this.collaborationsViewer.refresh();
    }

    private void doSetCurrentCollaboration(CollaborationEntry entry) {
        boolean setDefaultOutgoing;
        int flowDirection = entry.getFlowDirection();
        boolean setDefaultIncoming = (flowDirection & 1) != 0;
        boolean bl = setDefaultOutgoing = (flowDirection & 2) != 0;
        if ((flowDirection & 1) != 0 && (flowDirection & 2) != 0) {
            SetFlowTargetDirectionDialog dialog;
            CollaborationEntry currentIncoming = this.workingCopy.getCurrentIncomingCollaboration();
            CollaborationEntry currentOutgoing = this.workingCopy.getCurrentOutgoingCollaboration();
            int showFlowDirection = 0;
            if (currentIncoming != null && currentIncoming == entry) {
                showFlowDirection = 1;
            }
            if (currentOutgoing != null && currentOutgoing == entry) {
                showFlowDirection |= 2;
            }
            int oldFlowDirection = showFlowDirection;
            if (showFlowDirection == 0) {
                showFlowDirection = flowDirection;
            }
            if ((dialog = new SetFlowTargetDirectionDialog(this.getSite().getShell(), Messages.TeamPlaceOverviewPage_SetCurrentFlowTitle, Messages.TeamPlaceOverviewPage_SetCurrentFlowMessage, showFlowDirection)).open() == 0) {
                flowDirection = dialog.getFlowDirection();
                setDefaultIncoming = (oldFlowDirection & 1) != (flowDirection & 1);
                setDefaultOutgoing = (oldFlowDirection & 2) != (flowDirection & 2);
            } else {
                return;
            }
        }
        if (setDefaultIncoming) {
            this.workingCopy.setCurrentIncomingCollaboration((flowDirection & 1) != 0 ? entry : null);
        }
        if (setDefaultOutgoing) {
            this.workingCopy.setCurrentOutgoingCollaboration((flowDirection & 2) != 0 ? entry : null);
        }
        this.collaborationsViewer.refresh();
    }

    private void doSetCollaborationFlow(CollaborationEntry entry) {
        SetFlowTargetDirectionDialog dialog = new SetFlowTargetDirectionDialog(this.getSite().getShell(), Messages.TeamPlaceOverviewPage_ChangeFlowTitle, Messages.TeamPlaceOverviewPage_ChangeFlowMessage, entry.getFlowDirection());
        if (dialog.open() == 0) {
            int flowDirection = dialog.getFlowDirection();
            CollaborationEntry defaultIncoming = this.workingCopy.getDefaultIncomingCollaboration();
            CollaborationEntry defaultOutgoing = this.workingCopy.getDefaultOutgoingCollaboration();
            CollaborationEntry currentIncoming = this.workingCopy.getCurrentIncomingCollaboration();
            CollaborationEntry currentOutgoing = this.workingCopy.getCurrentOutgoingCollaboration();
            if (defaultIncoming != null && defaultIncoming == entry && (flowDirection & 1) == 0) {
                this.workingCopy.setDefaultIncomingCollaboration(null);
            }
            if (defaultOutgoing != null && defaultOutgoing == entry && (flowDirection & 2) == 0) {
                this.workingCopy.setDefaultOutgoingCollaboration(null);
            }
            if (currentIncoming != null && currentIncoming == entry && (flowDirection & 1) == 0) {
                this.workingCopy.setCurrentIncomingCollaboration(null);
            }
            if (currentOutgoing != null && currentOutgoing == entry && (flowDirection & 2) == 0) {
                this.workingCopy.setCurrentOutgoingCollaboration(null);
            }
            if (this.workingCopy.getCollaborations().size() == 1) {
                if ((flowDirection & 1) == 1) {
                    if (defaultIncoming == null) {
                        this.workingCopy.setDefaultIncomingCollaboration(entry);
                    }
                    if (currentIncoming == null) {
                        this.workingCopy.setCurrentIncomingCollaboration(entry);
                    }
                }
                if ((flowDirection & 2) == 2) {
                    if (defaultOutgoing == null) {
                        this.workingCopy.setDefaultOutgoingCollaboration(entry);
                    }
                    if (currentOutgoing == null) {
                        this.workingCopy.setCurrentOutgoingCollaboration(entry);
                    }
                }
            }
            this.workingCopy.setCollaborationFlow(entry, flowDirection);
            this.collaborationsViewer.refresh();
        }
    }

    private void doSetOwner(IAuditable owner) {
        if (this.workingCopy != null) {
            this.workingCopy.setOwner(owner);
            if (owner != null) {
                if (owner instanceof ITeamArea) {
                    this.doSetParentOwner((ITeamArea)owner);
                }
                if (this.workingCopy.isStream()) {
                    this.workingCopy.setReadScope((IReadScope)IReadScope.FACTORY.createProcessAreaScope((IProcessAreaHandle)owner));
                }
            }
        }
    }

    private void doSetParentOwner(final ITeamArea owner) {
        final Display d = Display.getCurrent();
        this.getOperationRunner().enqueue(Messages.TeamPlaceOverviewPage_FetchingProjectAreaJobName, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                if (TeamPlaceOverviewPage.this.workingCopy == null || owner == null) {
                    return;
                }
                IProjectAreaHandle projectArea = owner.getProjectArea();
                IItemManager itemManager = TeamPlaceOverviewPage.this.workingCopy.getRepository().itemManager();
                final IAuditable fetchedProjectArea = (IAuditable)itemManager.fetchCompleteItem((IItemHandle)projectArea, 0, monitor);
                SWTUtil.greedyExec((Display)d, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (TeamPlaceOverviewPage.this.workingCopy != null) {
                            TeamPlaceOverviewPage.this.workingCopy.setParentOwner(fetchedProjectArea);
                        }
                    }
                });
            }
        });
    }

    private void updateOwner() {
        if (this.workingCopy.isSnapshot() && this.snapshotOwnerControl != null) {
            IWorkspace snapshotOwner = this.workingCopy.getSnapshotOwner();
            if (snapshotOwner == null) {
                this.snapshotOwnerControl.setOwner(null, false);
            } else {
                this.snapshotOwnerControl.setOwner((IItem)snapshotOwner, this.workingCopy.isOwnerInaccessible());
            }
        }
        if ((this.workingCopy.isWorkspace() || this.workingCopy.isStream()) && this.workspaceOwnerControl != null) {
            IAuditable owner = this.workingCopy.getOwner();
            this.workspaceOwnerControl.setOwner((IItem)owner, this.workingCopy.isOwnerInaccessible());
            if (this.workingCopy.getParentOwner() == null && owner instanceof ITeamArea) {
                this.doSetParentOwner((ITeamArea)owner);
            }
        }
    }

    private void updateCreator() {
        if (this.workingCopy.isSnapshot() && this.snapshotCreatorControl != null) {
            this.snapshotCreatorControl.setOwner((IItem)this.workingCopy.getSnapshotCreator(), this.workingCopy.isOwnerInaccessible());
        }
    }

    private void updateVisibility() {
        if (this.visibilityControl != null && !this.visibilityControl.isDisposed()) {
            String shortDescription;
            IReadScope readScope = this.workingCopy.getReadScope();
            if (readScope == null) {
                return;
            }
            String labelText = shortDescription = IReadScopeDescriber.FACTORY.shortDescription(readScope);
            if (readScope instanceof IContributorDeferringScope) {
                IAuditableHandle scope = ((IContributorDeferringScope)readScope).getScope();
                if (scope instanceof IProcessArea) {
                    labelText = NLS.bind((String)Messages.TeamPlaceOverviewPage_VISIBILITY_TYPE_AND_NAME, (Object)shortDescription, (Object)((IProcessArea)scope).getName());
                } else if (scope instanceof IProcessAreaHandle) {
                    final IProcessAreaHandle processAreaHandle = (IProcessAreaHandle)scope;
                    this.runner.enqueue(Messages.TeamPlaceOverviewPage_FETCHING_PROJECT_AREA, (Operation)new RepositoryOperation(){

                        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                            ITeamRepository repo = TeamPlaceOverviewPage.this.workingCopy.getRepository();
                            IItem item = null;
                            try {
                                item = repo.itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, monitor);
                            }
                            catch (Exception e) {
                                StatusUtil.log((Object)((Object)this), (Throwable)e);
                            }
                            if (item != null && item instanceof IProcessArea) {
                                final IProcessArea processArea = (IProcessArea)item;
                                Display display = TeamPlaceOverviewPage.this.visibilityControl.getDisplay();
                                if (!display.isDisposed()) {
                                    SWTUtil.greedyExec((Display)TeamPlaceOverviewPage.this.visibilityControl.getDisplay(), (Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            if (!TeamPlaceOverviewPage.this.visibilityControl.isDisposed()) {
                                                TeamPlaceOverviewPage.this.visibilityControl.setText(NLS.bind((String)Messages.TeamPlaceOverviewPage_VISIBILITY_TYPE_AND_NAME, (Object)shortDescription, (Object)processArea.getName()));
                                                TeamPlaceOverviewPage.this.visibilityControl.getParent().layout();
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            } else if (readScope instanceof IAccessGroupScope) {
                final IAccessGroupScope accessGroupScope = (IAccessGroupScope)readScope;
                this.runner.enqueue(Messages.TeamPlaceOverviewPage_FetchingAccessGroupJobName, (Operation)new RepositoryOperation(){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                        IAccessGroupClientService accessGroupService = (IAccessGroupClientService)TeamPlaceOverviewPage.this.workingCopy.getRepository().getClientLibrary(IAccessGroupClientService.class);
                        IAccessGroup accessGroup = accessGroupService.getAccessGroupForGroupContextId(accessGroupScope.getAccessGroupId(), monitor);
                        if (accessGroup != null) {
                            final String name = accessGroup.getName();
                            Display display = TeamPlaceOverviewPage.this.visibilityControl.getDisplay();
                            if (name != null && !display.isDisposed()) {
                                SWTUtil.greedyExec((Display)TeamPlaceOverviewPage.this.visibilityControl.getDisplay(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!TeamPlaceOverviewPage.this.visibilityControl.isDisposed()) {
                                            TeamPlaceOverviewPage.this.visibilityControl.setText(NLS.bind((String)Messages.TeamPlaceOverviewPage_VISIBILITY_TYPE_AND_NAME, (Object)shortDescription, (Object)name));
                                            TeamPlaceOverviewPage.this.visibilityControl.getParent().layout();
                                        }
                                    }
                                });
                            }
                        }
                    }
                });
            }
            this.visibilityControl.setText(labelText);
            this.visibilityControl.getParent().layout();
        }
    }

    private void updateSnapshotDetails() {
        IBaselineSet snapshot;
        if (!this.workingCopy.isSnapshot()) {
            return;
        }
        this.updateOwner();
        this.updateCreator();
        if (this.creationDateLabel != null && (snapshot = this.workingCopy.getOriginalSnapshot()) != null) {
            this.creationDateLabel.setText(BaselineLabelProvider.getDate(snapshot.getCreationDate()));
            this.modificationDateLabel.setText(BaselineLabelProvider.getDate(snapshot.modified()));
        }
        if (this.customAttributeSection != null) {
            boolean disableActions = this.workingCopy.isSnapshot() && this.workingCopy.getSnapshotOwner() != null && !this.workingCopy.getSnapshotOwner().isStream();
            this.customAttributeSection.setDisableAllWidgets(disableActions);
            Label snapshotCustomAttributeEnablementMessage = ((CustomAttributeSectionForSnapshotEditor)this.customAttributeSection).getSnapshotOwnedByWorkspaceMessage();
            if (snapshotCustomAttributeEnablementMessage != null) {
                snapshotCustomAttributeEnablementMessage.setVisible(disableActions);
                GridData gd = (GridData)snapshotCustomAttributeEnablementMessage.getLayoutData();
                if (gd.exclude == disableActions) {
                    gd.exclude = !disableActions;
                    this.getManagedForm().reflow(true);
                }
            }
        }
    }

    private void updateDescription() {
        if (this.descriptionText != null) {
            this.descriptionText.setText(this.workingCopy.getDescription());
        }
    }

    private void updateAutoLockPatterns() {
        if (this.autoLockText != null) {
            this.autoLockText.setText(this.workingCopy.getAutoLockPatterns());
        }
    }

    public void setFocus() {
        if (this.getLastActivePart() != null) {
            this.getLastActivePart().setFocus();
        } else {
            ScmItemEditorHeader formPart = ((TeamPlacePart2)this.getEditor()).getEditorHeader();
            formPart.setFocus();
        }
    }

    private void updateComponentLabels() {
        if (this.componentsLabelProvider != null) {
            this.componentsLabelProvider.updateAll();
        }
    }

    private void updateEnablement() {
        boolean areComponentsEditable;
        Object first = null;
        first = this.repositoryViewer != null ? this.repositoryViewer.getControl() : (this.workingCopy.isSnapshot() ? this.snapshotCreatorControl : this.workspaceOwnerControl);
        if (first != null && first.isDisposed()) {
            return;
        }
        boolean isCreation = this.workingCopy.isCreation();
        boolean isBusy = this.workingCopy.isBusy();
        boolean isWorkspace = this.workingCopy.isWorkspace();
        boolean isStream = this.workingCopy.isStream();
        boolean isSnapshot = this.workingCopy.isSnapshot();
        List<ComponentEntry> selectedComponents = this.getComponentSelection();
        int numComponentsSelected = selectedComponents.size();
        ComponentEntry selectedComponent = numComponentsSelected == 1 ? selectedComponents.get(0) : null;
        boolean bl = areComponentsEditable = isWorkspace || isStream;
        if (this.repositoryViewer != null) {
            this.repositoryViewer.getControl().setEnabled(isCreation && !isBusy);
        }
        if (this.browseOwnerButton != null) {
            this.browseOwnerButton.setEnabled(!isBusy);
        }
        if (this.browseVisibilityButton != null) {
            this.browseVisibilityButton.setEnabled(!isBusy);
        }
        if (this.workspaceOwnerControl != null) {
            this.workspaceOwnerControl.setEnabled(!isBusy);
        }
        if (this.snapshotCreatorControl != null) {
            this.snapshotCreatorControl.setEnabled(!isBusy);
        }
        if (this.snapshotOwnerControl != null) {
            this.snapshotOwnerControl.setEnabled(!isBusy);
        }
        if (this.descriptionText != null) {
            this.descriptionText.setEnabled(!isBusy);
        }
        if (!isSnapshot) {
            this.newComponentButton.setEnabled(areComponentsEditable && !isBusy);
            this.addComponentButton.setEnabled(areComponentsEditable && !isBusy && this.workingCopy.getRepository() != null);
            this.replaceComponentButton.setEnabled(areComponentsEditable && !isBusy && selectedComponent != null && selectedComponent.getBackingComponentItem() != null);
            boolean enableRemove = areComponentsEditable && !isBusy && numComponentsSelected > 0;
            this.removeComponentsButton.setEnabled(enableRemove);
            boolean enableRename = areComponentsEditable && selectedComponent != null && selectedComponent.isEditable() && !isBusy;
            this.renameComponentAction.setEnabled(enableRename && this.componentsHasFocus);
            List<CollaborationEntry> selectedCollaborations = this.getCollaborationSelection();
            int numCollaborationsSelected = selectedCollaborations.size();
            CollaborationEntry selectedCollaboration = numCollaborationsSelected == 1 ? selectedCollaborations.get(0) : null;
            this.addCollaborationButton.setEnabled(!isBusy && this.workingCopy.getRepository() != null);
            this.removeCollaborationButton.setEnabled(!isBusy && numCollaborationsSelected > 0);
            this.setDefaultCollaborationButton.setEnabled(!isBusy && numCollaborationsSelected == 1 && !selectedCollaboration.isDeleted() && ((selectedCollaboration.getFlowDirection() & 0xF) == 3 || (selectedCollaboration.getFlowDirection() & 1) == 1 && (this.workingCopy.getDefaultIncomingCollaboration() == null || this.workingCopy.getDefaultIncomingCollaboration() != selectedCollaboration) || (selectedCollaboration.getFlowDirection() & 2) == 2 && (this.workingCopy.getDefaultOutgoingCollaboration() == null || this.workingCopy.getDefaultOutgoingCollaboration() != selectedCollaboration)));
            this.setCurrentCollaborationButton.setEnabled(!isBusy && numCollaborationsSelected == 1 && !selectedCollaboration.isDeleted() && ((selectedCollaboration.getFlowDirection() & 0xF) == 3 || (selectedCollaboration.getFlowDirection() & 1) == 1 && (this.workingCopy.getCurrentIncomingCollaboration() == null || this.workingCopy.getCurrentIncomingCollaboration() != selectedCollaboration) || (selectedCollaboration.getFlowDirection() & 2) == 2 && (this.workingCopy.getCurrentOutgoingCollaboration() == null || this.workingCopy.getCurrentOutgoingCollaboration() != selectedCollaboration)));
            this.setCollaborationFlowButton.setEnabled(!isBusy && numCollaborationsSelected == 1 && !selectedCollaboration.isDeleted());
            this.editCollaborationButton.setEnabled(!isBusy && numCollaborationsSelected == 1 && !selectedCollaboration.isDeleted());
            if (this.loadOnSaveButton != null) {
                this.loadOnSaveButton.setEnabled(this.workingCopy.getComponentsToAdd().size() > 0);
            }
        }
        this.showComponentInRepositoryFilesViewButton.setEnabled(!isBusy && selectedComponents.size() > 0);
        if (isStream && this.autoLockText != null) {
            this.autoLockText.setEnabled(!isBusy);
        }
    }

    private void updateSelectedRepository(ITeamRepository repo) {
        this.workingCopy.setRepository(repo);
        if (this.workingCopy.isCreation() && this.workingCopy.isWorkspace()) {
            this.doSetOwner((IAuditable)repo.loggedInContributor());
        } else if (!repo.equals(this.workingCopy.getOwner() == null ? null : this.workingCopy.getOwner().getOrigin())) {
            this.doSetOwner(null);
        }
    }

    public void addTextControls(TextActionHandler textActionHandler) {
        this.textActionHandler = textActionHandler;
        if (this.descriptionText != null) {
            textActionHandler.addText(this.descriptionText);
        }
    }

    public void showEditorInput(IEditorInput editorInput) {
        TeamPlaceEditorInput input;
        if (editorInput instanceof TeamPlaceEditorInput && (input = (TeamPlaceEditorInput)editorInput).getComponentToSelect() != null) {
            this.setComponentSelection((IComponentHandle)input.getComponentToSelect().getComponent());
        }
    }

    private class OpenCollaborationAction
    extends SelectionProviderAction {
        public OpenCollaborationAction() {
            super((ISelectionProvider)TeamPlaceOverviewPage.this.collaborationsViewer, Messages.TeamPlaceOverviewPage_flowsOpen);
        }

        public void run() {
            IStructuredSelection sel = this.getStructuredSelection();
            for (CollaborationEntry entry : sel) {
                if (entry.isDeleted()) continue;
                TeamPlacePart2.open(TeamPlaceOverviewPage.this.getSite().getPage(), TeamPlaceEditorInput.newForEdit(entry.getCollaboration()));
            }
        }

        public void selectionChanged(IStructuredSelection selection) {
            CollaborationEntry entry;
            boolean enabled = false;
            Object obj = selection.getFirstElement();
            if (obj != null && obj instanceof CollaborationEntry && !(entry = (CollaborationEntry)obj).isDeleted()) {
                enabled = true;
            }
            this.setEnabled(enabled);
        }
    }
}

