/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ide.ui.internal.editors.ScmItemEditorHeader;
import com.ibm.team.filesystem.ui.views.TeamPlaceNamePart;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.IManagedForm;

public class TeamPlaceHeader
extends ScmItemEditorHeader {
    private TeamPlaceWorkingCopy fTeamPlaceWorkingCopy;
    private IMenuListener fMenuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            String[] actionsToRemove = new String[]{"com.ibm.team.filesystem.ui.actions.teamplace.RenameAbstractPlaceWrapperAction", "com.ibm.team.filesystem.ui.actions.teamplace.OpenSnapshotAction", "com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper.actions.ChangeSnapshotOwnerAction", "com.ibm.team.filesystem.actions.compareWorkspaces2", "com.ibm.team.filesystem.actions.CompareSnapshotAction", "com.ibm.team.filesystem.actions.addToFolder", "com.ibm.team.filesystem.actions.removeFromFolder", "com.ibm.team.filesystem.actions.moveToFolder"};
            TeamPlaceHeader.this.removeUnwantedMenus(manager, actionsToRemove);
        }
    };

    public TeamPlaceHeader(IEditorPart editor, IManagedForm header, TeamPlaceWorkingCopy workingCopy) {
        super(editor, header, workingCopy, new TeamPlaceNamePart(header, workingCopy));
        this.fTeamPlaceWorkingCopy = workingCopy;
        this.createEditorHeader();
        IMenuManager menuManager = this.getHeader().getForm().getForm().getMenuManager();
        if (menuManager != null) {
            menuManager.addMenuListener(this.fMenuListener);
        }
    }

    @Override
    public IChangeListener getDirtyListener() {
        return new IChangeListener(){

            public void changed(Object source, Object property) {
                if (property == TeamPlaceWorkingCopy.PROP_DIRTY) {
                    TeamPlaceHeader.this.onDirtyStateChanged();
                }
            }
        };
    }

    @Override
    public String getTitleText() {
        return this.fTeamPlaceWorkingCopy.getMode().getType().getHeaderText();
    }

    @Override
    public ImageDescriptor getTitleImageDescriptor() {
        return this.fTeamPlaceWorkingCopy.getNameableImage();
    }

    @Override
    public boolean isMenuNeeded() {
        return !this.isMenuCreated() && !this.fTeamPlaceWorkingCopy.isCreation();
    }

    @Override
    public ISelectionProvider getMenuSelectionProvider() {
        return new ISelectionProvider(){

            public ISelection getSelection() {
                AbstractWrapper element = null;
                if (TeamPlaceHeader.this.fTeamPlaceWorkingCopy.isSnapshot()) {
                    IBaselineSet snapshot = TeamPlaceHeader.this.fTeamPlaceWorkingCopy.getOriginalSnapshot();
                    IWorkspace snapshotOwner = TeamPlaceHeader.this.fTeamPlaceWorkingCopy.getOriginalSnapshotOwner();
                    element = snapshotOwner == null ? new RawSnapshotWrapper(snapshot) : new SnapshotWrapper(snapshotOwner, snapshot);
                } else {
                    element = TeamPlaceHeader.this.fTeamPlaceWorkingCopy.getWorkspaceWrapper();
                }
                if (element != null) {
                    return new StructuredSelection((Object)element);
                }
                return StructuredSelection.EMPTY;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        };
    }

    @Override
    public boolean isDragSupportNeeded() {
        return !this.isDragSupportAdded() && !this.fTeamPlaceWorkingCopy.isCreation();
    }

    @Override
    public Object getDragObject() {
        AbstractWrapper element = null;
        if (this.fTeamPlaceWorkingCopy.isSnapshot()) {
            IBaselineSet snapshot = this.fTeamPlaceWorkingCopy.getOriginalSnapshot();
            IWorkspace snapshotOwner = this.fTeamPlaceWorkingCopy.getOriginalSnapshotOwner();
            element = snapshotOwner == null ? new RawSnapshotWrapper(snapshot) : new SnapshotWrapper(snapshotOwner, snapshot);
        } else {
            element = this.fTeamPlaceWorkingCopy.getWorkspaceWrapper();
        }
        return element;
    }

    @Override
    public void dispose() {
        IMenuManager menuManager = this.getHeader().getForm().getForm().getMenuManager();
        if (menuManager != null) {
            menuManager.removeMenuListener(this.fMenuListener);
        }
        super.dispose();
    }
}

