/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.dto.IReadScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class TeamPlaceEditorInput
implements IEditorInput {
    private ITeamRepository repository;
    private AbstractWrapper owner;
    private AbstractPlaceWrapper place;
    private boolean creation;
    private boolean showCollaborations;
    private boolean isStream;
    private IBaselineSet snapshot;
    private WorkspaceComponentWrapper componentToSelect;
    private IReadScope readScope;
    private IItemContainer parentFolder;
    private boolean addToRootFolder = false;
    private IAuditable folderOwner;

    public static TeamPlaceEditorInput newWorkspace() {
        return new TeamPlaceEditorInput(false, true);
    }

    public static TeamPlaceEditorInput newStream() {
        return new TeamPlaceEditorInput(true, true);
    }

    public static TeamPlaceEditorInput newForEdit(AbstractPlaceWrapper element) {
        boolean isStream = element.getWorkspace().isStream();
        return new TeamPlaceEditorInput(isStream, false).setRepository(element.getRepository()).setPlace(element);
    }

    public static TeamPlaceEditorInput newForDuplicate(AbstractPlaceWrapper element) {
        boolean isStream = element.getWorkspace().isStream();
        return new TeamPlaceEditorInput(isStream, true).setRepository(element.getRepository()).setPlace(element);
    }

    public final TeamPlaceEditorInput setOriginalSnapshot(IBaselineSet snapshot) {
        this.snapshot = snapshot;
        this.repository = (ITeamRepository)snapshot.getOrigin();
        return this;
    }

    public final TeamPlaceEditorInput setPlace(AbstractPlaceWrapper element) {
        this.place = element;
        return this;
    }

    private TeamPlaceEditorInput(boolean isStream, boolean isCreation) {
        this.creation = isCreation;
        this.isStream = isStream;
    }

    public final TeamPlaceEditorInput setRepository(ITeamRepository repo) {
        this.repository = repo;
        return this;
    }

    public final TeamPlaceEditorInput setOwner(AbstractWrapper owner) {
        this.owner = owner;
        return this;
    }

    public final TeamPlaceEditorInput setReadScope(IReadScope readScope) {
        this.readScope = readScope;
        return this;
    }

    public boolean isStream() {
        return this.isStream;
    }

    public boolean isCreation() {
        return this.creation;
    }

    public AbstractWrapper getOwner() {
        return this.owner;
    }

    public AbstractPlaceWrapper getPlace() {
        return this.place;
    }

    public IItemContainer getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(IItemContainer parentFolder) {
        this.parentFolder = parentFolder;
    }

    public boolean shouldAddToRootFolder() {
        return this.addToRootFolder;
    }

    public void setAddToRootFolder(boolean shouldAddToRootFolder) {
        this.addToRootFolder = shouldAddToRootFolder;
    }

    public IAuditable getFolderOwner() {
        return this.folderOwner;
    }

    public void setFolderOwner(IAuditable folderOwner) {
        this.folderOwner = folderOwner;
    }

    public IBaselineSet getOriginalSnapshot() {
        return this.snapshot;
    }

    public ITeamRepository getRepository() {
        return this.repository;
    }

    public boolean getShowCollaborations() {
        return this.showCollaborations;
    }

    public IReadScope getReadScope() {
        return this.readScope;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.creation ? 1231 : 1237);
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.place == null ? 0 : this.place.hashCode());
        result = 31 * result + (this.repository == null ? 0 : this.repository.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TeamPlaceEditorInput other = (TeamPlaceEditorInput)obj;
        if (this.creation || other.creation) {
            return false;
        }
        if (this.place == null) {
            if (other.place != null) {
                return false;
            }
        } else {
            if (other.place == null) {
                return false;
            }
            if (!this.place.getWorkspace().sameItemId((IItemHandle)other.place.getWorkspace())) {
                return false;
            }
        }
        if (this.place == null && (this.owner == null ? other.owner != null : !this.owner.equals((Object)other.owner))) {
            return false;
        }
        return !(this.repository == null ? other.repository != null : !this.repository.equals(other.repository));
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.isStream ? ImagePool.STREAM : ImagePool.WORKSPACE;
    }

    public String getName() {
        if (this.place != null) {
            return this.place.getWorkspace().getName();
        }
        if (this.isStream) {
            return Messages.TeamPlaceEditorInput_newStream;
        }
        return Messages.TeamPlaceEditorInput_newWorkspace;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public WorkspaceComponentWrapper getComponentToSelect() {
        return this.componentToSelect;
    }

    public void setComponentToSelect(WorkspaceComponentWrapper componentToSelect) {
        this.componentToSelect = componentToSelect;
    }
}

