/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.queries.ConnectedProjectAreaQuery;
import com.ibm.team.filesystem.ui.queries.TeamAreasQuery;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ITreeProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.internal.util.ItemId;

public class TeamAreaTreeProvider
extends AbstractRepositoryTreeProvider
implements ITreeProvider {
    private IOperationRunner runner;

    public TeamAreaTreeProvider(IOperationRunner operationRunner) {
        this.runner = operationRunner;
    }

    public ISetWithListeners getChildren(Object element) {
        if (element instanceof ITeamRepository) {
            ITeamRepository repo = (ITeamRepository)element;
            return new ConnectedProjectAreaQuery(repo, this.runner);
        }
        if (element instanceof IProjectArea) {
            IProjectArea pa = (IProjectArea)element;
            return new TeamAreasQuery(ClientRepositoryUtil.getRepository((IItemHandle)pa), (ItemId<IProjectArea>)ItemId.forItem((IItem)pa), null, this.runner);
        }
        if (element instanceof ITeamArea) {
            ITeamArea ta = (ITeamArea)element;
            return new TeamAreasQuery(ClientRepositoryUtil.getRepository((IItemHandle)ta), (ItemId<IProjectArea>)new ItemId((IItemHandle)ta.getProjectArea()), ta, this.runner);
        }
        return null;
    }

    public IOperationRunner getOperationRunner() {
        return this.runner;
    }
}

