/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.views.TeamAreaTreeProvider;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchQuery;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class StreamsInTeamAreaTreeProvider
extends AbstractRepositoryTreeProvider {
    private TeamAreaTreeProvider teamAreaTree;
    private IOperationRunner runner;

    public StreamsInTeamAreaTreeProvider(IOperationRunner runner) {
        this.teamAreaTree = new TeamAreaTreeProvider(runner);
        this.runner = runner;
    }

    public ISetWithListeners getChildren(Object element) {
        final ConnectedProjectAreaRegistry projectRegistry = ConnectedProjectAreaRegistry.getDefault();
        if (element instanceof ITeamRepository) {
            final ITeamRepository repo = (ITeamRepository)element;
            return new RepositoryQuery(repo, this.runner){

                protected void attachListeners() {
                }

                protected void detachListeners() {
                }

                protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
                    if (projectRegistry != null) {
                        return projectRegistry.getConnectedProjectAreas(repo);
                    }
                    StatusUtil.log((Object)((Object)this), (int)2, (String)"Project areas could not be fetched. This is because ConnectedProjectAreaRegistry.getDefault() is null, which can happen if Eclipse is shutting down.");
                    return Collections.emptyList();
                }

                public String getName() {
                    return Messages.StreamsInTeamAreaTreeProvider_ProjectAreasName;
                }
            };
        }
        if (element instanceof IProjectAreaHandle) {
            IProjectAreaHandle pa = (IProjectAreaHandle)element;
            ITeamRepository tr = ClientRepositoryUtil.getRepository((IItemHandle)pa);
            PlaceSearchCriteria criteria = new PlaceSearchCriteria(tr, (IConnectedProjectAreaRegistry)projectRegistry).withOwnedBy((ItemId<? extends IAuditable>)new ItemId((IItemHandle)pa));
            criteria.setMaxResults(Integer.MAX_VALUE);
            PlaceSearchQuery query = (PlaceSearchQuery)criteria.getQuery(this.runner);
            query.setSupportDynamicUpdate(true);
            return query;
        }
        return this.teamAreaTree.getChildren(element);
    }
}

