/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ide.ui.internal.actions.search.AbstractSearchAction;
import com.ibm.team.filesystem.ui.actions.TanActions;
import com.ibm.team.filesystem.ui.queries.StreamSnapshotsQuery;
import com.ibm.team.filesystem.ui.views.SnapshotEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.SimpleLocalSelectionTargetAdapter;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.RepositoryUiPlugin;
import com.ibm.team.repository.rcp.ui.internal.menus.AbstractActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.IMenuExt;
import com.ibm.team.repository.rcp.ui.internal.menus.MenuExt;
import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.ContextMenuHandler;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.EmptySetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IRefreshable;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.LabelColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.TableViewerColumn;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IContextMenuHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.IGlobalActionHandler;
import com.ibm.team.repository.rcp.ui.parts.IMenuProvider;
import com.ibm.team.repository.rcp.ui.parts.IPartSiteServices;
import com.ibm.team.repository.rcp.ui.parts.IReusablePart;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class SnapshotListView
extends AbstractPart
implements IReusablePart,
IRefreshable,
IMenuProvider {
    private SimpleTableViewer viewer;
    private ITeamRepository teamRepository;
    private StreamSnapshotsQuery query;
    private AbstractActionExt refreshAction;
    private MenuExt menu;

    public SnapshotListView(IControlSite site, Object input) {
        super(site, input);
        IContextMenuHandler cmh = (IContextMenuHandler)Adapters.getAdapter((Object)site, IContextMenuHandler.class);
        if (cmh == null) {
            throw new IllegalArgumentException("This view can only be hosted in a site that supports context menus");
        }
        final IPartSiteServices pss = (IPartSiteServices)Adapters.getAdapter((Object)site, IPartSiteServices.class);
        IEclipsePreferences prefs = this.getConfigPrefs();
        this.viewer = new SimpleTableViewer(site.getParent(), 82690, prefs.node("table"), (IContextMenuHandler)new ContextMenuHandler(cmh));
        this.viewer.setProgressService((IBusyHandler)site);
        ConvertColumn dateColumn = new ConvertColumn(this.viewer, Messages.SnapshotListView_2, 100, (IConversion)new IConversion<SnapshotWrapper, Date>(){

            public Date createAdapter(SnapshotWrapper wrapper) {
                return wrapper.getSnapshot().getCreationDate();
            }
        });
        dateColumn.setCellComparator((Comparator)new Comparator<Date>(){

            @Override
            public int compare(Date date1, Date date2) {
                return date1.compareTo(date2);
            }
        });
        new LabelColumn(this.viewer, Messages.SnapshotListView_4, 350);
        this.viewer.setSortColumn((TableViewerColumn)dateColumn, false);
        site.setSelectionProvider(this.viewer.getSelectionProvider());
        if (cmh != null) {
            cmh.registerContextMenu(this.viewer.getContextMenu(), this.viewer.getSelectionProvider());
        }
        MenuManager menuMgr = this.viewer.getContextMenu();
        ContextMenuHelper.addNewSubmenu((IMenuManager)menuMgr, (boolean)false);
        MenuUtil.setDefaultAction(menuMgr, "com.ibm.team.filesystem.ui.actions.teamplace.OpenSnapshotAction");
        this.viewer.setDoubleClickHandler(new IRunnableWithSelection(){

            public void run(Object selectedObject, Shell targetShell) {
                SnapshotWrapper wrapper = (SnapshotWrapper)((Object)selectedObject);
                if (pss != null) {
                    TeamPlacePart2.open(pss.getPage(), SnapshotEditorInput.newForEdit(wrapper.getSnapshot()));
                }
            }
        });
        this.viewer.addDragSupport(21, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new SimpleLocalSelectionTargetAdapter(this.viewer));
        this.refreshAction = new AbstractActionExt(ImagePool.REFRESH_ICON, ImagePool.REFRESH_ICON, Messages.SnapshotListView_6, Messages.SnapshotListView_7){

            public void run() {
                SnapshotListView.this.refresh();
            }

            public int getStyle() {
                return 8;
            }
        };
        this.menu = new MenuExt();
        this.menu.add((IActionExt)this.refreshAction);
        IGlobalActionHandler gah = (IGlobalActionHandler)Adapters.getAdapter((Object)site, IGlobalActionHandler.class);
        TanActions.addTanActions(gah, (IMenuManager)menuMgr, (IWorkbenchSite)pss.getPart().getSite(), this.viewer.getSelectionProvider(), IMenuOperationTarget.ALL_TYPES);
        MenuUtil.setDefaultAction(this.viewer.getContextMenu(), "jazz.open");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)site.getParent(), "com.ibm.team.filesystem.ide.ui.view_snapshots");
        this.setInput(input);
    }

    protected IEclipsePreferences getConfigPrefs() {
        return new ConfigurationScope().getNode(String.valueOf(RepositoryUiPlugin.PLUGIN_ID) + '/' + ((Object)((Object)this)).getClass().getName());
    }

    private static String getNameForInput(AbstractPlaceWrapper input) {
        return NLS.bind((String)Messages.SnapshotListView_8, (Object)input.getWorkspace().getName());
    }

    public static void openSearch(Display display, AbstractPlaceWrapper input) {
        String inputName = SnapshotListView.getNameForInput(input);
        AbstractSearchAction.openSearch(display, ImagePool.WORKSPACE_SEARCH, inputName, (Object)input, SnapshotListView.class);
    }

    public void setInput(Object newInput) {
        AbstractPlaceWrapper wrapper = (AbstractPlaceWrapper)((Object)newInput);
        if (wrapper != null) {
            this.teamRepository = wrapper.getRepository();
            this.query = new StreamSnapshotsQuery(this.teamRepository, wrapper.getWorkspace(), this.getControlSite().getOperationRunner());
            this.viewer.setInput((ISetWithListeners)this.query);
        } else {
            this.viewer.setInput((ISetWithListeners)EmptySetWithListeners.createInstance());
        }
    }

    public boolean canRefresh() {
        return true;
    }

    public void refresh() {
        if (this.query != null) {
            this.query.refresh();
        }
    }

    public IMenuExt getMenuContributions() {
        return this.menu;
    }

    public IMenuExt getToolbarContributions() {
        return this.menu;
    }
}

