/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.queries.FolderChildrenQuery;
import com.ibm.team.filesystem.ui.queries.RootChildrenQuery;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.UnionSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableSetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class PlaceHoldersTreeProvider
extends AbstractRepositoryTreeProvider {
    private AbstractRepositoryTreeProvider provider;
    private IOperationRunner runner;
    private Object rootParent;
    private List<PlaceHolder> placeHolders;
    private boolean folderSelection;
    private Map<Object, WritableSetWithListeners<PlaceHolder>> newAdditions = new HashMap<Object, WritableSetWithListeners<PlaceHolder>>();

    public PlaceHoldersTreeProvider(AbstractRepositoryTreeProvider provider, IOperationRunner runner, boolean folderSelection) {
        this.provider = provider;
        this.runner = runner;
        this.rootParent = null;
        this.placeHolders = new ArrayList<PlaceHolder>();
        this.folderSelection = folderSelection;
    }

    private WritableSetWithListeners<PlaceHolder> get(Object parent) {
        WritableSetWithListeners set = this.newAdditions.get(parent);
        if (set == null) {
            set = new WritableSetWithListeners();
            this.newAdditions.put(parent, (WritableSetWithListeners<PlaceHolder>)set);
        }
        return set;
    }

    private void put(Object parent, PlaceHolder placeHolder) {
        this.get(parent).add((Object)placeHolder);
    }

    public ISetWithListeners getChildren(Object element) {
        if (element instanceof AbstractPlaceWrapper) {
            return this.wrapChildren(element);
        }
        if (element instanceof WorkspaceComponentWrapper || element instanceof FolderItemWrapper) {
            if (this.folderSelection) {
                return this.wrapChildren(element);
            }
            return null;
        }
        if (element instanceof PlaceHolder) {
            if (this.folderSelection) {
                return this.get(element);
            }
            return null;
        }
        return this.getChildren2(element);
    }

    private ISetWithListeners wrapChildren(Object element) {
        ISetWithListeners realChildren = this.getChildren2(element);
        UnionSet result = new UnionSet();
        if (result != null) {
            result.add(realChildren);
        }
        WritableSetWithListeners<PlaceHolder> additions = this.get(element);
        result.add(additions);
        return result;
    }

    private ISetWithListeners getChildren2(Object element) {
        ISetWithListeners children = this.provider.getChildren(element);
        if (children != null) {
            return children;
        }
        if (this.folderSelection) {
            if (element instanceof WorkspaceComponentWrapper) {
                WorkspaceComponentWrapper component = (WorkspaceComponentWrapper)element;
                RootChildrenQuery rootChildrenQuery = new RootChildrenQuery((ItemNamespace)component.getNamespace(), this.runner);
                rootChildrenQuery.setFoldersOnly(true);
                return rootChildrenQuery;
            }
            if (element instanceof FolderItemWrapper) {
                FolderItemWrapper folder = (FolderItemWrapper)((Object)element);
                FolderChildrenQuery folderChildrenQuery = new FolderChildrenQuery(folder, this.runner);
                folderChildrenQuery.setFoldersOnly(true);
                return folderChildrenQuery;
            }
        }
        return null;
    }

    public PlaceHolder addPlaceHolder(Object parent, String name) {
        int depth = 0;
        if (parent instanceof PlaceHolder) {
            PlaceHolder parentPlaceHolder = (PlaceHolder)parent;
            depth = parentPlaceHolder.depth + 1;
        } else {
            this.rootParent = parent;
        }
        int i = this.placeHolders.size() - 1;
        while (i > depth - 1) {
            this.removePlaceHolder(i);
            --i;
        }
        PlaceHolder placeHolder = new PlaceHolder(name, depth, parent);
        this.placeHolders.add(placeHolder);
        this.put(parent, placeHolder);
        return placeHolder;
    }

    public void removePlaceHolder(int i) {
        PlaceHolder parent = null;
        if (i == 0) {
            for (WritableSetWithListeners<PlaceHolder> set : this.newAdditions.values()) {
                set.clear();
            }
        } else {
            parent = this.placeHolders.get(i - 1);
        }
        this.get(parent).clear();
        this.placeHolders.remove(i);
    }

    public Object getRootParent() {
        return this.rootParent;
    }

    public PlaceHolder[] getPlaceHolders() {
        return this.placeHolders.toArray(new PlaceHolder[this.placeHolders.size()]);
    }

    public static class PlaceHolder {
        private String string;
        private int depth;
        private Object parent;

        public PlaceHolder(String string, int depth, Object parent) {
            this.string = string;
            this.depth = depth;
            this.parent = parent;
        }

        public int getDepth() {
            return this.depth;
        }

        public Object getParent() {
            return this.parent;
        }

        public String toString() {
            return this.string;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.depth;
            result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlaceHolder other = (PlaceHolder)obj;
            if (this.depth != other.depth) {
                return false;
            }
            return !(this.string == null ? other.string != null : !this.string.equals(other.string));
        }
    }

    public static class PlaceHolderLabelProvider
    extends BaseLabelProvider {
        public void updateLabel(ViewerLabel label, Object element) {
            PlaceHolder placeHolder = (PlaceHolder)element;
            label.setText(TextProcessor.process((String)NLS.bind((String)Messages.TeamPlaceOverviewPage_toAdd, (Object)placeHolder.toString()), (String)"()"));
            if (placeHolder.getParent() instanceof AbstractPlaceWrapper) {
                label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)ImagePool.COMPONENT_UNLOADED));
            } else {
                label.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
            }
        }
    }
}

