/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.views.CollaborationEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EditCollaborationDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "EditCollaborationDialogSettings";
    private Button allButton;
    private Button selectedButton;
    private CheckboxTableViewer viewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private boolean loading = true;
    private Object[] selection = new Object[0];
    private TeamPlaceWorkingCopy workingCopy;
    private CollaborationEntry collaborationEntry;
    private IOperationRunner runner;
    private volatile Display display;

    public EditCollaborationDialog(Shell shell, TeamPlaceWorkingCopy workingCopy, CollaborationEntry collaborationEntry, IOperationRunner runner) {
        super(shell, Messages.EditCollaborationDialog_title, null, EditCollaborationDialog.getDescription(collaborationEntry), 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.workingCopy = workingCopy;
        this.collaborationEntry = collaborationEntry;
        this.runner = runner;
        this.display = Display.getCurrent();
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    private static String getDescription(CollaborationEntry entry) {
        String name = entry.getName();
        String kind = entry.isStream() ? Messages.EditCollaborationDialog_stream : Messages.EditCollaborationDialog_workspace;
        return NLS.bind((String)Messages.EditCollaborationDialog_chooseComponents, (Object)name, (Object)kind);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        ArrayList<IComponentHandle> componentHandles = new ArrayList<IComponentHandle>();
        if (this.selectedButton.getSelection()) {
            int i = 0;
            while (i < this.selection.length) {
                ComponentWrapper wrapper = (ComponentWrapper)((Object)this.selection[i]);
                componentHandles.add((IComponentHandle)wrapper.getComponent().getItemHandle());
                ++i;
            }
        }
        this.workingCopy.setComponentScopes(this.collaborationEntry, componentHandles);
        super.okPressed();
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createRadioButtons(composite);
        this.createProjectSelectionTable(composite);
        return composite;
    }

    private void createRadioButtons(Composite composite) {
        Composite buttonBar = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonBar);
        SelectionAdapter updateEnablement = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCollaborationDialog.this.updateEnablement();
            }
        };
        this.allButton = new Button(buttonBar, 16);
        this.allButton.setText(Messages.EditCollaborationDialog_flowAll);
        this.allButton.addSelectionListener((SelectionListener)updateEnablement);
        this.selectedButton = new Button(buttonBar, 16);
        this.selectedButton.setText(Messages.EditCollaborationDialog_flowChecked);
        this.selectedButton.addSelectionListener((SelectionListener)updateEnablement);
        GridLayoutFactory.fillDefaults().numColumns(1).generateLayout(buttonBar);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.updateEnablement();
        this.runner.enqueue(Messages.EditCollaborationDialog_loadingComponents, (Operation)new LoadOperation());
        return result;
    }

    private void createProjectSelectionTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(LayoutConstants.getSpacing()).applyTo(composite);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)LabelProviders.create((IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ComponentWrapper c1 = (ComponentWrapper)((Object)e1);
                ComponentWrapper c2 = (ComponentWrapper)((Object)e2);
                return c1.getComponent().getName().compareToIgnoreCase(c2.getComponent().getName());
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EditCollaborationDialog.this.updateSelection();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).minSize(200, 200).applyTo((Control)this.viewer.getTable());
        Composite buttonBar = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonBar);
        this.selectAllButton = new Button(buttonBar, 8);
        this.selectAllButton.setText(Messages.EditCollaborationDialog_selectAll);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCollaborationDialog.this.doSelectAll();
            }
        });
        this.deselectAllButton = new Button(buttonBar, 8);
        this.deselectAllButton.setText(Messages.EditCollaborationDialog_deselectAll);
        this.deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCollaborationDialog.this.doDeselectAll();
            }
        });
        GridLayoutFactory.fillDefaults().spacing(LayoutConstants.getSpacing()).generateLayout(buttonBar);
    }

    private void updateSelection() {
        this.selection = this.viewer.getCheckedElements();
        this.updateEnablement();
    }

    private void doSelectAll() {
        this.viewer.setAllChecked(true);
        this.updateSelection();
    }

    private void doDeselectAll() {
        this.viewer.setAllChecked(false);
        this.updateSelection();
    }

    private void updateEnablement() {
        this.allButton.setEnabled(!this.loading);
        this.selectedButton.setEnabled(!this.loading);
        boolean enableTable = !this.loading && this.selectedButton.getSelection();
        this.viewer.getTable().setEnabled(enableTable);
        this.selectAllButton.setEnabled(enableTable);
        this.deselectAllButton.setEnabled(enableTable);
        boolean enableOK = !this.loading && (this.allButton.getSelection() || this.selection.length > 0);
        this.getButton(0).setEnabled(enableOK);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = UiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    private class LoadOperation
    implements Operation {
        private LoadOperation() {
        }

        public void run(IProgressMonitor monitor, IStatusCollector problems) throws OperationFailedException {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                HashSet<UUID> selectedItemIds = new HashSet<UUID>();
                for (IComponentHandle handle : EditCollaborationDialog.this.collaborationEntry.getComponentScopes()) {
                    selectedItemIds.add(handle.getItemId());
                }
                final ArrayList<ComponentWrapper> componentWrappers = new ArrayList<ComponentWrapper>();
                final ArrayList<ComponentWrapper> selectedWrappers = new ArrayList<ComponentWrapper>();
                ITeamRepository repo = EditCollaborationDialog.this.workingCopy.getRepository();
                if (!EditCollaborationDialog.this.collaborationEntry.isDeleted()) {
                    AbstractPlaceWrapper wrapper = EditCollaborationDialog.this.collaborationEntry.getCollaboration();
                    IWorkspaceConnection connection = wrapper.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                    List componentHandles = connection.getComponents();
                    List componentItems = repo.itemManager().fetchCompleteItems(componentHandles, 0, (IProgressMonitor)progress.newChild(1));
                    for (IComponent component : componentItems) {
                        if (component == null) continue;
                        ComponentWrapper componentWrapper = new ComponentWrapper(repo, component);
                        componentWrappers.add(componentWrapper);
                        if (!selectedItemIds.contains(component.getItemId())) continue;
                        selectedWrappers.add(componentWrapper);
                    }
                }
                SWTUtil.greedyExec((Display)EditCollaborationDialog.this.display, (Control)EditCollaborationDialog.this.viewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EditCollaborationDialog.this.viewer.setInput((Object)componentWrappers);
                        EditCollaborationDialog.this.selection = selectedWrappers.toArray();
                        EditCollaborationDialog.this.viewer.setCheckedElements(EditCollaborationDialog.this.selection);
                        boolean someSelected = EditCollaborationDialog.this.selection.length > 0;
                        EditCollaborationDialog.this.allButton.setSelection(!someSelected);
                        EditCollaborationDialog.this.selectedButton.setSelection(someSelected);
                        EditCollaborationDialog.this.loading = false;
                        EditCollaborationDialog.this.updateEnablement();
                    }
                });
            }
            catch (TeamRepositoryException e) {
                problems.reportProblem(StatusUtil.newStatus((Object)this, (Throwable)e));
            }
        }
    }
}

