/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ui.queries.WorkspaceComponentsQuery;
import com.ibm.team.filesystem.ui.views.AbstractRepositoryTreeProvider;
import com.ibm.team.filesystem.ui.views.IFilteredTreeProvider;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.OwnerSearchQuery;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchCriteria;
import com.ibm.team.internal.filesystem.ui.views.search.workspace.PlaceSearchQuery;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;

public class ContributorPlacesTreeProvider
extends AbstractRepositoryTreeProvider
implements IFilteredTreeProvider {
    private IOperationRunner runner;
    private String filterText;
    private int maxResults = Integer.MAX_VALUE;

    public ContributorPlacesTreeProvider(IOperationRunner runner) {
        this.runner = runner;
    }

    public ISetWithListeners getChildren(Object parent) {
        if (parent instanceof ITeamRepository) {
            ITeamRepository repo = (ITeamRepository)parent;
            PlaceSearchCriteria criteria = new PlaceSearchCriteria(repo, (IConnectedProjectAreaRegistry)ConnectedProjectAreaRegistry.getDefault());
            criteria.setIgnoreCase(true);
            criteria = criteria.withOwnedBy(OwnerSearchQuery.CURRENT_CONTRIBUTOR);
            criteria = criteria.withNameOrPattern(this.filterText);
            criteria.setMaxResults(this.maxResults);
            PlaceSearchQuery query = (PlaceSearchQuery)criteria.getQuery(this.runner);
            query.setSupportDynamicUpdate(true);
            return query;
        }
        if (parent instanceof ContributorPlaceWrapper) {
            ContributorPlaceWrapper wrapper = (ContributorPlaceWrapper)((Object)parent);
            return new WorkspaceComponentsQuery(wrapper.getRepository(), wrapper.getWorkspace(), this.runner);
        }
        return null;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public void setFilterText(String text) {
        this.filterText = text;
    }
}

