/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.ui.views.ComponentEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.events.ILockEvent;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

class ComponentsLabelProvider
extends BaseLabelProvider
implements IListener {
    private Map<WorkspaceComponentWrapper, IBaseline> componentBases = Collections.synchronizedMap(new HashMap());
    private Image loadedImage = this.getImage(ImagePool.COMPONENT);
    private Image unloadedImage = this.getImage(ImagePool.COMPONENT_UNLOADED);
    private Image loadedSelfImage = this.getImage(ImagePool.SELF_COMPONENT);
    private Image unloadedSelfImage = this.getImage(ImagePool.SELF_COMPONENT_UNLOADED);
    private Image loadedPrivateImage = this.getImage(ImagePool.PRIVATE_COMPONENT);
    private Image unloadedPrivateImage = this.getImage(ImagePool.PRIVATE_COMPONENT_UNLOADED);
    private Image loadedTeamImage = this.getImage(ImagePool.TEAM_COMPONENT);
    private Image unloadedTeamImage = this.getImage(ImagePool.TEAM_COMPONENT_UNLOADED);
    private Image loadedProjectImage = this.getImage(ImagePool.PROJECT_COMPONENT);
    private Image unloadedProjectImage = this.getImage(ImagePool.PROJECT_COMPONENT_UNLOADED);
    private Image baselineImage = this.getImage(ImagePool.BASELINE);
    private Image loadedComponentLockByMeImage = this.getImage(ImagePool.LOCKED_BY_ME_WS_EDIT_OVRL);
    private Image loadedComponentLockByOthrImage = this.getImage(ImagePool.LOCKED_BY_OTHER_WS_EDIT_OVRL);
    private Image unloadedComponentLockByMeImage = this.getImage(ImagePool.LOCKED_BY_ME_WS_EDIT_OVRL_UNLOADED);
    private Image unloadedComponentLockByOthrImage = this.getImage(ImagePool.LOCKED_BY_OTHER_WS_EDIT_OVRL_UNLOADED);
    private Set<IWorkspaceConnection> hookedConnections = new HashSet<IWorkspaceConnection>();
    private SimpleTableViewer<ComponentEntry> componentsViewer;
    private IOperationRunner runner;
    protected TeamPlaceWorkingCopy workingCopy;
    private IListener fLockListenerWsEditor = new IListener(){

        public void handleEvents(List events) {
            for (Object object : events) {
                ILockEvent lockEvent;
                if (!(object instanceof ILockEvent) || !(lockEvent = (ILockEvent)object).getEventType().equals("com.ibm.team.scm.LockEvent.ComponentsLocked")) continue;
                SWTUtil.greedyExec((Display)ComponentsLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<ComponentEntry> toUpdate = new ArrayList<ComponentEntry>();
                        for (Object element : (this).ComponentsLabelProvider.this.workingCopy.getComponents()) {
                            if (!(element instanceof ComponentEntry)) continue;
                            ComponentEntry componentEntry = (ComponentEntry)element;
                            if (!lockEvent.getComponentIDs().contains(componentEntry.getComponent().getItem().getItemId())) continue;
                            toUpdate.add(componentEntry);
                        }
                        ComponentsLabelProvider.this.fireChangeEvent(toUpdate);
                    }
                });
            }
        }
    };

    public ComponentsLabelProvider(SimpleTableViewer<ComponentEntry> componentsViewer, IOperationRunner runner, TeamPlaceWorkingCopy workingCopy) {
        this.componentsViewer = componentsViewer;
        this.runner = runner;
        this.workingCopy = workingCopy;
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.addGenericListener((Object)"loadedComponents", (IListener)this);
    }

    private String addBasisDecoration(ComponentEntry entry, WorkspaceComponentWrapper wrapper, String label) {
        IBaseline baseline = this.componentBases.get(wrapper);
        if (baseline == null) {
            this.startRefreshFor(entry, wrapper);
            return label;
        }
        return NLS.bind((String)Messages.TeamPlaceOverviewPage_basis, (Object)label, (Object)BaselineWrapper.getLabel(baseline));
    }

    public void dispose() {
        for (IWorkspaceConnection connection : this.hookedConnections) {
            connection.removeGenericListener((Object)"bases", (IListener)this);
            connection.removeGenericListener((Object)"com.ibm.team.scm.LockEvent.ComponentsLocked", this.fLockListenerWsEditor);
        }
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.removeGenericListener((Object)"loadedComponents", (IListener)this);
        super.dispose();
    }

    public void handleEvents(List events) {
        this.componentBases.clear();
        this.updateAll();
    }

    private void startRefreshFor(ComponentEntry entry, final WorkspaceComponentWrapper wrapper) {
        Table control = this.componentsViewer.getTable();
        final Display display = Display.getCurrent();
        if (entry.getComponent() != null) {
            this.hookListener(wrapper.getWorkspaceConnection());
            this.runner.enqueue(Messages.TeamPlaceOverviewPage_fetchingBasis, new Operation((Control)control, entry){
                private final /* synthetic */ Control val$control;
                private final /* synthetic */ ComponentEntry val$entry;
                {
                    this.val$control = control;
                    this.val$entry = componentEntry;
                }

                public void run(IProgressMonitor reporter, IStatusCollector problems) throws OperationFailedException {
                    try {
                        Object fetched;
                        Object baselineOrigin;
                        ITeamRepository repo;
                        IFetchResult fetchResult;
                        IBaselineHandle baselineHandle = wrapper.getWorkspaceConnection().getComponentInfo((IComponentHandle)wrapper.getComponent()).basis();
                        if (baselineHandle != null && (fetchResult = (repo = (baselineOrigin = baselineHandle.getOrigin()) instanceof ITeamRepository ? (ITeamRepository)baselineOrigin : ComponentsLabelProvider.this.workingCopy.getRepository()).itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(baselineHandle), 0, reporter)).getRetrievedItems().size() == 1 && (fetched = fetchResult.getRetrievedItems().get(0)) instanceof IBaseline) {
                            IBaseline baseline = (IBaseline)fetched;
                            ComponentsLabelProvider.this.componentBases.put(wrapper, baseline);
                            SWTUtil.greedyExec((Display)display, (Control)this.val$control, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ComponentsLabelProvider.this.updateLabel(val$entry);
                                }
                            });
                        }
                    }
                    catch (ComponentNotInWorkspaceException baselineHandle) {
                    }
                    catch (TeamRepositoryException e) {
                        problems.reportProblem(StatusUtil.newStatus(this.getClass(), (Throwable)e));
                    }
                }
            });
        }
    }

    private void hookListener(IWorkspaceConnection connection) {
        if (!this.hookedConnections.contains(connection)) {
            connection.addGenericListener((Object)"bases", (IListener)this);
            connection.addGenericListener((Object)"com.ibm.team.scm.LockEvent.ComponentsLocked", this.fLockListenerWsEditor);
            this.hookedConnections.add(connection);
        }
    }

    public void updateAll() {
        this.componentBases.clear();
        this.fireAllElementsChangedEvent();
    }

    private void updateLabel(ComponentEntry entry) {
        this.fireChangeEvent(Collections.singletonList(entry));
    }

    public void updateLabel(ViewerLabel label, Object element) {
        if (!(element instanceof ComponentEntry)) {
            return;
        }
        ComponentEntry entry = (ComponentEntry)element;
        boolean isLoaded = false;
        boolean componentLockedByme = false;
        boolean isLocked = false;
        ComponentDetails details = entry.getDetails();
        String text = entry.getName();
        if (entry.isDefault() && "".equals(text)) {
            text = this.workingCopy.getPlaceName().equals("") ? Messages.TeamPlaceOverviewPage_defaultComponent : this.workingCopy.getDefaultComponentName();
        }
        if (entry.getSourceBaseline() != null) {
            String baselineLabel = BaselineWrapper.getLabel(entry.getSourceBaseline().getBaseline());
            text = this.workingCopy.isReplacement(WorkspaceUtil.getComponent(entry.getSourceBaseline())) ? NLS.bind((String)Messages.TeamPlaceOverviewPage_toReplaceWithBaseline, (Object)text, (Object)baselineLabel) : (this.workingCopy.isSnapshot() ? NLS.bind((String)Messages.TeamPlaceOverviewPage_basis, (Object)text, (Object)baselineLabel) : NLS.bind((String)Messages.TeamPlaceOverviewPage_toAddFromBaseline, (Object)text, (Object)baselineLabel));
        } else if (entry.getSourceComponent() != null) {
            WorkspaceComponentWrapper source = entry.getSourceComponent();
            text = this.addBasisDecoration(entry, source, text);
            String srcName = source.getWorkspaceConnection().getName();
            text = this.workingCopy.isReplacement(WorkspaceUtil.getComponent(entry.getSourceComponent())) ? NLS.bind((String)Messages.TeamPlaceOverviewPage_toReplaceFrom, (Object)text, (Object)srcName) : NLS.bind((String)Messages.TeamPlaceOverviewPage_toAddFrom, (Object)text, (Object)srcName);
            isLoaded = source.isShared();
        } else if (this.workingCopy.getWorkspaceConnection() != null && entry.getComponent() != null) {
            WorkspaceComponentWrapper wrapper = WorkspaceComponentWrapper.newWrapper(this.workingCopy.getWorkspaceConnection(), entry.getComponent().getComponent());
            isLocked = this.workingCopy.getWorkspaceConnection().isLocked((IComponentHandle)entry.getComponent().getComponent());
            if (this.workingCopy.isStream() && isLocked) {
                componentLockedByme = this.workingCopy.getWorkspaceConnection().isLockedByMe((IComponentHandle)entry.getComponent().getComponent());
                if (details != null && details.getOwner() != null) {
                    text = NLS.bind((String)Messages.TeamPlaceLabelProvider_lockedByMessage, (Object)text, (Object)(componentLockedByme ? Messages.TeamPlaceWrapper_owner_me : this.workingCopy.getWorkspaceConnection().getLockOwnerName((IComponentHandle)entry.getComponent().getComponent())));
                    text = this.addBasisDecoration(entry, wrapper, text);
                    text = NLS.bind((String)Messages.TeamPlaceOverviewPage_basis, (Object)text, (Object)details.getOwnerText());
                }
            } else {
                text = this.addBasisDecoration(entry, wrapper, text);
            }
            isLoaded = wrapper.isShared();
        } else {
            text = NLS.bind((String)Messages.TeamPlaceOverviewPage_toAdd, (Object)text);
        }
        Image image = null;
        if (this.workingCopy.isSnapshot()) {
            image = this.baselineImage;
        } else if (isLocked) {
            image = isLoaded ? (componentLockedByme ? this.loadedComponentLockByMeImage : this.loadedComponentLockByOthrImage) : (componentLockedByme ? this.unloadedComponentLockByMeImage : this.unloadedComponentLockByOthrImage);
        } else {
            Image image2 = image = isLoaded ? this.loadedImage : this.unloadedImage;
            if (details != null && details.getOwner() != null) {
                text = NLS.bind((String)Messages.TeamPlaceOverviewPage_basis, (Object)text, (Object)details.getOwnerText());
                IItem owner = details.getOwner().getItem();
                if (owner instanceof IContributorHandle) {
                    ITeamRepository repo = entry.getRepository();
                    image = owner.sameItemId((IItemHandle)repo.loggedInContributor()) ? (isLoaded ? this.loadedSelfImage : this.unloadedSelfImage) : (isLoaded ? this.loadedPrivateImage : this.unloadedPrivateImage);
                } else if (owner instanceof ITeamAreaHandle) {
                    image = isLoaded ? this.loadedTeamImage : this.unloadedTeamImage;
                } else if (owner instanceof IProjectAreaHandle) {
                    image = isLoaded ? this.loadedProjectImage : this.unloadedProjectImage;
                }
            }
        }
        label.setText(TextProcessor.process((String)text, (String)"():"));
        label.setImage(image);
    }
}

