/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import org.eclipse.core.runtime.Assert;

public class ComponentEntry {
    private String name = "";
    private boolean isDefault;
    private ComponentWrapper component;
    private BaselineWrapper sourceBaseline;
    private WorkspaceComponentWrapper sourceComponent;
    private ComponentDetails details;
    private ITeamRepository repo;
    private IWorkspaceConnection workspaceConnection;

    public ComponentEntry(String name, boolean isDefault, ITeamRepository repo, IWorkspaceConnection workspaceConnection) {
        this.setName(name);
        this.isDefault = isDefault;
        this.workspaceConnection = workspaceConnection;
        this.repo = repo;
    }

    public ComponentEntry(ComponentWrapper wrapper, ITeamRepository repo, IWorkspaceConnection workspaceConnection) {
        this(wrapper.getComponent().getName(), false, repo, workspaceConnection);
        this.component = wrapper;
    }

    public ComponentEntry(WorkspaceComponentWrapper component, ITeamRepository repo, IWorkspaceConnection workspaceConnection) {
        this(component.getComponent().getName(), false, repo, workspaceConnection);
        this.sourceComponent = component;
    }

    public ComponentEntry(BaselineWrapper baseline, ITeamRepository repo, IWorkspaceConnection workspaceConnection) {
        this(baseline.getComponent().getName(), false, repo, workspaceConnection);
        this.sourceBaseline = baseline;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.isNotNull((Object)name);
        this.name = name;
    }

    public ComponentDetails getDetails() {
        return this.details;
    }

    public void setDetails(ComponentDetails details) {
        Assert.isNotNull((Object)details);
        this.details = details;
    }

    public ComponentWrapper getComponent() {
        return this.component;
    }

    public void setComponent(ComponentWrapper component) {
        this.component = component;
    }

    public BaselineWrapper getSourceBaseline() {
        return this.sourceBaseline;
    }

    public WorkspaceComponentWrapper getSourceComponent() {
        return this.sourceComponent;
    }

    public ItemNamespace getNamespace() {
        if (this.sourceBaseline != null) {
            return this.sourceBaseline.getNamespace();
        }
        if (this.sourceComponent != null) {
            return this.sourceComponent.getNamespace();
        }
        if (this.component != null && this.workspaceConnection != null) {
            return WorkspaceNamespace.create((IWorkspaceConnection)this.workspaceConnection, (IComponentHandle)this.component.getComponent());
        }
        return null;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isEditable() {
        return this.sourceBaseline == null && this.sourceComponent == null;
    }

    public synchronized void onSaved() {
        this.sourceBaseline = null;
        this.sourceComponent = null;
    }

    public boolean matches(IComponent toMatch) {
        IComponent component = this.getBackingComponentItem();
        return component != null && component.sameItemId((IItemHandle)toMatch);
    }

    public IComponent getBackingComponentItem() {
        if (this.getComponent() != null) {
            return this.getComponent().getComponent();
        }
        if (this.getSourceBaseline() != null) {
            return this.getSourceBaseline().getComponent();
        }
        if (this.getSourceComponent() != null) {
            return this.getSourceComponent().getComponent();
        }
        return null;
    }

    public ComponentWrapper getBackingComponent() {
        IComponent item = this.getBackingComponentItem();
        if (item == null) {
            return null;
        }
        return new ComponentWrapper(this.repo, item);
    }

    protected ITeamRepository getRepository() {
        return this.repo;
    }
}

