/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ui.views.CollaborationEntry;
import com.ibm.team.filesystem.ui.views.TeamPlaceWorkingCopy;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

class CollaborationsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private TableViewer fTableViewer;
    private ResourceManager fResources;
    private final int NAME_COLUMN = 0;
    private final int FLOW_DIRECTION_COLUMN = 1;
    private final int CURRENT_FLOW_COLUMN = 2;
    private final int DEFAULT_FLOW_COLUMN = 3;

    public CollaborationsLabelProvider(TableViewer tableViewer) {
        this.fTableViewer = tableViewer;
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)tableViewer.getTable());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof CollaborationEntry)) {
            return null;
        }
        CollaborationEntry entry = (CollaborationEntry)element;
        Image image = null;
        switch (columnIndex) {
            case 0: {
                ImageDescriptor imageDesc = entry.isStream() ? ImagePool.STREAM : ImagePool.WORKSPACE;
                image = this.getImage(imageDesc);
            }
        }
        return image;
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        Image image = null;
        if (this.fResources != null) {
            image = (Image)this.fResources.get((DeviceResourceDescriptor)imageDescriptor);
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof CollaborationEntry)) {
            return null;
        }
        TeamPlaceWorkingCopy workingCopy = (TeamPlaceWorkingCopy)((Object)this.fTableViewer.getInput());
        CollaborationEntry entry = (CollaborationEntry)element;
        String text = null;
        switch (columnIndex) {
            case 0: {
                text = entry.getName();
                if (entry.getComponentScopes().isEmpty()) break;
                text = NLS.bind((String)Messages.TeamPlaceOverviewPage_scopedFlow, (Object)text);
                break;
            }
            case 1: {
                if ((entry.getFlowDirection() & 0xF) == 3) {
                    text = NLS.bind((String)Messages.TeamPlaceOverviewPage_incomingAndOutgoingFlow, (Object)Messages.TeamPlaceOverviewPage_incomingFlow, (Object)Messages.TeamPlaceOverviewPage_outgoingFlow);
                    break;
                }
                if ((entry.getFlowDirection() & 0xF) == 1) {
                    text = Messages.TeamPlaceOverviewPage_incomingFlow;
                }
                if ((entry.getFlowDirection() & 0xF) != 2) break;
                text = Messages.TeamPlaceOverviewPage_outgoingFlow;
                break;
            }
            case 2: {
                if (entry == workingCopy.getCurrentIncomingCollaboration() && entry == workingCopy.getCurrentOutgoingCollaboration()) {
                    text = NLS.bind((String)Messages.TeamPlaceOverviewPage_incomingAndOutgoingFlow, (Object)Messages.TeamPlaceOverviewPage_incomingFlow, (Object)Messages.TeamPlaceOverviewPage_outgoingFlow);
                    break;
                }
                if (entry == workingCopy.getCurrentIncomingCollaboration()) {
                    text = Messages.TeamPlaceOverviewPage_incomingFlow;
                }
                if (entry != workingCopy.getCurrentOutgoingCollaboration()) break;
                text = Messages.TeamPlaceOverviewPage_outgoingFlow;
                break;
            }
            case 3: {
                if (entry == workingCopy.getDefaultIncomingCollaboration() && entry == workingCopy.getDefaultOutgoingCollaboration()) {
                    text = NLS.bind((String)Messages.TeamPlaceOverviewPage_incomingAndOutgoingFlow, (Object)Messages.TeamPlaceOverviewPage_incomingFlow, (Object)Messages.TeamPlaceOverviewPage_outgoingFlow);
                    break;
                }
                if (entry == workingCopy.getDefaultIncomingCollaboration()) {
                    text = Messages.TeamPlaceOverviewPage_incomingFlow;
                }
                if (entry != workingCopy.getDefaultOutgoingCollaboration()) break;
                text = Messages.TeamPlaceOverviewPage_outgoingFlow;
            }
        }
        return text;
    }

    public void dispose() {
        if (this.fResources != null) {
            this.fResources.dispose();
            this.fResources = null;
        }
        if (this.fTableViewer != null) {
            this.fTableViewer = null;
        }
        super.dispose();
    }
}

