/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.views;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public class CollaborationEntry {
    private final IWorkspaceHandle handle;
    private final AbstractPlaceWrapper collaboration;
    private int flowDirection;
    private Collection<IComponentHandle> componentScopes;

    public CollaborationEntry(AbstractPlaceWrapper collaboration) {
        this((IWorkspaceHandle)collaboration.getWorkspace().getItemHandle(), collaboration, Collections.emptyList());
    }

    public CollaborationEntry(IWorkspaceHandle handle, AbstractPlaceWrapper collaboration, Collection<IComponentHandle> componentScopes) {
        Assert.isNotNull((Object)handle);
        Assert.isNotNull(componentScopes);
        this.handle = handle;
        this.collaboration = collaboration;
        this.componentScopes = componentScopes;
        this.flowDirection = 3;
    }

    public CollaborationEntry(IWorkspaceHandle handle, AbstractPlaceWrapper collaboration, Collection<IComponentHandle> componentScopes, int flowFlags) {
        Assert.isNotNull((Object)handle);
        Assert.isNotNull(componentScopes);
        this.handle = handle;
        this.collaboration = collaboration;
        this.componentScopes = componentScopes;
        this.flowDirection = flowFlags;
    }

    public IWorkspaceHandle getHandle() {
        return this.handle;
    }

    public AbstractPlaceWrapper getCollaboration() {
        return this.collaboration;
    }

    public Collection<IComponentHandle> getComponentScopes() {
        return this.componentScopes;
    }

    public int getFlowDirection() {
        return this.flowDirection;
    }

    public void setComponentScopes(List<IComponentHandle> componentHandles) {
        this.componentScopes = componentHandles;
    }

    public void setFlowDirection(int flowDirection) {
        this.flowDirection = flowDirection;
    }

    public String getName() {
        return this.isDeleted() ? NLS.bind((String)Messages.TeamPlaceWorkingCopy_missingFlow, (Object)this.getHandle().getItemId().getUuidValue()) : this.getCollaboration().getWorkspace().getName();
    }

    public boolean isDeleted() {
        return this.getCollaboration() == null;
    }

    public boolean isStream() {
        return this.isDeleted() ? false : this.getCollaboration().getWorkspace().isStream();
    }
}

