/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class WorkspaceFlowTargetQuery
extends RepositoryQuery<AbstractPlaceWrapper> {
    private IWorkspace workspace;
    private IWorkspaceHandle workspaceHandle;
    private IWorkspaceConnection connection;
    private final List<UUID> workspaceToShow = new ArrayList<UUID>();
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            WorkspaceFlowTargetQuery.this.update();
        }
    };

    public WorkspaceFlowTargetQuery(ITeamRepository repo, IWorkspaceHandle workspace, IOperationRunner runner) {
        super(repo, runner);
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        this.workspaceHandle = workspace;
    }

    public WorkspaceFlowTargetQuery(ITeamRepository repo, IWorkspaceHandle workspace, Collection<IWorkspaceHandle> workspaceToShow, IOperationRunner runner) {
        super(repo, runner);
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace must not be null");
        }
        this.workspaceHandle = workspace;
        for (IWorkspaceHandle q : workspaceToShow) {
            this.workspaceToShow.add(q.getItemId());
        }
    }

    protected void attachListeners() {
    }

    public List<AbstractPlaceWrapper> fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.workspace == null) {
                this.workspace = (IWorkspace)repo.itemManager().fetchCompleteItem((IItemHandle)this.workspaceHandle, 0, (IProgressMonitor)progress.newChild(25));
            }
            if (this.connection == null) {
                this.connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)this.workspace, (IProgressMonitor)progress.newChild(65));
                this.connection.addGenericListener((Object)"flow table", this.listener);
            }
            if (WorkspaceUtil.isDeleted(this.connection)) {
                return Collections.EMPTY_LIST;
            }
            List flows = this.connection.getFlowTable().deliverTargets();
            ArrayList<IWorkspaceHandle> flowWorkspaces = new ArrayList<IWorkspaceHandle>();
            for (IFlowEntry flowEntry : flows) {
                IFlowNodeHandle flowNode = flowEntry.getFlowNode();
                if (!(flowNode instanceof IWorkspaceHandle) || !this.workspaceToShow.contains(flowNode.getItemId()) && !this.workspaceToShow.isEmpty()) continue;
                flowWorkspaces.add((IWorkspaceHandle)flowNode);
            }
            Collection flowFullWorkspaces = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)ItemLists.handlesToIds(flowWorkspaces), (IProgressMonitor)progress.newChild(25)).values();
            ArrayList<AbstractPlaceWrapper> wrappers = new ArrayList<AbstractPlaceWrapper>(flowFullWorkspaces.size());
            for (IWorkspace workspace : flowFullWorkspaces) {
                wrappers.add(AbstractPlaceWrapper.newWrapper(workspace));
            }
            return wrappers;
        }
        catch (ItemNotFoundException e) {
            return Collections.EMPTY_LIST;
        }
    }

    protected void detachListeners() {
        if (this.connection != null) {
            this.connection.removeGenericListener((Object)"flow table", this.listener);
        }
    }

    public String getName() {
        return Messages.WorkspaceFlowTargetQuery_2;
    }
}

