/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class TeamAreasQuery
extends RepositoryQuery<ITeamArea> {
    private final ItemId<IProjectArea> projectArea;
    private final ITeamArea parent;
    private boolean includeArchived = true;
    private final ISharedItemChangeListener listener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            TeamAreasQuery.this.update();
        }
    };
    private IProjectArea fetchedProjectArea;

    public TeamAreasQuery(ITeamRepository repository, ItemId<IProjectArea> projectArea, ITeamArea parent, IOperationRunner runner) {
        super(repository, runner);
        this.projectArea = projectArea;
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowArchived(boolean showArchived) {
        TeamAreasQuery teamAreasQuery = this;
        synchronized (teamAreasQuery) {
            if (this.includeArchived == showArchived) {
                return;
            }
            this.includeArchived = showArchived;
        }
        this.update();
    }

    protected void attachListeners() {
    }

    protected synchronized void detachListeners() {
        if (this.fetchedProjectArea != null) {
            this.getRepository().itemManager().removeItemChangeListener((IItem)this.fetchedProjectArea, this.listener);
            this.fetchedProjectArea = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ITeamArea> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectArea pa;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        TeamAreasQuery teamAreasQuery = this;
        synchronized (teamAreasQuery) {
            pa = this.fetchedProjectArea;
            if (pa == null) {
                pa = (IProjectArea)RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), this.projectArea, (boolean)needsRefresh, (IProgressMonitor)progress.newChild(30));
                this.getRepository().itemManager().addItemChangeListener((IItem)pa, this.listener);
                progress.setWorkRemaining(100);
                this.fetchedProjectArea = pa;
            }
        }
        ITeamAreaHierarchy hierarchy = pa.getTeamAreaHierarchy();
        Set areaHandles = this.parent == null ? hierarchy.getRoots() : hierarchy.getChildren((ITeamAreaHandle)this.parent);
        List list = ItemLists.handlesToIds((Collection)areaHandles);
        ArrayList<ITeamArea> result = new ArrayList<ITeamArea>();
        Collection fetchedAreas = RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), (Collection)list, (boolean)needsRefresh, (IProgressMonitor)monitor).values();
        for (ITeamArea next : fetchedAreas) {
            if (!this.includeArchived && next.isArchived()) continue;
            result.add(next);
        }
        return result;
    }

    public String getName() {
        if (this.parent == null) {
            return Messages.TeamAreasQuery_0;
        }
        return NLS.bind((String)Messages.TeamAreasQuery_1, (Object)this.parent.getName());
    }
}

