/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.item.ItemListenerUtil;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.client.workingcopies.IProcessAreaWorkingCopy;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class TeamAreaContributorsQuery
extends RepositoryQuery {
    private IProcessArea teamArea;
    private ItemId<IProcessArea> teamAreaId;
    private boolean listenerAttached = false;
    private ISharedItemChangeListener listener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            TeamAreaContributorsQuery.this.update();
        }
    };

    public TeamAreaContributorsQuery(ITeamRepository repo, ItemId<IProcessArea> teamArea, IOperationRunner runner) {
        super(repo, runner);
        this.teamAreaId = teamArea;
        this.teamArea = null;
    }

    public TeamAreaContributorsQuery(ITeamRepository repo, IProcessArea teamArea, IOperationRunner runner) {
        this(repo, (ItemId<IProcessArea>)ItemId.forItem((IItem)teamArea), runner);
        this.teamArea = teamArea;
    }

    protected void doFlushCache(IProgressMonitor monitor) throws TeamRepositoryException {
        Repositories.refresh(this.getRepository(), this.teamAreaId, monitor);
    }

    public String getName() {
        return Messages.TeamAreaContributorsQuery_0;
    }

    protected void attachListeners() {
        this.doAttachListener();
    }

    private void doAttachListener() {
        if (this.teamArea != null && !this.listenerAttached) {
            this.listenerAttached = true;
            ItemListenerUtil.addListener((IItem)this.teamArea, this.listener);
        }
    }

    protected void detachListeners() {
        if (this.teamArea != null) {
            ItemListenerUtil.removeListener((IItem)this.teamArea, this.listener);
            this.listenerAttached = false;
        }
    }

    public List fetchResult(boolean shouldRefresh, IProgressMonitor mon) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        IItemManager itemManager = repo.itemManager();
        this.teamArea = (IProcessArea)RepoFetcher.fetchCurrent((ITeamRepository)repo, this.teamAreaId, null);
        this.doAttachListener();
        IProcessItemService processItemService = (IProcessItemService)repo.getClientLibrary(IProcessItemService.class);
        IProcessAreaWorkingCopy teamAreaWorkingCopy = (IProcessAreaWorkingCopy)processItemService.getWorkingCopyManager().createPrivateWorkingCopy((IProcessItem)this.teamArea);
        List members = itemManager.fetchCompleteItems(teamAreaWorkingCopy.getMembers(), 0, mon);
        ArrayList<ContributorWrapper> contributorWrappers = new ArrayList<ContributorWrapper>();
        int i = 0;
        while (i < members.size()) {
            contributorWrappers.add(new ContributorWrapper(repo, (IContributor)members.get(i)));
            ++i;
        }
        return contributorWrappers;
    }
}

