/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.wrapper.SnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class StreamSnapshotsQuery
extends RepositoryQuery {
    private static final int MAX_TO_SHOW = 2048;
    private IWorkspace workspace;
    private String namePattern = "";
    private List<? extends IBaselineSetHandle> toIgnore;
    private IWorkspaceConnection connection;
    private IListener snapshotChangeListener = new IListener(){

        public void handleEvents(List events) {
            StreamSnapshotsQuery.this.update();
        }
    };
    private IListener knownWorkspaceConnectionListener = new IListener(){

        public void handleEvents(List events) {
            if (StreamSnapshotsQuery.this.connection == null) {
                StreamSnapshotsQuery.this.connection = SCMPlatform.getWorkspaceManager((ITeamRepository)StreamSnapshotsQuery.this.getRepository()).getKnownWorkspaceConnection((IItemHandle)StreamSnapshotsQuery.this.workspace);
            }
            if (StreamSnapshotsQuery.this.connection != null) {
                StreamSnapshotsQuery.this.connection.addGenericListener((Object)"baseline sets", StreamSnapshotsQuery.this.snapshotChangeListener);
                SCMPlatform.getWorkspaceManager((ITeamRepository)StreamSnapshotsQuery.this.getRepository()).removeGenericListener((Object)"workspaces", StreamSnapshotsQuery.this.knownWorkspaceConnectionListener);
                StreamSnapshotsQuery.this.knownWorkspaceConnectionListener = null;
            }
        }
    };
    private ISharedItemChangeListener itemChangeListener = new ISharedItemChangeListener(){
        private IItemHandle lastStateUpdated = null;

        public void itemsChanged(List changes) {
            boolean refresh = false;
            for (Object o : changes) {
                IItem afterState;
                ISharedItemChangeEvent event;
                if (!(o instanceof ISharedItemChangeEvent) || !this.hasOwnerChange((IBaselineSet)(event = (ISharedItemChangeEvent)o).getBeforeState(), (IBaselineSet)event.getAfterState()) || ((afterState = event.getAfterState()) == null || afterState.getStateHandle().sameStateId(this.lastStateUpdated)) && (afterState != null || this.lastStateUpdated == null)) continue;
                this.lastStateUpdated = afterState == null ? null : afterState.getStateHandle();
                refresh = true;
                break;
            }
            if (refresh) {
                StreamSnapshotsQuery.this.update();
            }
        }

        private boolean hasOwnerChange(IBaselineSet beforeState, IBaselineSet afterState) {
            return beforeState != null && afterState != null && StreamSnapshotsQuery.this.workspace.sameItemId((IItemHandle)beforeState.getOwner()) && !StreamSnapshotsQuery.this.workspace.sameItemId((IItemHandle)afterState.getOwner());
        }
    };

    public StreamSnapshotsQuery(ITeamRepository repo, IWorkspace workspace, IOperationRunner runner) {
        this(repo, workspace, null, null, runner);
    }

    public StreamSnapshotsQuery(ITeamRepository repo, IWorkspace workspace, List<? extends IBaselineSetHandle> toIgnore, IOperationRunner runner) {
        this(repo, workspace, null, null, runner);
    }

    public StreamSnapshotsQuery(ITeamRepository repo, IWorkspace workspace, String namePattern, List<? extends IBaselineSetHandle> toIgnore, IOperationRunner runner) {
        super(repo, runner);
        this.workspace = workspace;
        this.toIgnore = toIgnore;
        this.namePattern = namePattern;
    }

    public String getName() {
        return Messages.StreamSnapshotsQuery_0;
    }

    public List fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (repo == null || this.workspace == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.connection != null && WorkspaceUtil.isDeleted(this.connection)) {
            return Collections.EMPTY_LIST;
        }
        List<SnapshotWrapper> snapshots = WorkspaceUtil.getBaselineSetWrappers(repo, this.workspace, 2048, this.namePattern, (IProgressMonitor)progress.newChild(80));
        if (this.toIgnore != null && !this.toIgnore.isEmpty()) {
            ArrayList<SnapshotWrapper> result = new ArrayList<SnapshotWrapper>();
            for (SnapshotWrapper snapshot : snapshots) {
                boolean ignored = false;
                for (IBaselineSetHandle iBaselineSetHandle : this.toIgnore) {
                    if (!snapshot.getSnapshot().sameItemId((IItemHandle)iBaselineSetHandle)) continue;
                    ignored = true;
                    break;
                }
                if (ignored) continue;
                result.add(snapshot);
            }
            snapshots = result;
        }
        return snapshots;
    }

    protected void attachListeners() {
        SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).addGenericListener((Object)"workspaces", this.knownWorkspaceConnectionListener);
        this.connection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getKnownWorkspaceConnection((IItemHandle)this.workspace);
        if (this.connection != null) {
            this.connection.addGenericListener((Object)"baseline sets", this.snapshotChangeListener);
            SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"workspaces", this.knownWorkspaceConnectionListener);
            this.knownWorkspaceConnectionListener = null;
        }
        this.getRepository().itemManager().addItemChangeListener(IBaselineSet.ITEM_TYPE, this.itemChangeListener);
    }

    protected void detachListeners() {
        if (this.knownWorkspaceConnectionListener != null) {
            SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).removeGenericListener((Object)"workspaces", this.knownWorkspaceConnectionListener);
            this.knownWorkspaceConnectionListener = null;
        }
        if (this.connection != null) {
            this.connection.removeGenericListener((Object)"baseline sets", this.snapshotChangeListener);
            this.connection = null;
        }
        this.getRepository().itemManager().removeItemChangeListener(IBaselineSet.ITEM_TYPE, this.itemChangeListener);
    }
}

