/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.repository.rcp.ui.internal.utils.IRunnableWithSelection;
import com.ibm.team.repository.rcp.ui.internal.viewers.ButtonBar;
import com.ibm.team.repository.rcp.ui.internal.viewers.ControlUpdater;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertColumn;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SimpleTableViewer;
import com.ibm.team.repository.rcp.ui.internal.viewers.WritableValue;
import com.ibm.team.repository.rcp.ui.parts.AbstractPart;
import com.ibm.team.repository.rcp.ui.parts.IBusyHandler;
import com.ibm.team.repository.rcp.ui.parts.IControlSite;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class SetWithListenersPart
extends AbstractPart
implements IRunnableWithSelection {
    private WritableValue currentSelection = new WritableValue((Object)Collections.EMPTY_LIST);
    private IPartResult result;
    private ISelectionProvider selectionProvider;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            SetWithListenersPart.this.handleSelectionChanged(event.getSelection());
        }
    };

    public SetWithListenersPart(IControlSite site, ISetWithListeners nestedInput, IPartResult outerResult, String titleMsg, String msg, int flags) {
        super(site, (Object)outerResult);
        Composite parent = site.getParent();
        this.result = outerResult;
        if (msg != null) {
            Label msgLabel = new Label(parent, 0);
            msgLabel.setText(msg);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)msgLabel);
        }
        SimpleTableViewer viewer = new SimpleTableViewer(site.getParent(), flags | 0x800, null, null).setProgressService((IBusyHandler)site);
        viewer.getTable().setLinesVisible(false);
        new ConvertColumn(viewer, "", -1, new IConversion(){

            public Object createAdapter(Object source) {
                return source;
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 400).applyTo((Control)viewer.getTable());
        viewer.getSelectionProvider().addSelectionChangedListener(this.listener);
        viewer.getTable().setHeaderVisible(false);
        viewer.setInput(nestedInput);
        viewer.setDoubleClickHandler((IRunnableWithSelection)this);
        site.setSelectionProvider(viewer.getSelectionProvider());
        ButtonBar buttons = new ButtonBar(parent, MessageDialogFactory.getChoicesForType((int)5), new IPartResult(){

            public void setResult(Object _result) {
                if (_result == MessageDialogFactory.OKAY.getValue()) {
                    SetWithListenersPart.this.doOkay();
                } else if (_result == MessageDialogFactory.CANCEL.getValue()) {
                    SetWithListenersPart.this.doCancel();
                }
            }
        });
        new ControlUpdater(){

            protected void updateControl(Control theControl) {
                List sel = (List)SetWithListenersPart.this.currentSelection.getValue();
                theControl.setEnabled(!sel.isEmpty());
            }
        }.setControl((Control)buttons.getButton(MessageDialogFactory.OKAY.getValue()));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo(buttons.getControl());
        parent.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27) {
                    SetWithListenersPart.this.doCancel();
                }
            }
        });
        site.setDefaultButton(buttons.getButton(MessageDialogFactory.OKAY.getValue()));
        site.getNameable().setName(titleMsg);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    protected void handleSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.currentSelection.setValue((Object)ss.toList());
        }
    }

    protected void doSetSelectionProvider(ISelectionProvider selectionProvider2) {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(this.listener);
        }
        this.selectionProvider = selectionProvider2;
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.listener);
            this.handleSelectionChanged(this.selectionProvider.getSelection());
        } else {
            this.handleSelectionChanged((ISelection)StructuredSelection.EMPTY);
        }
    }

    private void doOkay() {
        this.result.setResult(this.currentSelection.getValue());
        this.getControlSite().close();
    }

    private void doCancel() {
        this.result.setResult((Object)Collections.EMPTY_LIST);
        this.getControlSite().close();
    }

    public void run(Object selectedObject, Shell targetShell) {
        this.doOkay();
    }
}

