/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.wrapper.ContributorWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.RepositoryUtils;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class RepositoryContributorsQuery
extends RepositoryQuery {
    private ISharedItemChangeListener listener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                if (event.getBeforeState() != null && event.getAfterState() != null) continue;
                RepositoryContributorsQuery.this.update();
                return;
            }
        }
    };

    public RepositoryContributorsQuery(ITeamRepository handle, IOperationRunner runner) {
        super(handle, runner);
    }

    public String getName() {
        return NLS.bind((String)Messages.RepositoryContributorsQuery_0, (Object)RepositoryUtils.getLabel(this.getRepository()));
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IContributor.ITEM_TYPE, this.listener);
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IContributor.ITEM_TYPE, this.listener);
    }

    public List fetchResult(boolean shouldRefresh, IProgressMonitor mon) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        List contributors = this.getRepository().contributorManager().fetchAllContributors(mon);
        ArrayList<ContributorWrapper> contributorWrappers = new ArrayList<ContributorWrapper>();
        int i = 0;
        while (i < contributors.size()) {
            contributorWrappers.add(new ContributorWrapper(repo, (IContributor)contributors.get(i)));
            ++i;
        }
        return contributorWrappers;
    }
}

