/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MyTeamAreasQuery
extends RepositoryQuery<ITeamArea> {
    public MyTeamAreasQuery(ITeamRepository repository, IOperationRunner runner) {
        super(repository, runner);
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    protected List<ITeamArea> fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList result = NewCollection.arrayList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        if (registry == null) {
            StatusUtil.log((Object)((Object)this), (int)2, (String)"Team areas could not be fetched. This is because ConnectedProjectAreaRegistry.getDefault() is null, which can happen if Eclipse is shutting down.");
        } else {
            List connectedProjectAreas = registry.getConnectedProjectAreas(this.getRepository());
            HashSet<ITeamArea> teamAreasToAdd = new HashSet<ITeamArea>();
            progress.setWorkRemaining(connectedProjectAreas.size());
            for (IProjectAreaHandle projectAreaHandle : connectedProjectAreas) {
                ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
                if (teamRepository != this.getRepository()) continue;
                IProcessItemService service = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
                IContributor user = teamRepository.loggedInContributor();
                if (user == null) continue;
                List teamAreas = service.findTeamAreas(user, projectAreaHandle, IProcessClientService.ALL_PROPERTIES, (IProgressMonitor)progress.newChild(1));
                for (ITeamArea teamArea : teamAreas) {
                    if (teamArea.isArchived()) continue;
                    teamAreasToAdd.add(teamArea);
                }
            }
            result.addAll(teamAreasToAdd);
        }
        progress.setWorkRemaining(0);
        return result;
    }

    public String getName() {
        return Messages.MyTeamAreasQuery_0;
    }
}

