/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.ui.changes.actions.OpenTeamPlaceAction;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContextWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.Query;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class LoadedPlacesQuery
extends Query<ContextWrapper> {
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            LoadedPlacesQuery.this.update();
        }
    };
    private IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
    private ITeamRepository repository;
    private boolean includeWorkspaces;
    private boolean includeCollaborations;

    public LoadedPlacesQuery(IOperationRunner runner, boolean includeWorkspaces, boolean includeCollaborations, ITeamRepository repository) {
        super(runner);
        this.includeCollaborations = includeCollaborations;
        this.includeWorkspaces = includeWorkspaces;
        this.repository = repository;
    }

    public void setRepository(ITeamRepository repository) {
        if (this.repository == repository) {
            return;
        }
        this.repository = repository;
        this.update();
    }

    public List<ContextWrapper> computeResult(IProgressMonitor monitor) throws InvocationTargetException {
        IComponentSyncContext[] contexts = this.model.getComponentSyncContexts();
        HashMap result = NewCollection.hashMap();
        int idx = 0;
        while (idx < contexts.length) {
            IComponentSyncContext next = contexts[idx];
            if (this.repository == null || Repositories.getRepository(next) == this.repository) {
                List<ContextWrapper> wrappers;
                ContextWrapper nextWrapper;
                if (this.includeWorkspaces && (nextWrapper = OpenTeamPlaceAction.createAbstractLocalWrapper(next)) != null && (this.repository == null || nextWrapper.getRepository().equals(this.repository))) {
                    result.put(nextWrapper.getItem().getItemId(), nextWrapper);
                }
                if (this.includeCollaborations && (wrappers = OpenTeamPlaceAction.createAbstractRemoteWrapper(next)) != null && !wrappers.isEmpty()) {
                    for (ContextWrapper nextWrapper2 : wrappers) {
                        IWorkspace workspace;
                        AbstractPlaceWrapper placeWrapper;
                        IItem item;
                        if (this.repository != null && !nextWrapper2.getRepository().equals(this.repository)) continue;
                        boolean add = true;
                        if (!this.includeWorkspaces && nextWrapper2 instanceof AbstractPlaceWrapper && (item = (placeWrapper = (AbstractPlaceWrapper)nextWrapper2).getItem()) instanceof IWorkspace && !(workspace = (IWorkspace)item).isStream()) {
                            add = false;
                        }
                        if (!add) continue;
                        result.put(nextWrapper2.getItem().getItemId(), nextWrapper2);
                    }
                }
            }
            ++idx;
        }
        return new ArrayList<ContextWrapper>(result.values());
    }

    public String getName() {
        return Messages.LoadedPlacesQuery_0;
    }

    protected void allocate() {
        this.model.addGenericListener(this.listener);
        super.allocate();
    }

    protected void deallocate() {
        this.model.removeGenericListener(this.listener);
        super.deallocate();
    }
}

