/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.ui.item.Repositories;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.PendingChangesUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.Query;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class LoadedComponentsQuery
extends Query<ComponentWrapper> {
    private IListener listener = new IListener(){

        public void handleEvents(List events) {
            LoadedComponentsQuery.this.update();
        }
    };
    private IComponentSyncModel model = FileSystemResourcesPlugin.getComponentSyncModel();
    private ITeamRepository repository;

    public LoadedComponentsQuery(IOperationRunner runner) {
        super(runner);
    }

    public LoadedComponentsQuery(IOperationRunner runner, ITeamRepository repository) {
        super(runner);
        this.repository = repository;
    }

    public void setRepository(ITeamRepository repository) {
        if (this.repository == repository) {
            return;
        }
        this.repository = repository;
        this.update();
    }

    public List<ComponentWrapper> computeResult(IProgressMonitor monitor) throws InvocationTargetException {
        IComponentSyncContext[] contexts = this.model.getComponentSyncContexts();
        ArrayList result = NewCollection.arrayList();
        int idx = 0;
        while (idx < contexts.length) {
            IComponentSyncContext next = contexts[idx];
            if ((this.repository == null || Repositories.getRepository(next) == this.repository) && PendingChangesUtil.isLoaded(next)) {
                result.add(new ComponentWrapper(next.localTeamRepository(), next.getComponent()));
            }
            ++idx;
        }
        return result;
    }

    public String getName() {
        return Messages.LoadedComponentsQuery_0;
    }

    protected void allocate() {
        this.model.addGenericListener(this.listener);
        super.allocate();
    }

    protected void deallocate() {
        this.model.removeGenericListener(this.listener);
        super.deallocate();
    }
}

