/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.rcp.ui.internal.viewers.CachingSet;
import java.util.HashSet;
import java.util.Set;

public class KnownTeamRepositoryQuery
extends CachingSet<ITeamRepository> {
    private ITeamRepositoryService.IRepositoryServiceListener listener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repositiory) {
            KnownTeamRepositoryQuery.this.update();
        }

        public void removedRepository(ITeamRepository repository) {
            KnownTeamRepositoryQuery.this.update();
        }
    };

    public KnownTeamRepositoryQuery() {
        this.setContents(this.getElements());
    }

    protected void update() {
        this.asyncSetContents(this.getElements());
    }

    public String getName() {
        return Messages.KnownTeamRepositoryQuery_0;
    }

    protected void deallocate() {
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.listener);
        super.deallocate();
    }

    protected void allocate() {
        this.setContents(this.getElements());
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.listener);
        super.allocate();
    }

    public Set<ITeamRepository> getElements() {
        ITeamRepository[] repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        HashSet<ITeamRepository> result = new HashSet<ITeamRepository>();
        int i = 0;
        while (i < repositories.length) {
            ITeamRepository teamRepository = repositories[i];
            result.add(teamRepository);
            ++i;
        }
        return result;
    }
}

