/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.containers.common.IFilteredItemContainerQueryParams;
import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.containers.common.IItemContainerHandle;
import com.ibm.team.containers.common.IItemContainerQueryParams;
import com.ibm.team.containers.common.IItemContainerQueryResult;
import com.ibm.team.containers.common.IItemContainerService;
import com.ibm.team.containers.common.internal.dto.DtoFactory;
import com.ibm.team.containers.common.internal.dto.FilteredItemContainerQueryParams;
import com.ibm.team.containers.common.internal.dto.ItemContainerQueryParams;
import com.ibm.team.filesystem.ui.queries.FolderNode;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.QueryItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.RawSnapshotWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ItemContainerQuery
extends RepositoryQuery {
    private IItemContainerHandle parentItem;
    private IItemHandle owner;
    private List<Object> rootContent;
    private boolean foldersOnly;
    private boolean isRootContainer;
    private UUID folderStateOfLastUpdate = null;
    private ISharedItemChangeListener itemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object obj : events) {
                if (!(obj instanceof ISharedItemChangeEvent)) continue;
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)obj;
                if (ItemContainerQuery.this.parentItem == null || !ItemContainerQuery.this.parentItem.sameItemId((IItemHandle)event.getAfterState())) continue;
                final IItemContainerHandle newParent = (IItemContainerHandle)event.getAfterState();
                if (ItemContainerQuery.this.getRepository() == null || newParent == null) continue;
                ItemContainerQuery.this.getOperationRunner().enqueue(Messages.CombinedWorkspacesAndOwnedComponentsQuery_FETCH_FOLDERS_OP_NAME, (Operation)new RepositoryOperation(ItemContainerQuery.this.getRepository()){

                    public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                        if (newParent.getStateId().equals((Object)ItemContainerQuery.this.folderStateOfLastUpdate)) {
                            return;
                        }
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                        EventSorter sorter = new EventSorter(ItemContainerQuery.this.computeElements(), ItemContainerQuery.this.getItems(false, newParent, (IProgressMonitor)progress.newChild(100)));
                        ItemContainerQuery.this.asyncAddElements(sorter.getAddedItems());
                        ItemContainerQuery.this.asyncRemoveElements(sorter.getRemovedItems());
                    }
                });
            }
        }
    };
    private ISharedItemChangeListener itemDeleteListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            ArrayList<AbstractWrapper> toRemove = new ArrayList<AbstractWrapper>(events.size());
            for (Object obj : events) {
                AbstractWrapper wrapper;
                ISharedItemChangeEvent event;
                if (!(obj instanceof ISharedItemChangeEvent) || (event = (ISharedItemChangeEvent)obj).getAfterState() != null) continue;
                IItem deletedItem = event.getSharedItem();
                if (deletedItem instanceof IWorkspace) {
                    wrapper = AbstractPlaceWrapper.newWrapper((IWorkspace)deletedItem);
                    wrapper.setAllowFolderActions(true);
                    toRemove.add(wrapper);
                    continue;
                }
                if (deletedItem instanceof IBaselineSet) {
                    wrapper = new RawSnapshotWrapper((IBaselineSet)deletedItem);
                    wrapper.setAllowFolderActions(true);
                    toRemove.add(wrapper);
                    continue;
                }
                if (!(deletedItem instanceof IQueryItem)) continue;
                wrapper = QueryItemWrapper.newWrapper(ItemContainerQuery.this.getRepository(), (IQueryItem)deletedItem);
                wrapper.setAllowFolderActions(true);
                toRemove.add(wrapper);
            }
            ItemContainerQuery.this.asyncRemoveElements(toRemove);
        }
    };

    public ItemContainerQuery(ITeamRepository repository, IItemHandle owner, IItemContainerHandle parent, IOperationRunner runner, List<Object> rootContent, boolean foldersOnly) {
        super(repository, runner);
        this.owner = owner;
        this.parentItem = parent;
        boolean bl = this.isRootContainer = parent == null;
        if (rootContent == null) {
            this.rootContent = Collections.emptyList();
        } else {
            this.rootContent = rootContent;
            if (!rootContent.isEmpty()) {
                this.setContents(rootContent);
            }
        }
        this.foldersOnly = foldersOnly;
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.rootContent);
        try {
            this.refreshProjectArea(needsRefresh, (IProgressMonitor)progress.newChild(50));
            if (this.getOwner() != null) {
                if (this.parentItem == null) {
                    this.parentItem = this.getRootNode((IProgressMonitor)progress.newChild(10));
                }
                progress.setWorkRemaining(40);
                result.addAll(this.getItems(needsRefresh, this.parentItem, (IProgressMonitor)progress.newChild(40)));
            }
        }
        catch (PermissionDeniedException permissionDeniedException) {
            // empty catch block
        }
        progress.done();
        return result;
    }

    private void refreshProjectArea(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Object o;
        IFetchResult fetchResult;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (needsRefresh && this.getOwner() instanceof IProjectAreaHandle && this.isRootContainer && (fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(Arrays.asList(this.getOwner()), 1, (IProgressMonitor)progress.newChild(25))).getRetrievedItems().size() == 1 && (o = fetchResult.getRetrievedItems().get(0)) instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)o;
            this.getRepository().itemManager().fetchCompleteItemsPermissionAware(projectArea.getTeamAreas(), 1, (IProgressMonitor)progress.newChild(75));
        }
        progress.done();
    }

    private IItemHandle getOwner() {
        if (this.owner instanceof IProjectAreaHandle) {
            return this.owner;
        }
        IContributor loggedInContributor = this.getRepository().loggedInContributor();
        if (loggedInContributor == null || !loggedInContributor.sameItemId(this.owner)) {
            this.parentItem = null;
            this.owner = loggedInContributor;
        }
        return this.owner;
    }

    private IItemContainerHandle getRootNode(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IItemContainer result = null;
        IItemContainerService folderService = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getItemContainerService();
        result = folderService.getRootContainer("com.ibm.team.scm.container.root", this.getOwner(), 0);
        progress.done();
        return result;
    }

    private List<Object> getItems(boolean needsRefresh, IItemContainerHandle parent, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IItemContainerQueryResult queryResult = this.runQuery(parent, (IProgressMonitor)progress.newChild(50));
            if (queryResult == null) {
                progress.done();
                return result;
            }
            int refreshFlag = needsRefresh ? 1 : 0;
            ArrayList<IItemContainerHandle> toFetch = new ArrayList<IItemContainerHandle>(queryResult.getItems());
            if (needsRefresh) {
                toFetch.add(parent);
            }
            IFetchResult fetchResult = this.getRepository().itemManager().fetchCompleteItemsPermissionAware(toFetch, refreshFlag, (IProgressMonitor)progress.newChild(25));
            ArrayList<IBaseline> baselines = new ArrayList<IBaseline>();
            HashMap<UUID, IComponentHandle> components = new HashMap<UUID, IComponentHandle>();
            for (Object obj : fetchResult.getRetrievedItems()) {
                AbstractWrapper wrapper;
                if (obj instanceof IItemContainer) {
                    IItemContainer folder = (IItemContainer)obj;
                    if (folder.sameItemId((IItemHandle)parent)) continue;
                    result.add(new FolderNode(folder));
                    continue;
                }
                if (obj instanceof IWorkspace) {
                    AbstractPlaceWrapper wrapper2 = AbstractPlaceWrapper.newWrapper((IWorkspace)obj);
                    wrapper2.setAllowFolderActions(true);
                    result.add((Object)wrapper2);
                    continue;
                }
                if (obj instanceof IQueryItem) {
                    IQueryItem query = (IQueryItem)obj;
                    if (5 != query.getType() && 2 != query.getType() && 1 != query.getType()) continue;
                    wrapper = QueryItemWrapper.newWrapper(this.getRepository(), (IQueryItem)obj);
                    wrapper.setAllowFolderActions(true);
                    result.add((Object)wrapper);
                    continue;
                }
                if (obj instanceof IBaselineSet) {
                    IBaselineSet snapShot = (IBaselineSet)obj;
                    wrapper = new RawSnapshotWrapper(snapShot);
                    wrapper.setAllowFolderActions(true);
                    result.add((Object)wrapper);
                    continue;
                }
                if (obj instanceof IChangeSet) {
                    IChangeSet changeSet = (IChangeSet)obj;
                    wrapper = new ContributorPlaceChangeSetWrapper(this.getRepository(), changeSet);
                    result.add((Object)wrapper);
                    continue;
                }
                if (!(obj instanceof IBaseline)) continue;
                IBaseline baseline = (IBaseline)obj;
                baselines.add(baseline);
                components.put(baseline.getComponent().getItemId(), baseline.getComponent());
            }
            if (!baselines.isEmpty()) {
                IComponent component;
                HashMap<UUID, IComponent> fetchedComponents = new HashMap<UUID, IComponent>();
                ITeamRepository repo = this.getRepository();
                ArrayList componentHandles = new ArrayList(components.size());
                componentHandles.addAll(components.values());
                fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(componentHandles, 0, (IProgressMonitor)progress.newChild(25));
                for (Object o : fetchResult.getRetrievedItems()) {
                    if (!(o instanceof IComponent)) continue;
                    component = (IComponent)o;
                    fetchedComponents.put(component.getItemId(), component);
                }
                for (IBaseline baseline : baselines) {
                    component = (IComponent)fetchedComponents.get(baseline.getComponent().getItemId());
                    if (component == null) continue;
                    BaselineWrapper wrapper = new BaselineWrapper(this.getRepository(), baseline, component);
                    result.add(wrapper);
                }
            }
            this.folderStateOfLastUpdate = parent.getStateId();
            progress.done();
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private IItemContainerQueryResult runQuery(IItemContainerHandle parent, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.foldersOnly) {
            return this.runContainerOnlyQuery(parent, monitor);
        }
        return this.runAllContentQuery(parent, monitor);
    }

    private IItemContainerQueryResult runAllContentQuery(IItemContainerHandle parent, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ItemContainerQueryParams queryParams = DtoFactory.eINSTANCE.createItemContainerQueryParams();
        queryParams.setContainer(parent);
        queryParams.setFlags(1);
        IItemContainerService folderService = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getItemContainerService();
        IItemContainerQueryResult result = folderService.getChildren((IItemContainerQueryParams)queryParams);
        progress.done();
        return result;
    }

    private IItemContainerQueryResult runContainerOnlyQuery(IItemContainerHandle parent, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FilteredItemContainerQueryParams queryParams = DtoFactory.eINSTANCE.createFilteredItemContainerQueryParams();
        queryParams.setDirection(0);
        queryParams.setContainer(parent);
        queryParams.setFlags(1);
        IItemContainerService folderService = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository()).getItemContainerService();
        IItemContainerQueryResult result = folderService.findContainers((IFilteredItemContainerQueryParams)queryParams);
        progress.done();
        return result;
    }

    protected void attachListeners() {
        this.getRepository().itemManager().addItemChangeListener(IItemContainer.ITEM_TYPE, this.itemChangeListener);
        this.getRepository().itemManager().addItemChangeListener(IWorkspace.ITEM_TYPE, this.itemDeleteListener);
        this.getRepository().itemManager().addItemChangeListener(IBaselineSet.ITEM_TYPE, this.itemDeleteListener);
        this.getRepository().itemManager().addItemChangeListener(IQueryItem.ITEM_TYPE, this.itemDeleteListener);
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IItemContainer.ITEM_TYPE, this.itemChangeListener);
        this.getRepository().itemManager().removeItemChangeListener(IWorkspace.ITEM_TYPE, this.itemDeleteListener);
        this.getRepository().itemManager().removeItemChangeListener(IBaselineSet.ITEM_TYPE, this.itemDeleteListener);
        this.getRepository().itemManager().removeItemChangeListener(IQueryItem.ITEM_TYPE, this.itemDeleteListener);
    }

    public String getName() {
        return Messages.FolderSearchQuery_queryName;
    }

    public class EventSorter {
        private Collection<Object> oldItems;
        private Collection<Object> newItems;
        private Collection<Object> toAdd = new ArrayList<Object>();
        private Collection<Object> toRemove;

        public EventSorter(Collection<Object> oldItems, Collection<Object> newItems) {
            this.oldItems = oldItems;
            this.newItems = newItems;
            this.init();
        }

        private void init() {
            UUID itemId;
            HashMap<UUID, Object> oldMap = new HashMap<UUID, Object>();
            for (Object item : this.oldItems) {
                itemId = this.getItemId(item);
                if (itemId == null) continue;
                oldMap.put(itemId, item);
            }
            for (Object item : this.newItems) {
                Object existingItem;
                itemId = this.getItemId(item);
                if (itemId == null || (existingItem = oldMap.remove(itemId)) != null) continue;
                this.toAdd.add(item);
            }
            this.toRemove = oldMap.values();
        }

        private UUID getItemId(Object item) {
            if (item instanceof FolderNode) {
                return ((FolderNode)item).getItem().getItemId();
            }
            if (item instanceof AbstractWrapper) {
                return ((AbstractWrapper)((Object)item)).getItem().getItemId();
            }
            return null;
        }

        public Collection<Object> getAddedItems() {
            return this.toAdd;
        }

        public Collection<Object> getRemovedItems() {
            return this.toRemove;
        }
    }
}

