/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.ui.queries.HierarchicalRootComponentQuery;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IHierarchyNode;
import com.ibm.team.scm.common.IHierarchyResult;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class HierarchicalSubComponentQuery
extends HierarchicalRootComponentQuery {
    private WorkspaceComponentWrapper fCurrentNode;

    public HierarchicalSubComponentQuery(WorkspaceComponentWrapper currentNode, IOperationRunner runner) {
        super(currentNode.getRepository(), currentNode.getWorkspace(), runner);
        Assert.isNotNull((Object)currentNode, (String)"'WorkspaceComponentWrapper currentNode' cannot be null.");
        Assert.isTrue((currentNode.getHierarchyData() != null ? 1 : 0) != 0, (String)"currentNode.getHierarchicalComponentData() cannot be null");
        this.fCurrentNode = currentNode;
        this.fWsConnection = currentNode.getWorkspaceConnection();
    }

    public HierarchicalSubComponentQuery(WorkspaceComponentWrapper currentNode, ComponentHierarchyCompareResult compareResult, IOperationRunner runner) {
        this(currentNode, runner);
        this.fCompareResult = compareResult;
    }

    public HierarchicalSubComponentQuery(WorkspaceComponentWrapper currentNode, ComponentHierarchyCompareResult compareResult, Map<UUID, StructuralChangesComponentNode> structuralChangesMap, IOperationRunner runner) {
        this(currentNode, compareResult, runner);
        this.fStructuralChangesMap = structuralChangesMap;
    }

    @Override
    public String getName() {
        return Messages.HierarchicalSubComponentQuery_Name;
    }

    @Override
    protected Collection<IComponentHierarchyNode> getChildren(IComponentHierarchyResult hierarchy) {
        final ArrayList<IComponentHierarchyNode> children = new ArrayList<IComponentHierarchyNode>();
        if (this.fCurrentNode.getHierarchyData() != null) {
            final IComponentHierarchyNode parentNode = (IComponentHierarchyNode)this.fCurrentNode.getHierarchyData().getHierarchyNode();
            SubcomponentCommonUtils.visitHierarchy((IHierarchyResult)hierarchy, (SubcomponentCommonUtils.IHierarchyVisitor)new SubcomponentCommonUtils.IHierarchyVisitor(){
                private boolean stopAllVisiting = false;

                public boolean visit(IHierarchyNode node) {
                    if (this.isSameHierarchyNode(node, parentNode)) {
                        children.addAll(node.getChildren());
                        this.stopAllVisiting = true;
                        return false;
                    }
                    return true;
                }

                private boolean isSameHierarchyNode(IHierarchyNode node, IComponentHierarchyNode parentNode2) {
                    return node.getComponentHandle().sameItemId((IItemHandle)parentNode2.getComponentHandle()) && node.getAncestorPath().equals(parentNode2.getAncestorPath());
                }

                public boolean stopAllVisiting() {
                    return this.stopAllVisiting;
                }
            });
        }
        return children;
    }

    @Override
    protected IHierarchicalComponentWrapper getParentWrapper() {
        return (IHierarchicalComponentWrapper)this.fCurrentNode.getHierarchyData().getConfigurationWrapper();
    }

    @Override
    protected WorkspaceComponentWrapper getCurrentNode() {
        return this.fCurrentNode;
    }
}

