/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.queries.HierarchicalRootBaselineQuery;
import com.ibm.team.filesystem.ui.wrapper.BaselineHierarchyData;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalBaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineSetHierarchyResult;
import com.ibm.team.scm.common.IHierarchyNode;
import com.ibm.team.scm.common.IHierarchyResult;
import com.ibm.team.scm.common.internal.subcomponents.SubcomponentCommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;

public class HierarchicalSubBaselineQuery
extends HierarchicalRootBaselineQuery {
    private BaselineWrapper fCurrentNode;

    public HierarchicalSubBaselineQuery(BaselineWrapper currentNode, IOperationRunner runner) {
        super(currentNode.getRepository(), currentNode.getParentSnapshot(), runner);
        Assert.isNotNull((Object)currentNode, (String)"'BaselineWrapper currentNode' cannot be null.");
        Assert.isTrue((currentNode.getHierarchyData() != null ? 1 : 0) != 0, (String)"currentNode.getHierarchyData() cannot be null");
        this.fCurrentNode = currentNode;
    }

    @Override
    public String getName() {
        return Messages.HierarchicalRootBaselineQuery_JobName;
    }

    @Override
    protected Collection<IBaselineHierarchyNode> getChildren(IBaselineSetHierarchyResult snapshotHierarchy) {
        final ArrayList<IBaselineHierarchyNode> children = new ArrayList<IBaselineHierarchyNode>();
        BaselineHierarchyData data = this.fCurrentNode.getHierarchyData();
        if (data != null) {
            if (snapshotHierarchy == null) {
                children.addAll(((IBaselineHierarchyNode)data.getHierarchyNode()).getChildren());
            } else {
                final IBaselineHierarchyNode parentNode = (IBaselineHierarchyNode)this.fCurrentNode.getHierarchyData().getHierarchyNode();
                SubcomponentCommonUtils.visitHierarchy((IHierarchyResult)snapshotHierarchy, (SubcomponentCommonUtils.IHierarchyVisitor)new SubcomponentCommonUtils.IHierarchyVisitor(){
                    private boolean stopAllVisiting = false;

                    public boolean visit(IHierarchyNode node) {
                        if (this.isSameHierarchyNode(node, parentNode)) {
                            children.addAll(node.getChildren());
                            this.stopAllVisiting = true;
                            return false;
                        }
                        return true;
                    }

                    private boolean isSameHierarchyNode(IHierarchyNode node, IBaselineHierarchyNode parentNode2) {
                        return node.getComponentHandle().sameItemId((IItemHandle)parentNode2.getComponentHandle()) && node.getAncestorPath().equals(parentNode2.getAncestorPath());
                    }

                    public boolean stopAllVisiting() {
                        return this.stopAllVisiting;
                    }
                });
            }
        }
        return children;
    }

    @Override
    protected IHierarchicalBaselineWrapper getParentWrapper() {
        return (IHierarchicalBaselineWrapper)this.fCurrentNode.getHierarchyData().getConfigurationWrapper();
    }

    @Override
    protected BaselineWrapper getCurrentNode() {
        return this.fCurrentNode;
    }
}

