/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.common.internal.util.ComponentHierarchyCompareResult;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.MissingWorkspaceComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ComponentHierarchyChangeEvent;
import com.ibm.team.scm.client.internal.LockEvent;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyNode;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubMonitor;

public class HierarchicalRootComponentQuery
extends RepositoryQuery<IHierarchicalComponentWrapper> {
    private final IWorkspace fWorkspace;
    protected IWorkspaceConnection fWsConnection;
    protected ComponentHierarchyCompareResult fCompareResult;
    protected Map<UUID, StructuralChangesComponentNode> fStructuralChangesMap = new HashMap<UUID, StructuralChangesComponentNode>();
    protected IListener fComponentHierarchyListener = new IListener(){

        public void handleEvents(List events) {
            boolean shouldUpdate = false;
            for (Object o : events) {
                ComponentHierarchyChangeEvent event;
                if (!(o instanceof ComponentHierarchyChangeEvent) || !(event = (ComponentHierarchyChangeEvent)o).getEventType().equals("com.ibm.team.scm.ComponentHierarchyUpdate")) continue;
                shouldUpdate = true;
                break;
            }
            if (shouldUpdate) {
                HierarchicalRootComponentQuery.this.update();
            }
        }
    };

    public HierarchicalRootComponentQuery(ITeamRepository repo, IWorkspace workspace, IOperationRunner runner) {
        super(repo, runner);
        Assert.isNotNull((Object)repo, (String)"'ITeamRepository repo' cannot be null.");
        Assert.isNotNull((Object)workspace, (String)"'IWorkspace workspace' cannot be null.");
        Assert.isNotNull((Object)runner, (String)"'IOperationRunner runner' cannot be null.");
        this.fWorkspace = workspace;
    }

    public HierarchicalRootComponentQuery(ITeamRepository repo, IWorkspace workspace, ComponentHierarchyCompareResult compareResult, IOperationRunner runner) {
        this(repo, workspace, runner);
        this.fCompareResult = compareResult;
    }

    public HierarchicalRootComponentQuery(ITeamRepository repo, IWorkspace workspace, ComponentHierarchyCompareResult compareResult, Map<UUID, StructuralChangesComponentNode> structuralChangesMap, IOperationRunner runner) {
        this(repo, workspace, compareResult, runner);
        this.fStructuralChangesMap = structuralChangesMap;
    }

    protected void attachListeners() {
        if (this.fWsConnection != null) {
            this.fWsConnection.addGenericListener((Object)"com.ibm.team.scm.ComponentHierarchyUpdate", this.fComponentHierarchyListener);
        }
    }

    protected void detachListeners() {
        if (this.fWsConnection != null) {
            this.fWsConnection.removeGenericListener((Object)"com.ibm.team.scm.ComponentHierarchyUpdate", this.fComponentHierarchyListener);
        }
    }

    public String getName() {
        return Messages.HierarchicalRootComponentQuery_Name;
    }

    public List<IHierarchicalComponentWrapper> fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.fWsConnection == null) {
                try {
                    this.fWsConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)this.fWorkspace, (IProgressMonitor)progress.newChild(25));
                    this.attachListeners();
                }
                catch (LicenseNotGrantedException e) {
                    List<IHierarchicalComponentWrapper> list = Collections.emptyList();
                    progress.done();
                    return list;
                }
            }
            progress.setWorkRemaining(75);
            if (shouldRefresh) {
                this.fWsConnection.refresh((IProgressMonitor)progress.newChild(25));
            }
            progress.setWorkRemaining(50);
            if (WorkspaceUtil.isDeleted(this.fWsConnection)) {
                List<IHierarchicalComponentWrapper> list = Collections.emptyList();
                return list;
            }
            IComponentHierarchyResult hierarchy = this.fWsConnection.getComponentHierarchy(null);
            Collection<IComponentHierarchyNode> children = this.getChildren(hierarchy);
            ArrayList<IComponentHandle> toFetch = new ArrayList<IComponentHandle>(children.size());
            for (IComponentHierarchyNode child : children) {
                toFetch.add(child.getComponentHandle());
            }
            IFetchResult fetchedResult = this.fWsConnection.teamRepository().itemManager().fetchCompleteItemsPermissionAware(toFetch, 0, (IProgressMonitor)progress.newChild(50));
            Map fetchedComponents = NewCollection.hashMap((int)toFetch.size());
            List fetchedItems = fetchedResult.getRetrievedItems();
            for (Object o : fetchedItems) {
                if (!(o instanceof IComponent)) continue;
                IComponent c = (IComponent)o;
                fetchedComponents.put(c.getItemId(), c);
            }
            HashSet<UUID> componentsInWorkspace = new HashSet<UUID>();
            for (Object o : this.fWsConnection.getComponents()) {
                if (!(o instanceof IComponentHandle)) continue;
                IComponentHandle component = (IComponentHandle)o;
                componentsInWorkspace.add(component.getItemId());
            }
            List<IHierarchicalComponentWrapper> wrappersToReturn = this.getWrappersToReturn(children, componentsInWorkspace, fetchedComponents);
            if (this.getParentWrapper() == null) {
                HashSet<UUID> components = new HashSet<UUID>();
                IHierarchicalComponentWrapper lastWrapper = null;
                for (IHierarchicalComponentWrapper wrapper : wrappersToReturn) {
                    components.add(wrapper.getComponentHandle().getItemId());
                    lastWrapper = wrapper;
                }
                if (lastWrapper != null) {
                    WorkspaceConnection connection = (WorkspaceConnection)lastWrapper.getWorkspaceConnection();
                    connection.queueEvent((Object)new LockEvent((IWorkspaceConnection)connection, "com.ibm.team.scm.LockEvent.ComponentsLocked", components));
                }
            } else {
                Set<UUID> component = Collections.singleton(this.getParentWrapper().getComponentHandle().getItemId());
                WorkspaceConnection connection = (WorkspaceConnection)this.getParentWrapper().getWorkspaceConnection();
                connection.queueEvent((Object)new LockEvent((IWorkspaceConnection)connection, "com.ibm.team.scm.LockEvent.ComponentsLocked", component));
            }
            List<IHierarchicalComponentWrapper> list = wrappersToReturn;
            return list;
        }
        catch (ItemNotFoundException e) {
            List<IHierarchicalComponentWrapper> list = Collections.emptyList();
            return list;
        }
        finally {
            progress.done();
        }
    }

    protected Collection<IComponentHierarchyNode> getChildren(IComponentHierarchyResult hierarchy) {
        return hierarchy.getRoots();
    }

    protected WorkspaceComponentWrapper getCurrentNode() {
        return null;
    }

    protected List<IHierarchicalComponentWrapper> getWrappersToReturn(Collection<IComponentHierarchyNode> nodesToWrap, Set<UUID> componentsInWorkspace, Map<UUID, IComponent> fetchedComponents) {
        ArrayList wrappersToReturn = NewCollection.arrayList((int)nodesToWrap.size());
        for (IComponentHierarchyNode node : nodesToWrap) {
            if (!this.shouldIncludeComponent(node)) continue;
            IComponent fetchedComponent = fetchedComponents.get(node.getComponentHandle().getItemId());
            IHierarchicalComponentWrapper workspaceComponentWrapper = HierarchicalRootComponentQuery.makeWrapper(node, this.fWsConnection, componentsInWorkspace, fetchedComponent, this.getParentWrapper());
            if (this.fCompareResult != null) {
                IComponentHandle parent = this.getCurrentNode() == null ? null : this.getCurrentNode().getComponentHandle();
                IComponentHandle child = workspaceComponentWrapper.getComponentHandle();
                ComponentHierarchyCompareResult.MovedComponentResult moveResult = this.fCompareResult.getMoveResult(parent, child);
                workspaceComponentWrapper.setMoveResult(moveResult);
                workspaceComponentWrapper.setForcedCanAddSubcomponentsValue(false);
                workspaceComponentWrapper.setForcedCanRemoveAsSubcomponentValue(false);
                workspaceComponentWrapper.setForcedCanRemoveComponentValue(true);
                workspaceComponentWrapper.setStructuralChangesComponentNode(this.fStructuralChangesMap.get(child.getItemId()));
            }
            wrappersToReturn.add(workspaceComponentWrapper);
        }
        return wrappersToReturn;
    }

    private boolean shouldIncludeComponent(IComponentHierarchyNode node) {
        if (this.fCompareResult == null) {
            return true;
        }
        if (this.fCompareResult.getPrunedComponentIds() == null) {
            return true;
        }
        return this.fCompareResult.getPrunedComponentIds().contains(node.getComponentHandle().getItemId());
    }

    protected IHierarchicalComponentWrapper getParentWrapper() {
        return null;
    }

    protected static IHierarchicalComponentWrapper makeWrapper(IComponentHierarchyNode componentHierarchyNode, IWorkspaceConnection workspaceConnection, Set<UUID> componentsInWorkspace, IComponent fetchedComponent, IHierarchicalComponentWrapper parent) {
        IComponentHandle componentHandle = componentHierarchyNode.getComponentHandle();
        PlatformObject workspaceComponentWrapper = fetchedComponent == null ? new MissingWorkspaceComponentWrapper(workspaceConnection, componentHandle, null) : (!componentsInWorkspace.contains(fetchedComponent.getItemId()) ? new MissingWorkspaceComponentWrapper(workspaceConnection, componentHandle, fetchedComponent) : WorkspaceComponentWrapper.newWrapper(workspaceConnection, fetchedComponent));
        workspaceComponentWrapper.createHierarchyData(componentHierarchyNode, parent);
        return workspaceComponentWrapper;
    }
}

