/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.IHierarchicalBaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.InaccessibleBaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineHierarchyNode;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IBaselineSetHierarchyResult;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class HierarchicalRootBaselineQuery
extends RepositoryQuery<IHierarchicalBaselineWrapper> {
    private IBaselineSet fSnapshot;

    public HierarchicalRootBaselineQuery(ITeamRepository repo, IBaselineSet snapshot, IOperationRunner runner) {
        super(repo, runner);
        Assert.isNotNull((Object)repo, (String)"'ITeamRepository repo' cannot be null.");
        Assert.isNotNull((Object)runner, (String)"'IOperationRunner runner' cannot be null.");
        this.fSnapshot = snapshot;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    public String getName() {
        return Messages.HierarchicalRootBaselineQuery_JobName;
    }

    public List<IHierarchicalBaselineWrapper> fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            int refreshFlag = shouldRefresh ? 1 : 0;
            IBaselineSetHierarchyResult hierarchy = null;
            if (this.fSnapshot != null) {
                hierarchy = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineSetHierarchy((IBaselineSetHandle)this.fSnapshot, (IProgressMonitor)progress.newChild(50));
            }
            progress.setWorkRemaining(50);
            Collection<IBaselineHierarchyNode> children = this.getChildren(hierarchy);
            ArrayList<IBaselineHandle> baselinesToFetch = new ArrayList<IBaselineHandle>(children.size());
            ArrayList<IComponentHandle> componentsToFetch = new ArrayList<IComponentHandle>(children.size());
            for (IBaselineHierarchyNode child : children) {
                baselinesToFetch.add(child.getBaselineHandle());
                componentsToFetch.add(child.getComponentHandle());
            }
            HashMap<UUID, IBaseline> fetchedBaselines = new HashMap<UUID, IBaseline>();
            HashMap<UUID, IComponent> fetchedComponents = new HashMap<UUID, IComponent>();
            ArrayList<Object> itemsToFetch = new ArrayList<Object>(baselinesToFetch.size() + componentsToFetch.size());
            itemsToFetch.addAll(baselinesToFetch);
            itemsToFetch.addAll(componentsToFetch);
            IFetchResult fetchedResult = repo.itemManager().fetchCompleteItemsPermissionAware(itemsToFetch, refreshFlag, (IProgressMonitor)progress.newChild(50));
            List fetchedItems = fetchedResult.getRetrievedItems();
            for (Object o : fetchedItems) {
                if (o instanceof IBaseline) {
                    IBaseline baseline = (IBaseline)o;
                    fetchedBaselines.put(baseline.getItemId(), baseline);
                    continue;
                }
                if (!(o instanceof IComponent)) continue;
                IComponent component = (IComponent)o;
                fetchedComponents.put(component.getItemId(), component);
            }
            ArrayList wrappersToReturn = NewCollection.arrayList((int)fetchedBaselines.size());
            for (IBaselineHierarchyNode node : children) {
                IBaseline fetchedBaseline = (IBaseline)fetchedBaselines.get(node.getBaselineHandle().getItemId());
                IComponent fetchedComponent = (IComponent)fetchedComponents.get(node.getComponentHandle().getItemId());
                IHierarchicalBaselineWrapper baselineWrapper = null;
                if (fetchedBaseline == null || fetchedComponent == null) {
                    baselineWrapper = new InaccessibleBaselineWrapper(repo, node.getBaselineHandle());
                } else {
                    BaselineWrapper bw = new BaselineWrapper(repo, fetchedBaseline, fetchedComponent);
                    bw.setParentSnapshot(this.fSnapshot);
                    baselineWrapper = bw;
                }
                baselineWrapper.createHierarchyData(node, this.getParentWrapper());
                wrappersToReturn.add(baselineWrapper);
            }
            ArrayList arrayList = wrappersToReturn;
            return arrayList;
        }
        catch (Exception e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
            List<IHierarchicalBaselineWrapper> list = Collections.emptyList();
            return list;
        }
        finally {
            progress.done();
        }
    }

    protected Collection<IBaselineHierarchyNode> getChildren(IBaselineSetHierarchyResult hierarchy) {
        return hierarchy.getRoots();
    }

    protected BaselineWrapper getCurrentNode() {
        return null;
    }

    protected IHierarchicalBaselineWrapper getParentWrapper() {
        return null;
    }
}

