/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.containers.common.IItemContainer;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;

public class FolderNode {
    private IItemContainer folder;
    private String name;
    private ITeamRepository repo;
    private IItemHandle owner;

    public FolderNode(IItemContainer folder) {
        this.folder = folder;
        this.repo = (ITeamRepository)folder.getOrigin();
        this.owner = folder.getOwner();
    }

    public FolderNode(String name, ITeamRepository repo, IItemHandle owner) {
        this.name = name;
        this.repo = repo;
        this.owner = owner;
    }

    public ITeamRepository getRepo() {
        return this.repo;
    }

    public IItemHandle getOwner() {
        return this.owner;
    }

    public String getName() {
        if (this.folder == null) {
            return this.name;
        }
        return this.folder.getName();
    }

    public IItemContainer getItem() {
        return this.folder;
    }

    public boolean inContributorContext() {
        return this.getOwner() instanceof IContributorHandle;
    }

    public boolean inProjectAreaContext() {
        return this.getOwner() instanceof IProjectAreaHandle;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folder == null ? 0 : this.folder.getItemId().hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.getItemId().hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.getRepositoryURI().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FolderNode other = (FolderNode)obj;
        if (this.folder == null ? other.folder != null : !this.folder.sameItemId((IItemHandle)other.folder)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.sameItemId(other.owner)) {
            return false;
        }
        return !(this.repo == null ? other.repo != null : !this.repo.getRepositoryURI().equals(other.repo.getRepositoryURI()));
    }
}

