/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.client.internal.namespace.IConfigurationWrapper;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.queries.AbstractFilesystemQuery;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FolderChildrenQuery
extends AbstractFilesystemQuery {
    private ItemId<IFolder> folderItemWrapper;
    private String folderName;
    private String parentName;

    private FolderChildrenQuery(ItemNamespace workspace, ItemId<IFolder> folderItemWrapper, String folderName, String parentName, AbstractFilesystemQuery.VersionDisplayMode versionDisplayMode, IOperationRunner runner) {
        super(Realm.getDefault(), workspace, versionDisplayMode, runner);
        this.folderItemWrapper = folderItemWrapper;
        this.folderName = folderName;
        this.parentName = parentName;
    }

    public FolderChildrenQuery(ItemNamespace workspace, ItemId<IFolder> folderItemWrapper, String folderName, String parentName, IOperationRunner runner) {
        this(workspace, folderItemWrapper, folderName, parentName, null, runner);
    }

    public FolderChildrenQuery(FolderItemWrapper folder, IOperationRunner operationRunner) {
        this(folder, null, operationRunner);
    }

    public FolderChildrenQuery(FolderItemWrapper folder, AbstractFilesystemQuery.VersionDisplayMode versionDisplayMode, IOperationRunner operationRunner) {
        this(folder.getWorkspace(), (ItemId<IFolder>)folder.getFileItem().getItemId(), folder.getName(), folder.getFQName(), versionDisplayMode, operationRunner);
    }

    public String getName() {
        return MessageFormat.format(Messages.FolderChildrenQuery_0, this.folderName);
    }

    @Override
    protected Map<String, ItemId<IVersionable>> fetchChildren(IProgressMonitor mon) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        IConfigurationWrapper vt = this.getSnapshotProvider((IProgressMonitor)progress.newChild(20));
        if (this.folderItemWrapper.getItemType() != IFolder.ITEM_TYPE) {
            return Collections.emptyMap();
        }
        return vt.fetchChildren(this.folderItemWrapper, (IProgressMonitor)progress.newChild(80));
    }

    @Override
    protected String getParentName() {
        return this.parentName;
    }
}

