/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.internal.util.ItemLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ConnectedProjectAreaQuery
extends RepositoryQuery {
    private ConnectedProjectAreaRegistry registry;
    private IConnectedProjectAreaRegistryListener projectAreaListener = new IConnectedProjectAreaRegistryListener(){

        public void connectedProjectAreaRegistryChanged(IConnectedProjectAreaRegistryChangeEvent changeEvent) {
            ITeamRepository teamRepository = changeEvent.getTeamRepository();
            if (teamRepository == ConnectedProjectAreaQuery.this.getRepository()) {
                ConnectedProjectAreaQuery.this.update();
            }
        }
    };

    public ConnectedProjectAreaQuery(ITeamRepository repository, IOperationRunner runner) {
        super(repository, runner);
        this.registry = ConnectedProjectAreaRegistry.getDefault();
    }

    protected void attachListeners() {
        this.registry.addListener(this.projectAreaListener);
    }

    protected void detachListeners() {
        this.registry.removeListener(this.projectAreaListener);
    }

    protected List fetchResult(boolean needsRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        List list = ItemLists.handlesToIds((Collection)this.registry.getConnectedProjectAreas(this.getRepository()));
        ArrayList result = new ArrayList();
        result.addAll(RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), (Collection)list, (IProgressMonitor)monitor).values());
        return result;
    }

    public String getName() {
        return Messages.ConnectedProjectAreaQuery_0;
    }
}

