/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.filesystem.ui.queries.AbstractBaselineQuery;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.query.PagedQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class ComponentScopedBaselinesQuery
extends AbstractBaselineQuery<BaselineWrapper> {
    private ISharedItemChangeListener itemListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IBaseline baseline;
                IItem item;
                if (event.getAfterState() != null && event.getBeforeState() != null || !((item = event.getSharedItem()) instanceof IBaseline) || !ItemUtil.getComponent((IBaseline)(baseline = (IBaseline)item)).equals((Object)ComponentScopedBaselinesQuery.this.component)) continue;
                ComponentScopedBaselinesQuery.this.update();
                break;
            }
        }
    };
    private ItemId<IComponent> component;

    public ComponentScopedBaselinesQuery(ITeamRepository repoHandle, IWorkspaceHandle sourceWorkspace, IComponentHandle component, IOperationRunner runner) {
        this((ItemLocator<IComponent>)new ItemLocator(repoHandle, (IAuditableHandle)component), Collections.singleton(new ItemId((IItemHandle)sourceWorkspace)), runner);
    }

    public ComponentScopedBaselinesQuery(ItemLocator<IComponent> component, Collection<ItemId<IWorkspace>> sourceWorkspaces, IOperationRunner runner) {
        super(component, sourceWorkspaces, runner);
        this.component = component.getItemId();
    }

    public String getName() {
        return Messages.ComponentBaselinesQuery_0;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
        this.getRepository().itemManager().removeItemChangeListener(IBaseline.ITEM_TYPE, this.itemListener);
    }

    protected ItemId<IComponent> getComponent() {
        return this.component;
    }

    @Override
    protected Collection processPage(List<IBaseline> baselines, AbstractBaselineQuery.WorkspaceRecord wr, Collection result) {
        if (result == null) {
            result = new TreeSet<BaselineWrapper>();
        }
        for (IBaseline baseline : baselines) {
            result.add(new BaselineWrapper(wr.teamRepository(), baseline, wr.getComponent()));
        }
        return result;
    }

    @Override
    protected List<BaselineWrapper> addPage(List<BaselineWrapper> baselines, Collection result) {
        result.addAll(baselines);
        return new ArrayList<BaselineWrapper>(result);
    }

    @Override
    protected PagedQuery.QueryResult<BaselineWrapper> fetchNextPage(int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            PagedQuery.QueryResult queryResult = super.fetchNextPage(pageSize, monitor);
            return queryResult;
        }
        finally {
            this.getRepository().itemManager().removeItemChangeListener(IBaseline.ITEM_TYPE, this.itemListener);
        }
    }
}

