/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AllBaselinesInSnapshotQuery
extends RepositoryQuery<BaselineWrapper> {
    private final IBaselineSet fSnapshot;

    public AllBaselinesInSnapshotQuery(ITeamRepository repo, IBaselineSet snapshot, IOperationRunner runner) {
        super(repo, runner);
        Assert.isNotNull((Object)repo, (String)"'ITeamRepository repo' cannot be null.");
        Assert.isNotNull((Object)snapshot, (String)"'IBaselineSet snapshot' cannot be null.");
        Assert.isNotNull((Object)runner, (String)"'IOperationRunner runner' cannot be null.");
        this.fSnapshot = snapshot;
    }

    protected void attachListeners() {
    }

    protected void detachListeners() {
    }

    public String getName() {
        return Messages.BaselinesInSnapshotQuery_JobName;
    }

    public List<BaselineWrapper> fetchResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponent component;
        ArrayList<BaselineWrapper> baselineWrapperResult = new ArrayList<BaselineWrapper>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ITeamRepository repository = ClientRepositoryUtil.getRepository((IItemHandle)this.fSnapshot);
        HashMap<UUID, IBaseline> baselines = new HashMap<UUID, IBaseline>();
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        ArrayList<IComponentHandle> componentsToFetch = new ArrayList<IComponentHandle>();
        int refreshFlag = shouldRefresh ? 1 : 0;
        IFetchResult baselineFetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(this.fSnapshot.getBaselines(), refreshFlag, (IProgressMonitor)progress.newChild(50));
        for (Object o : baselineFetchResult.getRetrievedItems()) {
            if (!(o instanceof IBaseline)) continue;
            IBaseline baseline = (IBaseline)o;
            baselines.put(baseline.getItemId(), baseline);
            componentsToFetch.add(baseline.getComponent());
        }
        IFetchResult componentFetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(componentsToFetch, refreshFlag, (IProgressMonitor)progress.newChild(50));
        for (Object o : componentFetchResult.getRetrievedItems()) {
            if (!(o instanceof IComponent)) continue;
            component = (IComponent)o;
            components.put(component.getItemId(), component);
        }
        for (IBaseline baseline : baselines.values()) {
            component = (IComponent)components.get(baseline.getComponent().getItemId());
            if (component == null) continue;
            BaselineWrapper wrapper = new BaselineWrapper(repository, baseline, component);
            wrapper.setParentSnapshot(this.fSnapshot);
            baselineWrapperResult.add(wrapper);
        }
        progress.done();
        return baselineWrapperResult;
    }
}

