/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.ui.queries;

import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.util.WorkspaceUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.viewers.RepositoryQuery;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

abstract class AbstractWorkspaceComponentsQuery<T extends WorkspaceComponentWrapper>
extends RepositoryQuery<T> {
    private final IWorkspace fWorkspace;
    private IWorkspaceConnection fWorkspaceConnection;
    private IListener fComponentChangeListener = new IListener(){

        public void handleEvents(List events) {
            boolean shouldUpdate = false;
            for (Object o : events) {
                PropertyChangeEvent event;
                if (!(o instanceof PropertyChangeEvent) || !((event = (PropertyChangeEvent)o).getObject() instanceof IWorkspaceConnection)) continue;
                IWorkspaceConnection wc = (IWorkspaceConnection)event.getObject();
                if (event.getProperty() != "components" || !wc.getResolvedWorkspace().sameItemId((IItemHandle)AbstractWorkspaceComponentsQuery.this.fWorkspace) || (event.getNewValue() == null || !(event.getNewValue() instanceof IComponentHandle) || event.getOldValue() != null) && (event.getOldValue() == null || !(event.getOldValue() instanceof IComponentHandle) || event.getNewValue() != null)) continue;
                shouldUpdate = true;
                break;
            }
            if (shouldUpdate) {
                AbstractWorkspaceComponentsQuery.this.update();
            }
        }
    };

    public AbstractWorkspaceComponentsQuery(ITeamRepository repo, IWorkspace workspace, IOperationRunner runner) {
        super(repo, runner);
        this.fWorkspace = workspace;
    }

    public String getName() {
        return Messages.WorkspaceComponentsQuery_0;
    }

    protected void attachListeners() {
        if (this.fWorkspaceConnection != null) {
            this.fWorkspaceConnection.addGenericListener((Object)"components", this.fComponentChangeListener);
        }
    }

    protected void detachListeners() {
        if (this.fWorkspaceConnection != null) {
            this.fWorkspaceConnection.removeGenericListener((Object)"components", this.fComponentChangeListener);
        }
    }

    protected List<WorkspaceComponentWrapper> fetchFlatResult(boolean shouldRefresh, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = this.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.fWorkspaceConnection == null) {
                try {
                    this.fWorkspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)this.fWorkspace, (IProgressMonitor)progress.newChild(25));
                    this.attachListeners();
                }
                catch (LicenseNotGrantedException e) {
                    return Collections.emptyList();
                }
            }
            progress.setWorkRemaining(75);
            if (shouldRefresh) {
                this.fWorkspaceConnection.refresh((IProgressMonitor)progress.newChild(25));
            }
            progress.setWorkRemaining(50);
            if (WorkspaceUtil.isDeleted(this.fWorkspaceConnection)) {
                return Collections.emptyList();
            }
            return WorkspaceUtil.getComponentWrappers(this.fWorkspaceConnection, (IProgressMonitor)progress.newChild(50));
        }
        catch (ItemNotFoundException e) {
            return Collections.emptyList();
        }
    }
}

